/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.config.ConfigException;
import com.caucho.config.Enhanced;
import com.caucho.config.EnhancedLiteral;
import com.caucho.config.extension.ProcessBeanImpl;
import com.caucho.config.inject.BeanBuilder;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.reflect.AnnotatedTypeImpl;
import com.caucho.inject.LazyExtension;
import com.caucho.inject.Module;
import com.caucho.remote.annotation.ProxyType;
import com.caucho.remote.annotation.ServiceType;
import com.caucho.remote.client.ProtocolProxyFactory;
import com.caucho.remote.server.ProtocolServletFactory;
import com.caucho.server.dispatch.ServletMapping;
import com.caucho.server.webapp.WebApp;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.inject.Qualifier;
import javax.servlet.annotation.WebServlet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class WebAppInjectExtension
implements Extension {
    private InjectManager _beanManager;
    private WebApp _webApp;

    public WebAppInjectExtension(InjectManager manager, WebApp webApp) {
        this._beanManager = manager;
        this._webApp = webApp;
    }

    @LazyExtension
    public void processAnnotatedType(@Observes ProcessAnnotatedType<?> event) {
        try {
            AnnotatedType annotated = event.getAnnotatedType();
            if (annotated == null || annotated.getAnnotations() == null || annotated.isAnnotationPresent(Enhanced.class)) {
                return;
            }
            for (Annotation ann : annotated.getAnnotations()) {
                Class<? extends Annotation> annType = ann.annotationType();
                if (!annType.isAnnotationPresent(ProxyType.class)) continue;
                ProxyType proxyType = annType.getAnnotation(ProxyType.class);
                Class factoryClass = proxyType.defaultFactory();
                ProtocolProxyFactory proxyFactory = (ProtocolProxyFactory)factoryClass.newInstance();
                proxyFactory.setProxyType(ann);
                proxyFactory.setAnnotated((Annotated)annotated);
                Object proxy = proxyFactory.createProxy((Class)annotated.getBaseType());
                AnnotatedTypeImpl annotatedType = new AnnotatedTypeImpl(annotated);
                annotatedType.addAnnotation(EnhancedLiteral.ANNOTATION);
                BeanBuilder builder = this._beanManager.createBeanFactory(annotatedType);
                for (Annotation binding : annotated.getAnnotations()) {
                    Class<? extends Annotation> bindingType = binding.annotationType();
                    if (!bindingType.isAnnotationPresent(Qualifier.class)) continue;
                    builder.qualifier(binding);
                }
                this._beanManager.addBean(builder.singleton(proxy));
                event.veto();
            }
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    @LazyExtension
    public void processBean(@Observes ProcessBeanImpl<?> event) {
        try {
            Annotated annotated = event.getAnnotated();
            Bean<?> bean = event.getBean();
            if (annotated == null || annotated.getAnnotations() == null || annotated.isAnnotationPresent(Enhanced.class)) {
                return;
            }
            for (Annotation ann : annotated.getAnnotations()) {
                Class<? extends Annotation> annType = ann.annotationType();
                if (annType.equals(WebServlet.class)) {
                    WebServlet webServlet = (WebServlet)ann;
                    ServletMapping mapping = new ServletMapping();
                    for (String value : webServlet.value()) {
                        mapping.addURLPattern(value);
                    }
                    for (String value : webServlet.urlPatterns()) {
                        mapping.addURLPattern(value);
                    }
                    mapping.setBean(bean);
                    mapping.init();
                    this._webApp.addServletMapping(mapping);
                    event.veto();
                    continue;
                }
                if (annType.isAnnotationPresent(ServiceType.class)) {
                    ServiceType serviceType = annType.getAnnotation(ServiceType.class);
                    Class factoryClass = serviceType.defaultFactory();
                    ProtocolServletFactory factory = (ProtocolServletFactory)factoryClass.newInstance();
                    factory.setServiceType(ann);
                    factory.setAnnotated(annotated);
                    Method urlPatternMethod = annType.getMethod("urlPattern", new Class[0]);
                    String urlPattern = (String)urlPatternMethod.invoke((Object)ann, new Object[0]);
                    ServletMapping mapping = new ServletMapping();
                    mapping.addURLPattern(urlPattern);
                    mapping.setBean(bean);
                    mapping.setProtocolFactory(factory);
                    mapping.init();
                    this._webApp.addServletMapping(mapping);
                    continue;
                }
                if (!annType.isAnnotationPresent(ProxyType.class)) continue;
                event.veto();
            }
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

