/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.config.ConfigException;
import com.caucho.env.deploy.ExpandVersion;
import com.caucho.server.webapp.WebApp;
import com.caucho.server.webapp.WebAppAdmin;
import com.caucho.server.webapp.WebAppContainer;
import com.caucho.server.webapp.WebAppController;
import com.caucho.server.webapp.WebAppExpandDeployGenerator;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;

public class WebAppVersioningController
extends WebAppController {
    private static final L10N L = new L10N(WebAppVersioningController.class);
    private static final Logger log = Logger.getLogger(WebAppController.class.getName());
    private static final long EXPIRE_PERIOD = 3600000L;
    private final String _baseKey;
    private long _versionRolloverTime = 3600000L;
    private ArrayList<WebAppController> _controllerList = new ArrayList();
    private final WebAppExpandDeployGenerator _generator;
    private long _restartTime;
    private ExpandVersion _primaryVersion;
    private WebAppController _primaryController;
    private boolean _isModified = true;
    private AtomicBoolean _isUpdating = new AtomicBoolean();

    public WebAppVersioningController(String id, String baseKey, String contextPath, WebAppExpandDeployGenerator generator, WebAppContainer container) {
        super(id + "-0.0.0.versioning", null, container, contextPath);
        this._baseKey = baseKey;
        this._generator = generator;
    }

    void setModified(boolean isModified) {
        this._isModified = isModified;
    }

    public boolean isVersioning() {
        return true;
    }

    public String getVersion() {
        if (this._primaryController != null) {
            return this._primaryController.getVersion();
        }
        return "";
    }

    public WebAppAdmin getAdmin() {
        if (this._primaryController != null) {
            return this._primaryController.getAdmin();
        }
        return null;
    }

    public WebApp instantiateDeployInstance() {
        this.updateVersion();
        WebAppController controller = this._primaryController;
        if (controller != null) {
            WebApp webApp = (WebApp)controller.request();
            return webApp;
        }
        throw new NullPointerException(this.getClass().getName());
    }

    protected WebApp startImpl() {
        super.startImpl();
        this.updateVersion();
        WebAppController controller = this._primaryController;
        if (controller != null) {
            return (WebApp)controller.request();
        }
        return null;
    }

    protected void destroyInstance(WebApp instance) {
    }

    protected void initBegin() {
    }

    public boolean isModified() {
        return this._isModified;
    }

    public void updateVersion() {
        this.updateVersionImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateVersionImpl() {
        block14: {
            block13: {
                if (!this._isUpdating.compareAndSet(false, true)) {
                    return;
                }
                try {
                    WebAppVersioningController webAppVersioningController = this;
                    synchronized (webAppVersioningController) {
                        ExpandVersion oldPrimaryVersion = this._primaryVersion;
                        WebAppController oldPrimaryController = this._primaryController;
                        WebAppController newPrimaryController = null;
                        ExpandVersion version = this._generator.getPrimaryVersion(this._baseKey);
                        if (oldPrimaryVersion != null && oldPrimaryVersion.equals(version)) {
                            // MONITOREXIT @DISABLED, blocks:[0, 4, 10] lbl11 : MonitorExitStatement: MONITOREXIT : var1_1
                            Object var12_6 = null;
                            this._isUpdating.set(false);
                            return;
                        }
                        if (version != null) {
                            newPrimaryController = this._generator.createVersionController(version);
                            newPrimaryController.merge(newPrimaryController);
                        }
                        if (newPrimaryController == null) {
                            throw new ConfigException(L.l(this + " does not have an implementing version"));
                        }
                        if (newPrimaryController == oldPrimaryController) {
                            // MONITOREXIT @DISABLED, blocks:[0, 4, 12] lbl22 : MonitorExitStatement: MONITOREXIT : var1_1
                            break block13;
                        }
                        log.fine(this + " updating primary to " + newPrimaryController);
                        if (oldPrimaryController != null && oldPrimaryController != newPrimaryController) {
                            this._controllerList.add(oldPrimaryController);
                        }
                        newPrimaryController.setVersionAlias(true);
                        this._primaryController = newPrimaryController;
                        this._primaryVersion = version;
                        this._controllerList.remove(newPrimaryController);
                        int size = this._controllerList.size();
                        if (size > 0) {
                            WebAppController oldController = this._controllerList.get(size - 1);
                            long expireTime = Alarm.getCurrentTime() + this._versionRolloverTime;
                            this._primaryController.setOldWebApp(oldController, expireTime);
                        }
                        this._restartTime = Alarm.getCurrentTime();
                    }
                    break block14;
                }
                catch (Throwable throwable) {
                    Object var12_9 = null;
                    this._isUpdating.set(false);
                    throw throwable;
                }
            }
            Object var12_7 = null;
            this._isUpdating.set(false);
            return;
        }
        Object var12_8 = null;
        this._isUpdating.set(false);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getId() + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class VersionNameComparator
    implements Comparator<String> {
        VersionNameComparator() {
        }

        @Override
        public int compare(String versionA, String versionB) {
            int lengthA = versionA.length();
            int lengthB = versionB.length();
            int indexA = 0;
            int indexB = 0;
            while (indexA < lengthA && indexB < lengthB) {
                char chB;
                char chA;
                int valueA = 0;
                int valueB = 0;
                while (indexA < lengthA && '0' <= (chA = versionA.charAt(indexA)) && chA <= '9') {
                    valueA = 10 * valueA + chA - 48;
                    ++indexA;
                }
                while (indexB < lengthB && '0' <= (chB = versionB.charAt(indexB)) && chB <= '9') {
                    valueB = 10 * valueB + chB - 48;
                    ++indexB;
                }
                if (valueA < valueB) {
                    return 1;
                }
                if (valueB < valueA) {
                    return -1;
                }
                while (!(indexA >= lengthA || indexB >= lengthB || '0' <= (chA = versionA.charAt(indexA)) && chA <= '9' || '0' <= (chB = versionB.charAt(indexB)) && chB <= '9')) {
                    if (chA < chB) {
                        return 1;
                    }
                    if (chB < chA) {
                        return -1;
                    }
                    ++indexA;
                    ++indexB;
                }
                if (indexA < lengthA && ('0' > (chA = versionA.charAt(indexA)) || chA > '9')) {
                    return 1;
                }
                if (indexB >= lengthB || '0' <= (chB = versionB.charAt(indexB)) && chB <= '9') continue;
                return -1;
            }
            if (indexA != lengthA) {
                return 1;
            }
            if (indexB != lengthB) {
                return -1;
            }
            return 0;
        }
    }
}

