/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webbeans;

import com.caucho.config.scope.AbstractScopeContext;
import com.caucho.config.scope.ContextContainer;
import com.caucho.util.L10N;
import com.caucho.util.RandomUtil;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Conversation;
import javax.enterprise.context.ConversationScoped;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversationContext
extends AbstractScopeContext
implements Conversation,
Serializable {
    private static final Logger log = Logger.getLogger(ConversationContext.class.getName());
    private static final L10N L = new L10N(ConversationContext.class);
    private static final long DEFAULT_TIMEOUT = 120000L;

    @Override
    public boolean isActive() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return facesContext != null;
    }

    public boolean isTransient() {
        Scope scope = this.getJsfScope();
        return scope == null || scope._extendedId == null;
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return ConversationScoped.class;
    }

    @Override
    protected ContextContainer getContextContainer() {
        Scope scope = this.getJsfScope();
        if (scope != null) {
            return scope._transientConversation;
        }
        return null;
    }

    @Override
    protected ContextContainer createContextContainer() {
        Scope scope = this.createJsfScope();
        if (scope._transientConversation == null) {
            scope._transientConversation = scope._extendedConversation;
            if (scope._transientConversation == null) {
                scope._transientConversation = new ContextContainer();
            }
        }
        return scope._transientConversation;
    }

    public void begin() {
        StringBuilder sb = new StringBuilder();
        sb.append(RandomUtil.getRandomLong() & Long.MAX_VALUE);
        this.begin(sb.toString());
    }

    public void begin(String name) {
        Scope scope = this.createJsfScope();
        if (scope._extendedId != null) {
            throw new IllegalStateException(L.l("Conversation begin() must only be called when a long-running conversation does not exist."));
        }
        scope._extendedId = name;
        scope._extendedConversation = scope._transientConversation;
    }

    public void end() {
        Scope scope = this.getJsfScope();
        if (scope == null) {
            return;
        }
        if (scope._extendedId == null) {
            throw new IllegalStateException(L.l("Conversation end() must only be called when a long-running conversation exists."));
        }
        scope._extendedId = null;
        scope._extendedConversation = null;
    }

    public String getId() {
        Scope scope = this.getJsfScope();
        if (scope != null) {
            return scope._extendedId;
        }
        return null;
    }

    public long getTimeout() {
        Scope scope = this.createJsfScope();
        return scope.getTimeout();
    }

    public void setTimeout(long timeout) {
        try {
            Scope scope = this.createJsfScope();
            scope.setTimeout(timeout);
        }
        catch (RuntimeException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    private Scope getJsfScope() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            return null;
        }
        return this.getJsfScope(facesContext, false);
    }

    private Scope createJsfScope() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            throw new IllegalStateException(L.l("@ConversationScoped is not available because JSF is not active"));
        }
        return this.getJsfScope(facesContext, true);
    }

    private Scope getJsfScope(FacesContext facesContext, boolean isCreate) {
        ExternalContext extContext = facesContext.getExternalContext();
        Map sessionMap = extContext.getSessionMap();
        Scope scope = (Scope)sessionMap.get("caucho.conversation");
        if (scope == null) {
            if (!isCreate) {
                return null;
            }
            scope = new Scope();
            sessionMap.put("caucho.conversation", scope);
        }
        if (scope._transientConversation == null) {
            scope._transientConversation = scope._extendedConversation;
        }
        return scope;
    }

    public void destroy() {
        Scope scope = this.getJsfScope();
        if (scope == null) {
            return;
        }
        ContextContainer context = scope._transientConversation;
        scope._transientConversation = null;
        if (scope._extendedConversation == null && context != null) {
            context.close();
        }
    }

    static class Scope
    implements Serializable,
    HttpSessionBindingListener {
        ContextContainer _transientConversation;
        String _extendedId;
        ContextContainer _extendedConversation;
        private long _timeout = 120000L;

        Scope() {
        }

        public long getTimeout() {
            return this._timeout;
        }

        public void setTimeout(long timeout) {
            this._timeout = timeout;
        }

        public void valueBound(HttpSessionBindingEvent event) {
        }

        public void valueUnbound(HttpSessionBindingEvent event) {
            ContextContainer conversation = this._extendedConversation;
            if (conversation != null) {
                conversation.close();
            }
            this._extendedConversation = null;
        }
    }
}

