/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webbeans;

import com.caucho.config.scope.AbstractScopeContext;
import com.caucho.config.scope.ContextContainer;
import com.caucho.inject.Module;
import com.caucho.inject.TransactionScoped;
import com.caucho.server.webbeans.XAContextContainer;
import com.caucho.transaction.TransactionImpl;
import com.caucho.transaction.TransactionManagerImpl;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.transaction.Synchronization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class TransactionScope
extends AbstractScopeContext {
    private static final L10N L = new L10N(TransactionScope.class);
    private TransactionManagerImpl _xaManager = TransactionManagerImpl.getInstance();

    @Override
    public boolean isActive() {
        return this._xaManager.getTransaction() != null;
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return TransactionScoped.class;
    }

    @Override
    protected ContextContainer getContextContainer() {
        TransactionImpl xa = this._xaManager.getCurrent();
        if (xa == null || !xa.isActive()) {
            return null;
        }
        return (ContextContainer)xa.getResource("caucho.xa.scope");
    }

    @Override
    protected ContextContainer createContextContainer() {
        TransactionImpl xa = this._xaManager.getCurrent();
        if (xa == null || !xa.isActive()) {
            return null;
        }
        XAContextContainer context = (XAContextContainer)xa.getResource("caucho.xa.scope");
        if (context == null) {
            context = new XAContextContainer();
            xa.setAttribute("caucho.xa.scope", context);
            xa.registerSynchronization(context);
        }
        return context;
    }

    @Override
    public <T> T get(Contextual<T> bean, CreationalContext<T> creationalContext) {
        Object result;
        TransactionImpl xa = this._xaManager.getCurrent();
        if (xa == null || !xa.isActive()) {
            throw new ContextNotActiveException(L.l("'{0}' cannot be created because @TransactionScoped requires an active transaction.", bean));
        }
        ScopeContext cxt = (ScopeContext)xa.getResource("caucho.xa.scope");
        if (cxt == null) {
            cxt = new ScopeContext();
            xa.putResource((Object)"caucho.xa.scope", cxt);
            xa.registerSynchronization(cxt);
        }
        if ((result = cxt.get(bean)) != null || creationalContext == null) {
            return result;
        }
        result = bean.create(creationalContext);
        Object id = null;
        cxt.put(bean, id, result, creationalContext);
        return result;
    }

    static class ScopeContext
    extends ContextContainer
    implements Synchronization {
        ScopeContext() {
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            this.close();
        }
    }
}

