/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.servlets.ssi;

import com.caucho.VersionFactory;
import com.caucho.servlets.ssi.SSIExpr;
import com.caucho.util.Alarm;
import com.caucho.util.IntMap;
import com.caucho.util.QDate;
import com.caucho.vfs.Path;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class VarExpr
extends SSIExpr {
    private static final int ATTRIBUTE = 0;
    private static final int HTTP_ = 1;
    private static final int SERVER_SOFTWARE = 2;
    private static final int SERVER_NAME = 3;
    private static final int SERVER_ADDR = 4;
    private static final int SERVER_PORT = 5;
    private static final int REMOTE_ADDR = 6;
    private static final int REMOTE_PORT = 7;
    private static final int REMOTE_USER = 8;
    private static final int AUTH_TYPE = 9;
    private static final int GATEWAY_INTERFACE = 10;
    private static final int SERVER_PROTOCOL = 11;
    private static final int REQUEST_METHOD = 12;
    private static final int QUERY_STRING = 13;
    private static final int REQUEST_URI = 14;
    private static final int SCRIPT_FILENAME = 15;
    private static final int SCRIPT_NAME = 16;
    private static final int PATH_INFO = 17;
    private static final int PATH_TRANSLATED = 18;
    private static final int CONTENT_LENGTH = 19;
    private static final int CONTENT_TYPE = 20;
    private static final int DATE_GMT = 21;
    private static final int DATE_LOCAL = 22;
    private static final int DOCUMENT_NAME = 23;
    private static final int DOCUMENT_URI = 24;
    private static final int LAST_MODIFIED = 25;
    private static final int USER_NAME = 26;
    private static final IntMap _varMap = new IntMap();
    private final int _code;
    private final String _var;
    private final Path _path;

    VarExpr(String var, Path path) {
        int code = _varMap.get(var.toLowerCase());
        if (code <= 0) {
            if (var.startsWith("HTTP_")) {
                var = var.substring(5).replace('_', '-').toLowerCase();
                code = 1;
            } else {
                code = 0;
            }
        }
        this._code = code;
        this._var = var;
        this._path = path;
    }

    public String evalString(HttpServletRequest request, HttpServletResponse response) {
        String value = null;
        Object attr = null;
        switch (this._code) {
            case 0: {
                attr = request.getParameter(this._var);
                if (attr == null) {
                    attr = request.getAttribute(this._var);
                }
                value = String.valueOf(attr);
                break;
            }
            case 1: {
                value = request.getHeader(this._var);
                break;
            }
            case 2: {
                value = "Resin/" + VersionFactory.getVersion();
                break;
            }
            case 3: 
            case 4: {
                value = request.getServerName();
                break;
            }
            case 5: {
                value = String.valueOf(request.getServerPort());
                break;
            }
            case 6: {
                value = request.getServerName();
                break;
            }
            case 7: {
                value = String.valueOf(request.getServerPort());
                break;
            }
            case 8: {
                value = request.getRemoteUser();
                break;
            }
            case 9: {
                value = request.getAuthType();
                break;
            }
            case 10: {
                value = "CGI/1.1";
                break;
            }
            case 11: {
                value = request.getProtocol();
                break;
            }
            case 12: {
                value = request.getMethod();
                break;
            }
            case 13: {
                value = request.getQueryString();
                break;
            }
            case 14: {
                value = request.getRequestURI();
                break;
            }
            case 17: {
                value = request.getPathInfo();
                break;
            }
            case 18: {
                value = request.getRealPath(request.getPathInfo());
                break;
            }
            case 19: {
                value = String.valueOf(request.getContentLength());
                break;
            }
            case 20: {
                value = request.getHeader("Content-Type");
                break;
            }
            case 21: {
                String fmt = (String)request.getAttribute("caucho.ssi.timefmt");
                if (fmt == null) {
                    fmt = "%Y-%m-%d %H:%M:%S";
                }
                value = QDate.formatGMT(Alarm.getCurrentTime(), fmt);
                break;
            }
            case 22: {
                String fmt = (String)request.getAttribute("caucho.ssi.timefmt");
                if (fmt == null) {
                    fmt = "%Y-%m-%d %H:%M:%S";
                }
                value = QDate.formatLocal(Alarm.getCurrentTime(), fmt);
                break;
            }
            case 23: {
                value = this._path.getTail();
                break;
            }
            case 24: {
                value = request.getRequestURI();
                break;
            }
            case 25: {
                String fmt = (String)request.getAttribute("caucho.ssi.timefmt");
                if (fmt == null) {
                    fmt = "%Y-%m-%d %H:%M:%S";
                }
                value = QDate.formatLocal(this._path.getLastModified(), fmt);
                break;
            }
        }
        if (value != null) {
            return value;
        }
        return "(null)";
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._var + "]";
    }

    static {
        _varMap.put("server_software", 2);
        _varMap.put("server_name", 3);
        _varMap.put("server_addr", 4);
        _varMap.put("server_port", 5);
        _varMap.put("remote_addr", 6);
        _varMap.put("remote_port", 7);
        _varMap.put("remote_user", 8);
        _varMap.put("auth_type", 9);
        _varMap.put("gateway_interface", 10);
        _varMap.put("server_protocol", 11);
        _varMap.put("request_method", 12);
        _varMap.put("query_string", 13);
        _varMap.put("request_uri", 14);
        _varMap.put("script_filename", 15);
        _varMap.put("script_name", 16);
        _varMap.put("path_info", 17);
        _varMap.put("path_translated", 18);
        _varMap.put("content_length", 19);
        _varMap.put("content_type", 20);
        _varMap.put("date_gmt", 21);
        _varMap.put("date_local", 22);
        _varMap.put("document_name", 23);
        _varMap.put("document_uri", 24);
        _varMap.put("last_modified", 25);
        _varMap.put("user_name", 26);
    }
}

