/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql;

import com.caucho.config.ConfigException;
import com.caucho.config.Names;
import com.caucho.config.inject.BeanBuilder;
import com.caucho.config.inject.CurrentLiteral;
import com.caucho.config.inject.HandleAware;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.types.InitParam;
import com.caucho.config.types.Period;
import com.caucho.jca.ra.ResourceManagerImpl;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.management.server.JdbcDriverMXBean;
import com.caucho.naming.Jndi;
import com.caucho.sql.ConnectionConfig;
import com.caucho.sql.DBPoolImpl;
import com.caucho.sql.DataSourceImpl;
import com.caucho.sql.DatabaseAdmin;
import com.caucho.sql.DatabaseConfig;
import com.caucho.sql.DriverConfig;
import com.caucho.sql.ManagedConnectionImpl;
import com.caucho.sql.QueryAdmin;
import com.caucho.transaction.ConnectionPool;
import com.caucho.transaction.TransactionManagerImpl;
import com.caucho.util.L10N;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Qualifier;
import javax.resource.spi.ManagedConnectionFactory;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBPool
implements DataSource,
Serializable,
HandleAware {
    protected static final Logger log = Logger.getLogger(DBPool.class.getName());
    private static final L10N L = new L10N(DBPool.class);
    private EnvironmentLocal<DBPoolImpl> _localPoolImpl;
    private EnvironmentLocal<DataSource> _localDataSourceImpl;
    private String _var;
    private String _name;
    private String _jndiName;
    private ArrayList<Annotation> _bindingList = new ArrayList();
    private ResourceManagerImpl _resourceManager;
    private ConnectionPool _connectionPool;
    private DBPoolImpl _poolImpl;
    private DataSource _dataSource;
    private DataSourceImpl _resinDataSource;
    private Object _serializationHandle;
    private QueryAdmin _queryAdmin = new QueryAdmin(this);
    private DatabaseAdmin _databaseAdmin;

    public DBPool() {
        this._poolImpl = new DBPoolImpl();
        this._resourceManager = ResourceManagerImpl.createLocalManager();
        this._connectionPool = this._resourceManager.createConnectionPool();
        this._databaseAdmin = new DatabaseAdmin(this, this._connectionPool);
        DatabaseConfig.configDefault(this);
    }

    public String getJndiName() {
        return this._jndiName;
    }

    public void setJndiName(String name) {
        this._jndiName = name;
        if (this._var == null && this._name == null) {
            this.getPool().setName(name);
        }
    }

    public void setName(String name) {
        this._name = name;
        this.getPool().setName(name);
    }

    public void setVar(String var) {
        this._var = var;
        if (this._name == null) {
            this.getPool().setName(var);
        }
    }

    public String getName() {
        return this.getPool().getName();
    }

    public void addAnnotation(Annotation ann) {
        if (!ann.annotationType().isAnnotationPresent(Qualifier.class)) {
            throw new ConfigException(L.l("'{0}' is an unsupported annotation for <database>."));
        }
        this._bindingList.add(ann);
    }

    public DriverConfig createDriver() throws ConfigException {
        return this.getPool().createDriver();
    }

    public DriverConfig createBackupDriver() throws ConfigException {
        return this.getPool().createBackupDriver();
    }

    public void add(DataSource dataSource) {
        DriverConfig config = this.createDriver();
        config.setDriverObject(dataSource);
    }

    public void add(ConnectionPoolDataSource dataSource) {
        DriverConfig config = this.createDriver();
        config.setDriverObject(dataSource);
    }

    public void add(XADataSource dataSource) {
        DriverConfig config = this.createDriver();
        config.setDriverObject(dataSource);
    }

    public void setInitParam(InitParam init) {
        this.getPool().setInitParam(init);
    }

    public void setJDBCDriver(Driver jdbcDriver) throws SQLException {
        this.getPool().setJDBCDriver(jdbcDriver);
    }

    public JdbcDriverMXBean[] getDriverAdmin() {
        return this.getPool().getDriverAdmin();
    }

    public ConnectionConfig createConnection() throws ConfigException {
        return this.getPool().createConnection();
    }

    public void setPoolDataSource(ConnectionPoolDataSource poolDataSource) throws SQLException {
        this.getPool().setPoolDataSource(poolDataSource);
    }

    public void setXADataSource(XADataSource xaDataSource) throws SQLException {
        this.getPool().setXADataSource(xaDataSource);
    }

    public void setURL(String url) throws ConfigException {
        this.getPool().setURL(url);
    }

    public String getURL() {
        return this.getPool().getURL();
    }

    public String getUser() {
        return this.getPool().getUser();
    }

    public void setUser(String user) {
        this.getPool().setUser(user);
    }

    public String getPassword() {
        return this.getPool().getPassword();
    }

    public void setPassword(String password) {
        this.getPool().setPassword(password);
    }

    public int getMaxConnections() {
        return this._connectionPool.getMaxConnections();
    }

    public void setMaxConnections(int maxConnections) throws ConfigException {
        this._connectionPool.setMaxConnections(maxConnections);
    }

    public int getTotalConnections() {
        return this._connectionPool.getConnectionCount();
    }

    public void setConnectionWaitTime(Period waitTime) {
        this._connectionPool.setConnectionWaitTime(waitTime);
    }

    public long getConnectionWaitTime() {
        return this._connectionPool.getConnectionWaitTime();
    }

    public void setMaxOverflowConnections(int maxOverflowConnections) {
        this._connectionPool.setMaxOverflowConnections(maxOverflowConnections);
    }

    public void setMaxCreateConnections(int maxCreateConnections) throws ConfigException {
        this._connectionPool.setMaxCreateConnections(maxCreateConnections);
    }

    public void setSaveAllocationStackTrace(boolean save) {
        this._connectionPool.setSaveAllocationStackTrace(save);
    }

    public void setCloseDanglingConnections(boolean isClose) {
        this._connectionPool.setCloseDanglingConnections(isClose);
    }

    public int getMaxOverflowConnections() {
        return this._connectionPool.getMaxOverflowConnections();
    }

    public int getActiveConnections() {
        return this._connectionPool.getConnectionActiveCount();
    }

    public int getMaxIdleCount() {
        return this._connectionPool.getMaxIdleCount();
    }

    public void setMaxIdleCount(int count) {
        this._connectionPool.setMaxIdleCount(count);
    }

    public long getMaxIdleTime() {
        return this._connectionPool.getMaxIdleTime();
    }

    public void setMaxIdleTime(Period idleTime) {
        this._connectionPool.setMaxIdleTime(idleTime.getPeriod());
    }

    public long getMaxPoolTime() {
        return this._connectionPool.getMaxPoolTime();
    }

    public void setMaxPoolTime(Period maxPoolTime) {
        this._connectionPool.setMaxPoolTime(maxPoolTime.getPeriod());
    }

    public long getMaxActiveTime() {
        return this._connectionPool.getMaxActiveTime();
    }

    public void setMaxActiveTime(Period maxActiveTime) {
        this._connectionPool.setMaxActiveTime(maxActiveTime.getPeriod());
    }

    public String getPingTable() {
        return this.getPool().getPingTable();
    }

    public void setPingTable(String pingTable) {
        this.getPool().setPingTable(pingTable);
    }

    public void setPingQuery(String pingQuery) {
        this.getPool().setPingQuery(pingQuery);
    }

    public boolean getPingOnReuse() {
        return this.getPool().getPingOnReuse();
    }

    public void setPingOnReuse(boolean pingOnReuse) {
        this.getPool().setPingOnReuse(pingOnReuse);
    }

    public boolean getPingOnIdle() {
        return this.getPool().getPingOnIdle();
    }

    public void setPingOnIdle(boolean pingOnIdle) {
        this.getPool().setPingOnIdle(pingOnIdle);
    }

    public void setPing(boolean ping) {
        this.getPool().setPing(ping);
    }

    public void setPingInterval(Period interval) {
        this.getPool().setPingInterval(interval);
    }

    public long getPingInterval() {
        return this.getPool().getPingInterval();
    }

    public int getPreparedStatementCacheSize() {
        return this.getPool().getPreparedStatementCacheSize();
    }

    public void setPreparedStatementCacheSize(int size) {
        this.getPool().setPreparedStatementCacheSize(size);
    }

    public void setTransactionManager(TransactionManagerImpl tm) {
        this.getPool().setTransactionManager(tm);
    }

    public void setWrapStatements(boolean isWrap) {
        this.getPool().setWrapStatements(isWrap);
    }

    public void setTransactionTimeout(Period period) {
        this.getPool().setTransactionTimeout(period);
    }

    public boolean isXA() {
        return this.getPool().isXA();
    }

    public void setXA(boolean isTransactional) {
        this.getPool().setXA(isTransactional);
    }

    public void setXAForbidSameRM(boolean isXAForbidSameRM) {
        this.getPool().setXAForbidSameRM(isXAForbidSameRM);
    }

    public void setSpy(boolean isSpy) throws IOException {
        this.getPool().setSpy(isSpy);
    }

    public boolean isSpy() {
        return this.getPool().isSpy();
    }

    @Override
    public void setSerializationHandle(Object handle) {
        this._serializationHandle = handle;
    }

    @PostConstruct
    public void init() throws Exception {
        this._localPoolImpl = new EnvironmentLocal("caucho.db-pool." + this.getName());
        this._localPoolImpl.set(this._poolImpl);
        this._poolImpl.init();
        this._connectionPool.setName(this.getName());
        this._connectionPool.setShareable(true);
        this._connectionPool.setXATransaction(this._poolImpl.isXATransaction());
        this._connectionPool.setLocalTransaction(this._poolImpl.isLocalTransaction());
        ManagedConnectionFactory mcf = this._poolImpl.getManagedConnectionFactory();
        this._dataSource = (DataSource)this._connectionPool.init(mcf);
        this._connectionPool.start();
        this._localDataSourceImpl = new EnvironmentLocal("caucho.data-source." + this.getName());
        this._localDataSourceImpl.set(this._dataSource);
        if (this._jndiName != null) {
            String name = this._jndiName;
            Jndi.bindDeepShort(name, this);
        }
        InjectManager manager = InjectManager.create();
        BeanBuilder<DataSource> factory = manager.createBeanFactory(DataSource.class);
        String name = this._name;
        if (name == null) {
            name = this._jndiName;
        }
        if (name == null) {
            name = this._var;
        }
        if (this._bindingList.size() > 0) {
            factory.binding(this._bindingList);
        } else {
            if (name != null) {
                factory.qualifier((Annotation)Names.create(name));
            }
            factory.qualifier((Annotation)CurrentLiteral.CURRENT);
        }
        if (name != null) {
            factory.name(name);
        }
        manager.addBean(factory.singleton(this));
        this._queryAdmin.register();
        this._databaseAdmin.register();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getDataSource().getConnection();
    }

    @Override
    public Connection getConnection(String user, String password) throws SQLException {
        return this.getDataSource().getConnection(user, password);
    }

    public void closeIdleConnections() {
        ConnectionPool connectionPool = this._connectionPool;
        if (connectionPool != null) {
            connectionPool.clear();
        }
    }

    public void markForPoolRemoval(ManagedConnectionImpl mConn) {
        this._connectionPool.markForPoolRemoval(mConn);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.getDataSource().getLoginTimeout();
    }

    @Override
    public void setLoginTimeout(int timeout) throws SQLException {
        this.getDataSource().setLoginTimeout(timeout);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.getDataSource().getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter log) throws SQLException {
        this.getDataSource().setLogWriter(log);
    }

    private DBPoolImpl getPool() {
        if (this._poolImpl == null || this._poolImpl.isClosed()) {
            this._poolImpl = this._localPoolImpl.get();
            if (this._poolImpl == null) {
                throw new IllegalStateException(L.l("DBPool `{0}' no longer exists.", this.getName()));
            }
        }
        return this._poolImpl;
    }

    private DataSource getDataSource() {
        if (this._dataSource == null || this._resinDataSource != null && this._resinDataSource.isClosed()) {
            this._dataSource = this._localDataSourceImpl.get();
            this._resinDataSource = this._dataSource instanceof DataSourceImpl ? (DataSourceImpl)this._dataSource : null;
            if (this._dataSource == null) {
                throw new IllegalStateException(L.l("DBPool `{0}' no longer exists.", this.getName()));
            }
        }
        return this._dataSource;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private Object writeReplace() {
        return this._serializationHandle;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "]";
    }
}

