/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql;

import com.caucho.sql.Credential;
import com.caucho.sql.ManagedFactoryImpl;
import com.caucho.sql.SQLExceptionWrapper;
import com.caucho.util.L10N;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceImpl
implements DataSource {
    protected static final Logger log = Logger.getLogger(DataSourceImpl.class.getName());
    private static final L10N L = new L10N(DataSourceImpl.class);
    private final ManagedFactoryImpl _managedFactory;
    private final ConnectionManager _connManager;

    DataSourceImpl(ManagedFactoryImpl factory, ConnectionManager cm) {
        this._managedFactory = factory;
        this._connManager = cm;
    }

    public String getURL() {
        return this._managedFactory.getURL();
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            return (Connection)this._connManager.allocateConnection((ManagedConnectionFactory)this._managedFactory, null);
        }
        catch (ResourceException e) {
            for (Throwable cause = e; cause != null; cause = cause.getCause()) {
                if (!(cause instanceof SQLException)) continue;
                throw (SQLException)cause;
            }
            throw new SQLExceptionWrapper(e);
        }
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        try {
            Credential credential = null;
            if (username != null || password != null) {
                credential = new Credential(username, password);
            }
            return (Connection)this._connManager.allocateConnection((ManagedConnectionFactory)this._managedFactory, (ConnectionRequestInfo)credential);
        }
        catch (ResourceException e) {
            for (Throwable cause = e; cause != null; cause = cause.getCause()) {
                if (!(cause instanceof SQLException)) continue;
                throw (SQLException)cause;
            }
            throw new SQLExceptionWrapper(e);
        }
    }

    @Override
    public int getLoginTimeout() {
        return 0;
    }

    @Override
    public void setLoginTimeout(int seconds) {
    }

    @Override
    public PrintWriter getLogWriter() {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) {
    }

    boolean isClosed() {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

