/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql;

import com.caucho.env.meter.ActiveTimeSensor;
import com.caucho.sql.PreparedStatementCacheItem;
import com.caucho.sql.UserConnection;
import com.caucho.sql.UserStatement;
import com.caucho.util.L10N;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.logging.Logger;

public class UserPreparedStatement
extends UserStatement
implements PreparedStatement {
    private static final Logger log = Logger.getLogger(UserPreparedStatement.class.getName());
    protected static L10N L = new L10N(UserPreparedStatement.class);
    protected PreparedStatement _pstmt;
    protected PreparedStatementCacheItem _cacheItem;
    private boolean _isClosed;
    private ActiveTimeSensor _timeProbe;

    UserPreparedStatement(UserConnection conn, PreparedStatement pStmt, PreparedStatementCacheItem cacheItem) {
        super(conn, pStmt);
        this._pstmt = pStmt;
        this._cacheItem = cacheItem;
        this._timeProbe = conn.getTimeProbe();
        if (pStmt == null) {
            throw new NullPointerException();
        }
    }

    UserPreparedStatement(UserConnection conn, PreparedStatement pStmt) {
        this(conn, pStmt, null);
    }

    public PreparedStatement getPreparedStatement() {
        return this._pstmt;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResultSet executeQuery() throws SQLException {
        long startTime = this._timeProbe.start();
        try {
            ResultSet resultSet;
            try {
                resultSet = this._pstmt.executeQuery();
                Object var5_5 = null;
            }
            catch (RuntimeException e) {
                this.killPool();
                throw e;
            }
            catch (SQLException e) {
                this.killPool();
                throw e;
            }
            this._timeProbe.end(startTime);
            return resultSet;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this._timeProbe.end(startTime);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeUpdate() throws SQLException {
        long startTime = this._timeProbe.start();
        try {
            int n;
            try {
                n = this._pstmt.executeUpdate();
                Object var5_5 = null;
            }
            catch (RuntimeException e) {
                this.killPool();
                throw e;
            }
            catch (SQLException e) {
                this.killPool();
                throw e;
            }
            this._timeProbe.end(startTime);
            return n;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this._timeProbe.end(startTime);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute() throws SQLException {
        long startTime = this._timeProbe.start();
        try {
            boolean bl;
            try {
                bl = this._pstmt.execute();
                Object var5_5 = null;
            }
            catch (RuntimeException e) {
                this.killPool();
                throw e;
            }
            catch (SQLException e) {
                this.killPool();
                throw e;
            }
            this._timeProbe.end(startTime);
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this._timeProbe.end(startTime);
            throw throwable;
        }
    }

    public void addBatch() throws SQLException {
        try {
            this._pstmt.addBatch();
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    public void clearParameters() throws SQLException {
        try {
            this._pstmt.clearParameters();
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            return this._pstmt.getMetaData();
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            return this._pstmt.getParameterMetaData();
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        try {
            this._pstmt.setNull(parameterIndex, sqlType);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        try {
            this._pstmt.setNull(parameterIndex, sqlType, typeName);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    public void setBoolean(int index, boolean value) throws SQLException {
        try {
            this._pstmt.setBoolean(index, value);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    public void setByte(int index, byte value) throws SQLException {
        try {
            this._pstmt.setByte(index, value);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    public void setShort(int index, short value) throws SQLException {
        try {
            this._pstmt.setShort(index, value);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    public void setInt(int index, int value) throws SQLException {
        try {
            this._pstmt.setInt(index, value);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    public void setLong(int index, long value) throws SQLException {
        try {
            this._pstmt.setLong(index, value);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    public void setFloat(int index, float value) throws SQLException {
        try {
            this._pstmt.setFloat(index, value);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    public void setDouble(int index, double value) throws SQLException {
        try {
            this._pstmt.setDouble(index, value);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    public void setBigDecimal(int index, BigDecimal value) throws SQLException {
        try {
            this._pstmt.setBigDecimal(index, value);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    public void setString(int index, String value) throws SQLException {
        try {
            this._pstmt.setString(index, value);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    public void setBytes(int index, byte[] value) throws SQLException {
        try {
            this._pstmt.setBytes(index, value);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    public void setDate(int index, Date value) throws SQLException {
        try {
            this._pstmt.setDate(index, value);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    public void setDate(int index, Date value, Calendar cal) throws SQLException {
        try {
            this._pstmt.setDate(index, value, cal);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    public void setTime(int index, Time value) throws SQLException {
        try {
            this._pstmt.setTime(index, value);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    public void setTime(int index, Time value, Calendar cal) throws SQLException {
        try {
            this._pstmt.setTime(index, value, cal);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    public void setTimestamp(int index, Timestamp value) throws SQLException {
        try {
            this._pstmt.setTimestamp(index, value);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    public void setTimestamp(int index, Timestamp value, Calendar cal) throws SQLException {
        try {
            this._pstmt.setTimestamp(index, value, cal);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    public void setAsciiStream(int index, InputStream value, int length) throws SQLException {
        try {
            this._pstmt.setAsciiStream(index, value, length);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    public void setUnicodeStream(int index, InputStream value, int length) throws SQLException {
        try {
            this._pstmt.setUnicodeStream(index, value, length);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    public void setBinaryStream(int index, InputStream value, int length) throws SQLException {
        try {
            this._pstmt.setBinaryStream(index, value, length);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    public void setCharacterStream(int index, Reader value, int length) throws SQLException {
        try {
            this._pstmt.setCharacterStream(index, value, length);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    public void setObject(int index, Object value, int type, int scale) throws SQLException {
        try {
            this._pstmt.setObject(index, value, type, scale);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this._pstmt.setAsciiStream(parameterIndex, x, length);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this._pstmt.setBinaryStream(parameterIndex, x, length);
    }

    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this._pstmt.setCharacterStream(parameterIndex, reader, length);
    }

    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this._pstmt.setAsciiStream(parameterIndex, x);
    }

    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this._pstmt.setBinaryStream(parameterIndex, x);
    }

    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this._pstmt.setCharacterStream(parameterIndex, reader);
    }

    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this._pstmt.setNCharacterStream(parameterIndex, value);
    }

    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this._pstmt.setClob(parameterIndex, reader);
    }

    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this._pstmt.setBlob(parameterIndex, inputStream);
    }

    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this._pstmt.setNClob(parameterIndex, reader);
    }

    public void setObject(int index, Object value, int type) throws SQLException {
        try {
            this._pstmt.setObject(index, value, type);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    public void setObject(int index, Object value) throws SQLException {
        try {
            this._pstmt.setObject(index, value);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    public void setRef(int index, Ref value) throws SQLException {
        try {
            this._pstmt.setRef(index, value);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    public void setBlob(int index, Blob value) throws SQLException {
        try {
            this._pstmt.setBlob(index, value);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    public void setClob(int index, Clob value) throws SQLException {
        try {
            this._pstmt.setClob(index, value);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    public void setArray(int index, Array value) throws SQLException {
        try {
            this._pstmt.setArray(index, value);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    public void setURL(int index, URL value) throws SQLException {
        try {
            this._pstmt.setURL(index, value);
        }
        catch (RuntimeException e) {
            this.killPool();
            throw e;
        }
        catch (SQLException e) {
            this.killPool();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        UserPreparedStatement userPreparedStatement = this;
        synchronized (userPreparedStatement) {
            if (this._isClosed) {
                return;
            }
            this._isClosed = true;
        }
        this.clearParameters();
        if (this._cacheItem == null) {
            super.close();
        } else if (!this.isPoolable()) {
            this._cacheItem.destroy();
        } else {
            this._cacheItem.toIdle();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this._pstmt + ']';
    }

    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this._pstmt.setRowId(parameterIndex, x);
    }

    public void setNString(int parameterIndex, String value) throws SQLException {
        this._pstmt.setNString(parameterIndex, value);
    }

    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this._pstmt.setNCharacterStream(parameterIndex, value, length);
    }

    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this._pstmt.setNClob(parameterIndex, value);
    }

    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this._pstmt.setClob(parameterIndex, reader, length);
    }

    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this._pstmt.setBlob(parameterIndex, inputStream, length);
    }

    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this._pstmt.setNClob(parameterIndex, reader, length);
    }

    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this._pstmt.setSQLXML(parameterIndex, xmlObject);
    }
}

