/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.transaction;

import com.caucho.config.ConfigException;
import com.caucho.config.types.Period;
import com.caucho.env.meter.ActiveTimeMeter;
import com.caucho.env.meter.MeterService;
import com.caucho.inject.Module;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.management.server.AbstractManagedObject;
import com.caucho.management.server.ConnectionPoolMXBean;
import com.caucho.transaction.IdlePoolSet;
import com.caucho.transaction.ManagedPoolItem;
import com.caucho.transaction.UserPoolItem;
import com.caucho.transaction.UserTransactionImpl;
import com.caucho.transaction.UserTransactionProxy;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.L10N;
import com.caucho.util.WeakAlarm;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;

@Module
public class ConnectionPool
extends AbstractManagedObject
implements ConnectionManager,
AlarmListener,
ConnectionPoolMXBean {
    private static final L10N L = new L10N(ConnectionPool.class);
    private static final Logger log = Logger.getLogger(ConnectionPool.class.getName());
    private final AtomicInteger _idGen = new AtomicInteger();
    private String _name;
    private UserTransactionProxy _tm;
    private int _maxConnections = 1024;
    private int _maxOverflowConnections = 1024;
    private int _maxCreateConnections = 5;
    private int _maxIdleCount = 1024;
    private long _idleTimeout = 30000L;
    private long _activeTimeout = 21600000L;
    private long _poolTimeout = 86400000L;
    private long _connectionWaitTimeout = 30000L;
    private boolean _isEnableLocalTransaction = true;
    private boolean _isEnableXA = true;
    private boolean _isLocalTransactionOptimization = true;
    private boolean _isShareable = true;
    private boolean _isSaveAllocationStackTrace = false;
    private boolean _isCloseDanglingConnections = true;
    private final ArrayList<ManagedPoolItem> _connectionPool = new ArrayList();
    private IdlePoolSet _idlePool;
    private final ArrayList<ManagedPoolItem> _alarmConnections = new ArrayList();
    private Alarm _alarm;
    private long _lastValidCheckTime;
    private long _idlePoolExpire;
    private final AtomicInteger _idCount = new AtomicInteger();
    private final Object _availableLock = new Object();
    private final AtomicInteger _availableWaitCount = new AtomicInteger();
    private final AtomicInteger _createCount = new AtomicInteger();
    private ActiveTimeMeter _connectionTime;
    private ActiveTimeMeter _idleTime;
    private ActiveTimeMeter _queryTime;
    private final AtomicLong _connectionCountTotal = new AtomicLong();
    private final AtomicLong _connectionCreateCountTotal = new AtomicLong();
    private final AtomicLong _connectionFailCountTotal = new AtomicLong();
    private long _lastFailTime;
    private final Lifecycle _lifecycle = new Lifecycle();

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setTransactionManager(UserTransactionProxy tm) {
        this._tm = tm;
    }

    public UserTransactionProxy getTransactionManager() {
        return this._tm;
    }

    public boolean isShareable() {
        return this._isShareable;
    }

    public void setShareable(boolean isShareable) {
        this._isShareable = isShareable;
    }

    public boolean isLocalTransactionOptimization() {
        return this._isLocalTransactionOptimization;
    }

    public void setLocalTransactionOptimization(boolean enable) {
        this._isLocalTransactionOptimization = enable;
    }

    public boolean allowLocalTransactionOptimization() {
        return this._isLocalTransactionOptimization && this._isShareable;
    }

    public boolean getSaveAllocationStackTrace() {
        return this._isSaveAllocationStackTrace;
    }

    public void setSaveAllocationStackTrace(boolean save) {
        this._isSaveAllocationStackTrace = save;
    }

    public boolean isCloseDanglingConnections() {
        return this._isCloseDanglingConnections;
    }

    public void setCloseDanglingConnections(boolean isClose) {
        this._isCloseDanglingConnections = isClose;
    }

    public void setLocalTransaction(boolean localTransaction) {
        this._isEnableLocalTransaction = localTransaction;
    }

    public boolean isLocalTransaction() {
        return this._isEnableLocalTransaction;
    }

    public void setXATransaction(boolean enable) {
        this._isEnableXA = enable;
    }

    public boolean isXATransaction() {
        return this._isEnableXA;
    }

    public long getMaxIdleTime() {
        if (0x3FFFFFFFFFFFFFFFL <= this._idleTimeout) {
            return -1L;
        }
        return this._idleTimeout;
    }

    public void setMaxIdleTime(long maxIdleTime) {
        this._idleTimeout = maxIdleTime < 0L ? 0x3FFFFFFFFFFFFFFFL : maxIdleTime;
    }

    public int getMaxIdleCount() {
        return this._maxIdleCount;
    }

    public void setMaxIdleCount(int maxIdleCount) {
        this._maxIdleCount = maxIdleCount < 0 ? 0 : maxIdleCount;
    }

    public long getMaxActiveTime() {
        if (0x3FFFFFFFFFFFFFFFL <= this._activeTimeout) {
            return -1L;
        }
        return this._activeTimeout;
    }

    public void setMaxActiveTime(long maxActiveTime) {
        this._activeTimeout = maxActiveTime < 0L ? 0x3FFFFFFFFFFFFFFFL : maxActiveTime;
    }

    public long getMaxPoolTime() {
        if (0x3FFFFFFFFFFFFFFFL <= this._poolTimeout) {
            return -1L;
        }
        return this._poolTimeout;
    }

    public void setMaxPoolTime(long maxPoolTime) {
        this._poolTimeout = maxPoolTime < 0L ? 0x3FFFFFFFFFFFFFFFL : maxPoolTime;
    }

    public void setMaxConnections(int maxConnections) throws ConfigException {
        if (maxConnections == 0) {
            throw new ConfigException(L.l("max-connections '0' must be at least 1."));
        }
        this._maxConnections = maxConnections;
        if (maxConnections < 0) {
            this._maxConnections = 0x3FFFFFFF;
        }
    }

    public int getMaxConnections() {
        if (this._maxConnections < 0x3FFFFFFF) {
            return this._maxConnections;
        }
        return -1;
    }

    public void setConnectionWaitTime(Period waitTime) {
        this._connectionWaitTimeout = waitTime.getPeriod();
        if (this._connectionWaitTimeout < 0L) {
            this._connectionWaitTimeout = 0x3FFFFFFFFFFFFFFFL;
        }
    }

    public long getConnectionWaitTime() {
        if (this._connectionWaitTimeout < 0x3FFFFFFFFFFFFFFFL) {
            return this._connectionWaitTimeout;
        }
        return -1L;
    }

    public void setMaxOverflowConnections(int maxOverflowConnections) {
        this._maxOverflowConnections = maxOverflowConnections;
    }

    public int getMaxOverflowConnections() {
        return this._maxOverflowConnections;
    }

    public void setMaxCreateConnections(int maxConnections) throws ConfigException {
        if (maxConnections == 0) {
            throw new ConfigException(L.l("max-create-connections '0' must be at least 1."));
        }
        this._maxCreateConnections = maxConnections;
        if (maxConnections < 0) {
            this._maxCreateConnections = 0x3FFFFFFF;
        }
    }

    public int getMaxCreateConnections() {
        if (this._maxCreateConnections < 0x3FFFFFFF) {
            return this._maxCreateConnections;
        }
        return -1;
    }

    public ActiveTimeMeter getConnectionTimeProbe() {
        return this._connectionTime;
    }

    public ActiveTimeMeter getIdleTimeProbe() {
        return this._idleTime;
    }

    public ActiveTimeMeter getActiveTimeProbe() {
        return this._queryTime;
    }

    public int getConnectionCount() {
        return this._connectionPool.size();
    }

    public int getConnectionIdleCount() {
        return this._idlePool.size();
    }

    public int getConnectionActiveCount() {
        return this._connectionPool.size() - this._idlePool.size();
    }

    public long getConnectionCountTotal() {
        return this._connectionCountTotal.get();
    }

    public long getConnectionCreateCountTotal() {
        return this._connectionCreateCountTotal.get();
    }

    public long getConnectionFailCountTotal() {
        return this._connectionFailCountTotal.get();
    }

    public Date getLastFailTime() {
        return new Date(this._lastFailTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object init(ManagedConnectionFactory mcf) throws ConfigException, ResourceException {
        if (!this._lifecycle.toInit()) {
            return null;
        }
        if (this._name == null) {
            int v = this._idGen.incrementAndGet();
            this._name = mcf.getClass().getSimpleName() + "-" + v;
        }
        if (this._tm == null) {
            throw new ConfigException(L.l("the connection manager needs a transaction manager."));
        }
        this._idlePool = new IdlePoolSet(this._maxIdleCount);
        this._connectionTime = MeterService.createActiveTimeMeter("Resin|Database|Connection");
        this._idleTime = MeterService.createActiveTimeMeter("Resin|Database|Idle");
        this._queryTime = MeterService.createActiveTimeMeter("Resin|Database|Query");
        this.registerSelf();
        this._alarm = new WeakAlarm(this);
        if (!(mcf instanceof ValidatingManagedConnectionFactory)) {
            this._lastValidCheckTime = 0x3FFFFFFFFFFFFFFFL;
        }
        if (!this._isEnableXA) return mcf.createConnectionFactory((ConnectionManager)this);
        Subject subject = null;
        ManagedConnection mConn = mcf.createManagedConnection(subject, null);
        try {
            try {
                XAResource xa = mConn.getXAResource();
                this._tm.recover(xa);
            }
            catch (NotSupportedException e) {
                this._isEnableXA = false;
                log.finer(e.toString());
                Object var6_9 = null;
                mConn.destroy();
                return mcf.createConnectionFactory((ConnectionManager)this);
            }
            catch (Throwable e) {
                log.log(Level.FINER, e.toString(), e);
                Object var6_10 = null;
                mConn.destroy();
                return mcf.createConnectionFactory((ConnectionManager)this);
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            mConn.destroy();
            throw throwable;
        }
        mConn.destroy();
        return mcf.createConnectionFactory((ConnectionManager)this);
    }

    public void start() {
        if (!this._lifecycle.toActive()) {
            return;
        }
        if (0L < this._idleTimeout && this._idleTimeout < 1000L) {
            this._alarm.queue(1000L);
        } else if (1000L < this._idleTimeout && this._idleTimeout < 60000L) {
            this._alarm.queue(this._idleTimeout);
        } else {
            this._alarm.queue(60000L);
        }
    }

    String generateId() {
        return String.valueOf(this._idCount.getAndIncrement());
    }

    UserTransactionImpl getTransaction() {
        return this._tm.getUserTransaction();
    }

    public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo info) throws ResourceException {
        Subject subject = null;
        Object conn = this.allocateConnection(mcf, subject, info);
        this._connectionCountTotal.incrementAndGet();
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object allocateConnection(ManagedConnectionFactory mcf, Subject subject, ConnectionRequestInfo info) throws ResourceException {
        UserPoolItem userPoolItem = null;
        try {
            UserTransactionImpl transaction = this._tm.getUserTransaction();
            if (transaction != null) {
                userPoolItem = transaction.allocate(mcf, subject, info);
            }
            if (userPoolItem == null) {
                userPoolItem = this.allocatePoolConnection(mcf, subject, info, null);
            }
            Object dataSource = userPoolItem.allocateUserConnection();
            userPoolItem = null;
            Object object = dataSource;
            Object var9_8 = null;
            if (userPoolItem != null) {
                userPoolItem.close();
            }
            return object;
        }
        catch (Throwable throwable) {
            block5: {
                Object var9_9 = null;
                if (userPoolItem == null) break block5;
                userPoolItem.close();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UserPoolItem allocatePoolConnection(ManagedConnectionFactory mcf, Subject subject, ConnectionRequestInfo info, UserPoolItem oldPoolItem) throws ResourceException {
        long expireTime = Alarm.getCurrentTimeActual() + this._connectionWaitTimeout;
        if (!this._lifecycle.isActive()) {
            throw new IllegalStateException(L.l("Can't allocate connection because the connection pool is closed."));
        }
        do {
            UserPoolItem userPoolItem;
            if ((userPoolItem = this.allocateIdleConnection(mcf, subject, info, oldPoolItem)) != null) {
                return userPoolItem;
            }
            if (!this.startCreateConnection()) continue;
            try {
                UserPoolItem userPoolItem2 = this.createConnection(mcf, subject, info, oldPoolItem);
                Object var10_8 = null;
                this.finishCreateConnection();
                return userPoolItem2;
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                this.finishCreateConnection();
                throw throwable;
            }
        } while (this._lifecycle.isActive() && this.waitForAvailableConnection(expireTime));
        if (!this._lifecycle.isActive()) {
            throw new IllegalStateException(L.l("Can't allocate connection because the connection pool is closed."));
        }
        log.warning(this + " pool overflow");
        if (this.startCreateOverflow()) {
            try {
                UserPoolItem userPoolItem = this.createConnection(mcf, subject, info, oldPoolItem);
                Object var12_11 = null;
                this.finishCreateConnection();
                return userPoolItem;
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                this.finishCreateConnection();
                throw throwable;
            }
        }
        throw new ResourceException(L.l("Can't create overflow connection connection-max={0}", this._maxConnections));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserPoolItem allocateIdleConnection(ManagedConnectionFactory mcf, Subject subject, ConnectionRequestInfo info, UserPoolItem oldPoolItem) throws ResourceException {
        while (this._lifecycle.isActive()) {
            Object var12_9;
            ManagedPoolItem poolItem;
            block15: {
                long now = Alarm.getCurrentTime();
                if (this._lastValidCheckTime + 1000L < now) {
                    this._lastValidCheckTime = now;
                    if (mcf instanceof ValidatingManagedConnectionFactory) {
                        ValidatingManagedConnectionFactory vmcf = (ValidatingManagedConnectionFactory)mcf;
                        this.validate(vmcf);
                    }
                }
                poolItem = null;
                while (true) {
                    ArrayList<ManagedPoolItem> arrayList = this._connectionPool;
                    synchronized (arrayList) {
                        ManagedConnection mConn = mcf.matchManagedConnections((Set)this._idlePool, subject, info);
                        if (mConn == null) {
                            return null;
                        }
                        if (this._idlePool.remove(mConn)) {
                            poolItem = this.findPoolItem(mConn);
                            if (poolItem == null) {
                                throw new IllegalStateException(L.l("Unexpected non-matching PoolItem found for {0}", mConn));
                            }
                            break;
                        }
                    }
                }
                try {
                    UserPoolItem userPoolItem = poolItem.toActive(subject, info, oldPoolItem);
                    if (userPoolItem == null) break block15;
                    poolItem = null;
                    UserPoolItem userPoolItem2 = userPoolItem;
                    var12_9 = null;
                    if (poolItem != null) {
                        poolItem.destroy();
                    }
                    return userPoolItem2;
                }
                catch (Throwable throwable) {
                    var12_9 = null;
                    if (poolItem != null) {
                        poolItem.destroy();
                    }
                    throw throwable;
                }
            }
            var12_9 = null;
            if (poolItem == null) continue;
            poolItem.destroy();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManagedPoolItem findPoolItem(ManagedConnection mConn) {
        ArrayList<ManagedPoolItem> arrayList = this._connectionPool;
        synchronized (arrayList) {
            for (int i = this._connectionPool.size() - 1; i >= 0; --i) {
                ManagedPoolItem testPoolItem = this._connectionPool.get(i);
                if (testPoolItem.getManagedConnection() != mConn) continue;
                return testPoolItem;
            }
            return null;
        }
    }

    private void validate(ValidatingManagedConnectionFactory mcf) {
        Object invalid = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserPoolItem createConnection(ManagedConnectionFactory mcf, Subject subject, ConnectionRequestInfo info, UserPoolItem oldPoolItem) throws ResourceException {
        Object object;
        ManagedPoolItem poolItem;
        block9: {
            boolean isValid = false;
            poolItem = null;
            try {
                ManagedConnection mConn = mcf.createManagedConnection(subject, info);
                if (mConn == null) {
                    throw new ResourceException(L.l("'{0}' did not return a connection from createManagedConnection", mcf));
                }
                poolItem = new ManagedPoolItem(this, mcf, mConn);
                UserPoolItem userPoolItem = poolItem.toActive(subject, info, oldPoolItem);
                if (userPoolItem == null) {
                    throw new IllegalStateException(L.l("Connection '{0}' was not valid on creation", poolItem));
                }
                this._connectionCreateCountTotal.incrementAndGet();
                object = this._connectionPool;
                synchronized (object) {
                    this._connectionPool.add(poolItem);
                }
                poolItem = null;
                isValid = true;
                object = userPoolItem;
                Object var12_11 = null;
                if (isValid) break block9;
                this._connectionFailCountTotal.incrementAndGet();
            }
            catch (Throwable throwable) {
                block10: {
                    Object var12_12 = null;
                    if (!isValid) {
                        this._connectionFailCountTotal.incrementAndGet();
                        this._lastFailTime = Alarm.getCurrentTime();
                    }
                    if (poolItem == null) break block10;
                    poolItem.destroy();
                }
                throw throwable;
            }
            this._lastFailTime = Alarm.getCurrentTime();
        }
        if (poolItem != null) {
            poolItem.destroy();
        }
        return object;
    }

    private boolean startCreateConnection() throws ResourceException {
        if (this.isCreateAvailable()) {
            this._createCount.incrementAndGet();
            return true;
        }
        return false;
    }

    private void finishCreateConnection() {
        this._createCount.decrementAndGet();
        this.notifyConnectionAvailable();
    }

    private boolean startCreateOverflow() throws ResourceException {
        int size = this._connectionPool.size();
        int createCount = this._createCount.incrementAndGet();
        if (createCount + size <= this._maxConnections + this._maxOverflowConnections) {
            return true;
        }
        this._createCount.decrementAndGet();
        throw new ResourceException(L.l("Can't allocate overflow connection after {0}ms timeout because pool is full.\n  max-connections={1}, max-overflow-connections={2}, create-count={3}, pool-size={4}.", this._connectionWaitTimeout, this._maxConnections, this._maxOverflowConnections, this._createCount, size));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean waitForAvailableConnection(long expireTime) {
        this._availableWaitCount.incrementAndGet();
        try {
            boolean bl;
            Object object = this._availableLock;
            synchronized (object) {
                while (!this.isIdleAvailable() && !this.isCreateAvailable()) {
                    long delta;
                    block9: {
                        long now = Alarm.getCurrentTimeActual();
                        delta = expireTime - now;
                        if (delta > 0L) break block9;
                        boolean bl2 = false;
                        // MONITOREXIT @DISABLED, blocks:[0, 2, 5, 8] lbl12 : MonitorExitStatement: MONITOREXIT : var3_2
                        Object var11_8 = null;
                        this._availableWaitCount.decrementAndGet();
                        return bl2;
                    }
                    try {
                        Thread.interrupted();
                        this._availableLock.wait(delta);
                    }
                    catch (InterruptedException e) {
                        log.log(Level.FINER, e.toString(), e);
                    }
                }
                bl = true;
            }
            Object var11_9 = null;
            this._availableWaitCount.decrementAndGet();
            return bl;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            this._availableWaitCount.decrementAndGet();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyConnectionAvailable() {
        if (this._availableWaitCount.get() > 0) {
            Object object = this._availableLock;
            synchronized (object) {
                this._availableLock.notifyAll();
            }
        }
    }

    private boolean isIdleAvailable() {
        return this._idlePool.size() > 0;
    }

    private boolean isCreateAvailable() {
        return this._connectionPool.size() < this._maxConnections && this._createCount.get() < this._maxCreateConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markForPoolRemoval(ManagedConnection mConn) {
        ArrayList<ManagedPoolItem> arrayList = this._connectionPool;
        synchronized (arrayList) {
            for (int i = this._connectionPool.size() - 1; i >= 0; --i) {
                ManagedPoolItem poolItem = this._connectionPool.get(i);
                if (poolItem.getManagedConnection() != mConn) continue;
                poolItem.setConnectionError();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void toIdle(ManagedPoolItem item) {
        block13: {
            block14: {
                block12: {
                    try {
                        try {
                            block16: {
                                block15: {
                                    if (this._maxConnections < this._connectionPool.size()) break block15;
                                    if (!item.isConnectionError()) break block16;
                                }
                                Object var6_2 = null;
                                this.notifyConnectionAvailable();
                                if (item == null) return;
                                item.destroy();
                                return;
                            }
                            ManagedConnection mConn = item.getManagedConnection();
                            if (mConn == null) {
                                break block12;
                            }
                            mConn.cleanup();
                            long now = Alarm.getCurrentTime();
                            if (this._idlePool.size() == 0) {
                                this._idlePoolExpire = now + this._idleTimeout;
                            }
                            if (this._idlePoolExpire < now) {
                                this._idlePoolExpire = now + this._idleTimeout;
                                break block13;
                            }
                            if (!this._idlePool.add(mConn)) break block13;
                            item = null;
                            break block14;
                        }
                        catch (Exception e) {
                            log.log(Level.FINE, e.toString(), e);
                            Object var6_6 = null;
                            this.notifyConnectionAvailable();
                            if (item == null) return;
                            item.destroy();
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        this.notifyConnectionAvailable();
                        if (item == null) throw throwable;
                        item.destroy();
                        throw throwable;
                    }
                }
                Object var6_3 = null;
                this.notifyConnectionAvailable();
                if (item == null) return;
                item.destroy();
                return;
            }
            Object var6_4 = null;
            this.notifyConnectionAvailable();
            if (item == null) return;
            item.destroy();
            return;
        }
        Object var6_5 = null;
        this.notifyConnectionAvailable();
        if (item == null) return;
        item.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeItem(ManagedPoolItem item, ManagedConnection mConn) {
        ArrayList<ManagedPoolItem> arrayList = this._connectionPool;
        synchronized (arrayList) {
            this._idlePool.remove(mConn);
            this._connectionPool.remove(item);
            this._connectionPool.notifyAll();
        }
        try {
            item.destroy();
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ArrayList<ManagedPoolItem> pool = this._connectionPool;
        if (pool == null) {
            return;
        }
        ArrayList<ManagedPoolItem> clearItems = new ArrayList<ManagedPoolItem>();
        ArrayList<ManagedPoolItem> arrayList = this._connectionPool;
        synchronized (arrayList) {
            this._idlePool.clear();
            clearItems.addAll(pool);
            pool.clear();
        }
        for (int i = 0; i < clearItems.size(); ++i) {
            ManagedPoolItem poolItem = (ManagedPoolItem)clearItems.get(i);
            try {
                poolItem.destroy();
                continue;
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAlarm(Alarm alarm) {
        if (!this._lifecycle.isActive()) {
            return;
        }
        try {
            this._alarmConnections.clear();
            ArrayList<ManagedPoolItem> arrayList = this._connectionPool;
            synchronized (arrayList) {
                this._alarmConnections.addAll(this._connectionPool);
            }
            for (int i = this._alarmConnections.size() - 1; i >= 0; --i) {
                ManagedPoolItem item = this._alarmConnections.get(i);
                if (item.isValid()) continue;
                item.destroy();
            }
            this._alarmConnections.clear();
            Object var5_6 = null;
            if (this._lifecycle.isActive()) {
                if (0L < this._idleTimeout && this._idleTimeout < 1000L) {
                    this._alarm.queue(1000L);
                } else if (1000L < this._idleTimeout && this._idleTimeout < 60000L) {
                    this._alarm.queue(this._idleTimeout);
                } else {
                    this._alarm.queue(60000L);
                }
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (this._lifecycle.isActive()) {
                if (0L < this._idleTimeout && this._idleTimeout < 1000L) {
                    this._alarm.queue(1000L);
                } else if (1000L < this._idleTimeout && this._idleTimeout < 60000L) {
                    this._alarm.queue(this._idleTimeout);
                } else {
                    this._alarm.queue(60000L);
                }
            }
            throw throwable;
        }
    }

    public void stop() {
        if (!this._lifecycle.toStop()) {
            return;
        }
        if (this._alarm != null) {
            this._alarm.dequeue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        ArrayList<ManagedPoolItem> pool;
        this.stop();
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        ArrayList<ManagedPoolItem> arrayList = this._connectionPool;
        synchronized (arrayList) {
            pool = new ArrayList<ManagedPoolItem>(this._connectionPool);
            this._connectionPool.clear();
            if (this._idlePool != null) {
                this._idlePool.clear();
            }
        }
        for (int i = 0; i < pool.size(); ++i) {
            ManagedPoolItem poolItem = pool.get(i);
            try {
                poolItem.destroy();
                continue;
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    public String toString() {
        return "ConnectionPool[" + this.getName() + "]";
    }
}

