/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.transaction;

import com.caucho.transaction.ConnectionPool;
import com.caucho.transaction.UserPoolItem;
import com.caucho.transaction.UserTransactionImpl;
import com.caucho.transaction.XAExceptionWrapper;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

class ManagedPoolItem
implements ConnectionEventListener,
XAResource {
    private static final L10N L = new L10N(ManagedPoolItem.class);
    private static final Logger log = Logger.getLogger(ManagedPoolItem.class.getName());
    private ConnectionPool _cm;
    private ManagedConnectionFactory _mcf;
    private ManagedConnection _mConn;
    private UserTransactionImpl _transaction;
    private String _id;
    private XAResource _xaResource;
    private LocalTransaction _localTransaction;
    private int _defaultTransactionTimeout;
    private int _transactionTimeout;
    private Subject _subject;
    private ConnectionRequestInfo _requestInfo;
    final Object _shareLock;
    UserPoolItem _shareHead;
    private ManagedPoolItem _xaHead;
    private ManagedPoolItem _xaNext;
    private boolean _hasConnectionError;
    private long _poolStartTime;
    private long _poolEventTime;
    private Xid _xid;
    private int _endFlags;
    private boolean _isXATransaction;
    private boolean _isLocalTransaction;
    private IllegalStateException _allocationStackTrace;
    private long _connectionStartTime;
    private long _idleStartTime;
    private long _activeStartTime;

    public ManagedPoolItem(ConnectionPool cm, ManagedConnectionFactory mcf, ManagedConnection conn) {
        block11: {
            this._shareLock = new Object();
            this._endFlags = -1;
            this._isXATransaction = true;
            this._cm = cm;
            this._id = this._cm.generateId();
            this._mcf = mcf;
            this._mConn = conn;
            this._poolStartTime = Alarm.getCurrentTime();
            this._poolEventTime = Alarm.getCurrentTime();
            this._connectionStartTime = cm.getConnectionTimeProbe().start();
            try {
                if (!cm.isXATransaction()) break block11;
                XAResource xaResource = conn.getXAResource();
                try {
                    this._defaultTransactionTimeout = xaResource.getTransactionTimeout();
                }
                catch (Throwable e) {
                    log.log(Level.FINE, e.toString(), e);
                }
                this._xaResource = xaResource;
            }
            catch (NotSupportedException e) {
                this._cm.setXATransaction(false);
                log.log(Level.FINER, e.toString(), e);
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        if (this._xaResource == null) {
            this._isXATransaction = false;
        }
        try {
            if (this._cm.isLocalTransaction()) {
                this._localTransaction = conn.getLocalTransaction();
            }
        }
        catch (NotSupportedException e) {
            this._cm.setLocalTransaction(false);
            log.log(Level.FINER, e.toString(), e);
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
        }
        this._mConn.addConnectionEventListener((ConnectionEventListener)this);
        if (log.isLoggable(Level.FINE)) {
            log.fine("create: " + this + "(active:" + this._cm.getConnectionActiveCount() + ", total:" + this._cm.getConnectionCount() + ")");
        }
    }

    public void setSubject(Subject subject) {
        this._subject = subject;
    }

    public void setInfo(ConnectionRequestInfo info) {
        this._requestInfo = info;
    }

    public boolean isActive() {
        return this._shareHead != null;
    }

    public boolean isDead() {
        return this._mConn == null;
    }

    public long getEventTime() {
        return this._poolEventTime;
    }

    public long getStartTime() {
        return this._poolStartTime;
    }

    void setTransaction(UserTransactionImpl transaction) {
        this._transaction = transaction;
    }

    synchronized UserPoolItem toActive(Subject subject, ConnectionRequestInfo info, UserPoolItem oldPoolItem) throws ResourceException {
        long now = Alarm.getCurrentTime();
        long maxIdleTime = this._cm.getMaxIdleTime();
        long maxPoolTime = this._cm.getMaxPoolTime();
        if (this._hasConnectionError) {
            return null;
        }
        if (0L < maxIdleTime && this._poolEventTime + maxIdleTime < now) {
            return null;
        }
        if (0L < maxPoolTime && this._poolStartTime + maxPoolTime < now) {
            return null;
        }
        if (this._shareHead != null) {
            throw new IllegalStateException(L.l("trying to activate active pool item."));
        }
        this._poolEventTime = now;
        this._isXATransaction = this._xaResource != null;
        UserPoolItem userPoolItem = null;
        if (oldPoolItem != null) {
            Object uConn = oldPoolItem.getUserConnection();
            if (uConn != null) {
                this._mConn.associateConnection(uConn);
            }
            oldPoolItem.associatePoolItem(this);
            userPoolItem = oldPoolItem;
        } else {
            userPoolItem = new UserPoolItem(this._cm, this);
        }
        if (!this.isValid(subject, info, userPoolItem)) {
            return null;
        }
        this._subject = subject;
        this._requestInfo = info;
        userPoolItem.associate(this, this._mcf, subject, info);
        if (log.isLoggable(Level.FINE)) {
            log.fine("allocate " + this);
        }
        if (this._cm.getSaveAllocationStackTrace()) {
            this._allocationStackTrace = new IllegalStateException(L.l("Connection {0} allocation stack trace", this));
        }
        return userPoolItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isValid() {
        ManagedPoolItem managedPoolItem = this;
        synchronized (managedPoolItem) {
            long now = Alarm.getCurrentTime();
            long maxIdleTime = this._cm.getMaxIdleTime();
            long maxPoolTime = this._cm.getMaxPoolTime();
            long maxActiveTime = this._cm.getMaxActiveTime();
            boolean isActive = this.isActive() || this._xid != null;
            boolean isDead = false;
            if (!isActive && this._hasConnectionError) {
                isDead = true;
                log.fine("closing pool item from connection error:" + this);
            } else if (!isActive && 0L < maxIdleTime && this._poolEventTime + maxIdleTime < now) {
                isDead = true;
                log.fine("closing pool item from idle timeout:" + this);
            } else if (!isActive && 0L < maxPoolTime && this._poolStartTime + maxPoolTime < now) {
                isDead = true;
                log.fine("closing pool item from pool timeout:" + this);
            } else if (isActive && 0L < maxActiveTime && this._poolEventTime + maxActiveTime < now) {
                isDead = true;
                log.warning("closing pool item from active timeout:" + this);
            }
            if (isDead) {
                this._hasConnectionError = true;
                return false;
            }
            return true;
        }
    }

    UserPoolItem allocateXA(ManagedConnectionFactory mcf, Subject subject, ConnectionRequestInfo info) {
        if (this._mConn == null) {
            return null;
        }
        if (this._subject != subject) {
            return null;
        }
        if (this._requestInfo != info) {
            return null;
        }
        if (this._mcf != mcf) {
            return null;
        }
        if (this._shareHead != null && !this._cm.isShareable()) {
            return null;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("sharing xa-pool item: " + this);
        }
        UserPoolItem userPoolItem = new UserPoolItem(this._cm);
        userPoolItem.associate(this, this._mcf, this._subject, this._requestInfo);
        return userPoolItem;
    }

    boolean isJoin(ManagedPoolItem item) {
        if (this == item) {
            return false;
        }
        if (this._xid != item._xid) {
            return false;
        }
        return this._mcf == item._mcf;
    }

    boolean share(UserPoolItem userPoolItem) {
        if (this == userPoolItem.getOwnPoolItem()) {
            return true;
        }
        if (this._mConn == null) {
            return false;
        }
        if (!this._cm.isShareable()) {
            return false;
        }
        if (this._mcf != userPoolItem.getManagedConnectionFactory()) {
            return false;
        }
        if (this._subject != userPoolItem.getSubject()) {
            return false;
        }
        if (this._requestInfo != userPoolItem.getInfo()) {
            return false;
        }
        if (this._hasConnectionError) {
            return false;
        }
        return false;
    }

    ManagedConnection getManagedConnection() {
        return this._mConn;
    }

    Object allocateConnection() throws ResourceException {
        Object conn = this._mConn.getConnection(this._subject, this._requestInfo);
        return conn;
    }

    boolean isValid(Subject subject, ConnectionRequestInfo requestInfo, UserPoolItem userPoolItem) {
        try {
            ManagedConnection mConn = this.getManagedConnection();
            if (mConn == null) {
                return false;
            }
            Object userConn = userPoolItem.getUserConnection();
            if (userConn == null) {
                userConn = mConn.getConnection(subject, requestInfo);
                userPoolItem.setUserConnection(userConn);
            }
            return userConn != null;
        }
        catch (ResourceException e) {
            log.log(Level.WARNING, e.toString(), e);
            return false;
        }
    }

    void enableLocalTransactionOptimization(boolean enableOptimization) {
        this._isXATransaction = this._xaResource == null ? false : (this._localTransaction == null ? true : (!this._cm.isLocalTransactionOptimization() ? true : (!this._cm.isShareable() ? true : !enableOptimization)));
    }

    boolean supportsTransaction() {
        return this._xaResource != null || this._localTransaction != null;
    }

    XAResource getXAResource() {
        return this._xaResource;
    }

    Xid getXid() {
        return this._xid;
    }

    public void connectionClosed(ConnectionEvent event) {
        Object handle = event.getConnectionHandle();
        if (!this._hasConnectionError && handle == null && this._shareHead != null) {
            log.fine(L.l("JCA close event '{0}' for {1} did not have a connection handle.  Please notify the JCA resource provider.", (Object)event, this._mConn));
        }
        UserPoolItem ptr = this._shareHead;
        UserPoolItem prev = null;
        while (ptr != null) {
            UserPoolItem next = ptr.getShareNext();
            Object userConn = ptr.getUserConnection();
            if (userConn == handle || handle == null) {
                if (prev != null) {
                    prev.setShareNext(next);
                } else {
                    this._shareHead = next;
                }
                ptr.close();
            } else {
                prev = ptr;
            }
            ptr = next;
        }
        if (this._shareHead == null) {
            this.toIdle();
            return;
        }
    }

    public void localTransactionStarted(ConnectionEvent event) {
        if (this._isLocalTransaction || this._xid != null) {
            throw new IllegalStateException(L.l("attempted to start local transaction while transaction is in progress."));
        }
        this._isLocalTransaction = true;
    }

    public void localTransactionCommitted(ConnectionEvent event) {
        if (!this._isLocalTransaction) {
            if (this._xid != null) {
                throw new IllegalStateException(L.l("attempted to commit() local transaction from an active XA transaction."));
            }
            throw new IllegalStateException(L.l("attempted to commit() with no active local transaction."));
        }
        this._isLocalTransaction = false;
    }

    public void localTransactionRolledback(ConnectionEvent event) {
        if (this._xid != null) {
            throw new IllegalStateException(L.l("attempted to rollback() local transaction from an active XA transaction."));
        }
        if (!this._isLocalTransaction) {
            throw new IllegalStateException(L.l("attempted to rollback() with no active local transaction."));
        }
        this._isLocalTransaction = false;
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        this._hasConnectionError = true;
    }

    public void setConnectionError() {
        this._hasConnectionError = true;
    }

    public boolean isConnectionError() {
        return this._hasConnectionError;
    }

    public IllegalStateException getAllocationStackTrace() {
        return this._allocationStackTrace;
    }

    public boolean isSameRM(XAResource resource) throws XAException {
        if (!(resource instanceof ManagedPoolItem)) {
            return false;
        }
        ManagedPoolItem poolItem = (ManagedPoolItem)resource;
        if (this._xaResource == null) {
            return false;
        }
        boolean isSameRM = this._xaResource.isSameRM(poolItem._xaResource);
        if (log.isLoggable(Level.FINER)) {
            log.finer("isSameRM->" + isSameRM + " " + this._xaResource);
        }
        return isSameRM;
    }

    public void start(Xid xid, int flags) throws XAException {
        if (this._xid != null) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("connection pool start XA: rejoin " + this);
            }
            return;
        }
        if (flags == 0x200000 && this._xid == null) {
            ManagedPoolItem xaHead;
            this._xid = xid;
            UserTransactionImpl trans = this._cm.getTransaction();
            if (trans != null && (xaHead = trans.findJoin(this)) != null) {
                this._xaNext = xaHead._xaNext;
                this._xaHead = xaHead;
                xaHead._xaNext = this;
            }
        }
        if (!this._isXATransaction && flags != 0x200000 && this._localTransaction != null) {
            try {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("begin-local-XA: " + xid + " " + this._localTransaction);
                }
                this._localTransaction.begin();
            }
            catch (ResourceException e) {
                throw new XAExceptionWrapper(e);
            }
            this._xid = xid;
            return;
        }
        if (this._xaResource != null) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("start-XA: " + xid + " " + this._xaResource);
            }
            this._xaResource.start(xid, flags);
            this._isXATransaction = true;
        } else if (log.isLoggable(Level.FINER)) {
            log.finer("start-XA with non XA resource: " + xid + " " + this._xaResource);
        }
        this._xid = xid;
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        if (seconds == this._transactionTimeout) {
            return true;
        }
        XAResource xaResource = this._xaResource;
        this._transactionTimeout = seconds;
        if (xaResource == null) {
            return true;
        }
        if (seconds == 0) {
            return xaResource.setTransactionTimeout(this._defaultTransactionTimeout);
        }
        return xaResource.setTransactionTimeout(seconds);
    }

    public int getTransactionTimeout() throws XAException {
        return this._transactionTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(Xid xid) throws XAException {
        try {
            if (this._isXATransaction) {
                this._xaResource.forget(xid);
            }
            Object var3_2 = null;
            this.clearXid();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.clearXid();
            throw throwable;
        }
    }

    public int prepare(Xid xid) throws XAException {
        if (this._endFlags != -1) {
            int endFlags = this._endFlags;
            this._endFlags = -1;
            if (this._isXATransaction) {
                this.endResource(xid, endFlags);
            }
        }
        if (this._isXATransaction) {
            try {
                int result;
                if (log.isLoggable(Level.FINER)) {
                    log.finer("prepare-XA: " + xid + " " + this._xaResource);
                }
                if ((result = this._xaResource.prepare(xid)) == 3) {
                    if (this._xaResource != null) {
                        this._isXATransaction = true;
                    }
                    this.clearXid();
                }
                return result;
            }
            catch (XAException e) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("failed prepare-XA: " + xid + " " + this._xaResource + " " + e);
                }
                throw e;
            }
        }
        return 0;
    }

    public Xid[] recover(int flag) throws XAException {
        if (this._isXATransaction) {
            return this._xaResource.recover(flag);
        }
        return null;
    }

    public void end(Xid xid, int flags) throws XAException {
        this._endFlags = flags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rollback(Xid xid) throws XAException {
        try {
            block13: {
                int endFlags = this._endFlags;
                this._endFlags = -1;
                if (endFlags != -1 && this._isXATransaction) {
                    boolean isValid = false;
                    try {
                        this.endResource(xid, endFlags);
                        isValid = true;
                        Object var5_5 = null;
                        if (isValid) break block13;
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        if (isValid) throw throwable;
                        this._xaResource.rollback(xid);
                        throw throwable;
                    }
                    this._xaResource.rollback(xid);
                }
            }
            if (log.isLoggable(Level.FINER)) {
                log.finer("connection pool rollback XA: " + this);
            }
            if (this._isXATransaction) {
                this._xaResource.rollback(xid);
            } else if (this._localTransaction != null) {
                try {
                    this._isLocalTransaction = false;
                    this._localTransaction.rollback();
                }
                catch (ResourceException e) {
                    throw new XAExceptionWrapper(e);
                }
            }
            Object var7_8 = null;
            if (this._xaResource != null) {
                this._isXATransaction = true;
            }
            this.clearXid();
            return;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (this._xaResource != null) {
                this._isXATransaction = true;
            }
            this.clearXid();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commit(Xid xid, boolean onePhase) throws XAException {
        boolean logFiner = log.isLoggable(Level.FINER);
        try {
            block18: {
                int endFlags = this._endFlags;
                this._endFlags = -1;
                if (endFlags != -1 && this._isXATransaction) {
                    boolean isValid = false;
                    try {
                        this.endResource(xid, endFlags);
                        isValid = true;
                        Object var7_8 = null;
                        if (isValid) break block18;
                    }
                    catch (Throwable throwable) {
                        Object var7_9 = null;
                        if (isValid) throw throwable;
                        this._xaResource.rollback(xid);
                        throw throwable;
                    }
                    this._xaResource.rollback(xid);
                }
            }
            if (this._isXATransaction) {
                if (logFiner) {
                    log.finer("commit-XA" + (onePhase ? "-1p: " : ": ") + xid + " " + this._xaResource);
                }
                try {
                    this._xaResource.commit(xid, onePhase);
                }
                catch (XAException e) {
                    if (!logFiner) throw e;
                    log.finer("commit-XA failed: " + this._xaResource + " " + e);
                    throw e;
                }
            }
            if (this._localTransaction != null) {
                if (logFiner) {
                    log.finer("commit-local: " + this._localTransaction);
                }
                try {
                    try {
                        this._localTransaction.commit();
                    }
                    catch (ResourceException e) {
                        if (!logFiner) throw new XAExceptionWrapper(e);
                        log.finer("commit failed: " + this._localTransaction + " " + (Object)((Object)e));
                        throw new XAExceptionWrapper(e);
                    }
                    Object var9_11 = null;
                    this._isLocalTransaction = false;
                }
                catch (Throwable throwable) {
                    Object var9_12 = null;
                    this._isLocalTransaction = false;
                    throw throwable;
                }
            }
            if (logFiner) {
                log.finer("commit for resource with no XA support: " + this);
            }
            Object var11_14 = null;
            if (this._xaResource != null) {
                this._isXATransaction = true;
            }
            this.clearXid();
            return;
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            if (this._xaResource != null) {
                this._isXATransaction = true;
            }
            this.clearXid();
            throw throwable;
        }
    }

    private void endResource(Xid xid, int flags) throws XAException {
        ManagedPoolItem xaPtr = this;
        while (xaPtr != null) {
            if (xaPtr._xaResource != null) {
                xaPtr._xaResource.end(xid, flags);
            }
            xaPtr = xaPtr._xaNext;
        }
    }

    private void clearXid() {
        UserPoolItem ptr;
        this._xid = null;
        UserPoolItem shareHead = this._shareHead;
        this._shareHead = null;
        ManagedPoolItem xaPtr = this._xaNext;
        this._xaHead = null;
        this._xaNext = null;
        UserPoolItem assignedUserItem = null;
        for (ptr = shareHead; ptr != null; ptr = ptr.getShareNext()) {
            if (ptr.getOwnPoolItem() != this) continue;
            assignedUserItem = ptr;
            break;
        }
        for (ptr = shareHead; ptr != null; ptr = ptr.getShareNext()) {
            if (assignedUserItem == null && ptr.getOwnPoolItem() == null) {
                ptr.associatePoolItem(this);
                assignedUserItem = ptr;
            }
            try {
                ptr.reassociatePoolItem();
                continue;
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        while (xaPtr != null) {
            ManagedPoolItem next = xaPtr._xaNext;
            xaPtr._xaNext = null;
            xaPtr._xaHead = null;
            xaPtr.clearXid();
            xaPtr = next;
        }
        if (assignedUserItem == null) {
            if (this._hasConnectionError) {
                this.destroy();
            } else {
                this.toIdle();
            }
        }
    }

    void toIdle() {
        if (this._shareHead != null) {
            return;
        }
        if (this._xid != null || this._isLocalTransaction) {
            return;
        }
        if (this._hasConnectionError) {
            this.destroy();
            return;
        }
        UserTransactionImpl transaction = this._transaction;
        this._transaction = null;
        if (transaction != null) {
            try {
                transaction.delistPoolItem(this, 0x4000000);
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        this._isLocalTransaction = false;
        if (log.isLoggable(Level.FINE)) {
            log.fine("idle " + this);
        }
        this._poolEventTime = Alarm.getCurrentTime();
        this._cm.toIdle(this);
    }

    void abortConnection() {
        this.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        ManagedConnection mConn = this._mConn;
        this._mConn = null;
        UserTransactionImpl transaction = this._transaction;
        this._transaction = null;
        if (mConn == null) {
            return;
        }
        this._cm.removeItem(this, mConn);
        UserPoolItem userItem = this._shareHead;
        if (log.isLoggable(Level.FINE)) {
            log.fine("connection pool destroy " + this);
        }
        try {
            while (userItem != null) {
                UserPoolItem next = userItem.getShareNext();
                userItem.close();
                userItem = next;
            }
            if (transaction != null) {
                transaction.delistPoolItem(this, 0x20000000);
            }
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
        }
        try {
            try {
                mConn.destroy();
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
                Object var6_8 = null;
                this._cm.getConnectionTimeProbe().end(this._connectionStartTime);
            }
            Object var6_7 = null;
            this._cm.getConnectionTimeProbe().end(this._connectionStartTime);
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this._cm.getConnectionTimeProbe().end(this._connectionStartTime);
            throw throwable;
        }
    }

    public String toString() {
        if (this._mConn != null) {
            return this.getClass().getSimpleName() + "[" + this._cm.getName() + "," + this._id + "," + this._mConn.getClass().getSimpleName() + "]";
        }
        return this.getClass().getSimpleName() + "[" + this._cm.getName() + "," + this._id + ",null]";
    }
}

