/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.transaction;

import com.caucho.transaction.TransactionImpl;
import com.caucho.transaction.TransactionManagerImpl;
import com.caucho.util.L10N;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.xa.XAResource;

public class TransactionSynchronizationRegistryImpl
implements TransactionSynchronizationRegistry {
    private static final Logger log = Logger.getLogger(TransactionSynchronizationRegistryImpl.class.getName());
    private static final L10N L = new L10N(TransactionSynchronizationRegistryImpl.class);
    private final TransactionManagerImpl _transactionManager;

    public TransactionSynchronizationRegistryImpl(TransactionManagerImpl transactionManager) {
        this._transactionManager = transactionManager;
    }

    public Object getResource(Object key) {
        TransactionImpl transaction = this._transactionManager.getTransaction();
        if (transaction != null) {
            return transaction.getResource(key);
        }
        throw new IllegalStateException(L.l("Thread {0} does not have an active transaction.", Thread.currentThread()));
    }

    public boolean getRollbackOnly() {
        TransactionImpl transaction = this._transactionManager.getTransaction();
        if (transaction != null) {
            return transaction.isRollbackOnly();
        }
        throw new IllegalStateException(L.l("This {0} does not have an active transaction.", Thread.currentThread()));
    }

    public Object getTransactionKey() {
        TransactionImpl transaction = this._transactionManager.getTransaction();
        if (transaction != null) {
            return transaction.getXid();
        }
        return null;
    }

    public int getTransactionStatus() {
        TransactionImpl transaction = this._transactionManager.getTransaction();
        if (transaction != null) {
            return transaction.getStatus();
        }
        return 6;
    }

    public void putResource(Object key, Object value) {
        if (!(value instanceof XAResource)) {
            throw new IllegalArgumentException(L.l("{0} is not an XA resource.", value));
        }
        TransactionImpl transaction = this._transactionManager.getTransaction();
        if (transaction != null) {
            try {
                transaction.putResource(key, (XAResource)value);
            }
            catch (RollbackException e) {
                log.log(Level.WARNING, L.l("Error adding resoure to transaction: {0}", e.getMessage()), e);
            }
            catch (SystemException e) {
                log.log(Level.WARNING, L.l("Error adding resoure to transaction: {0}", e.getMessage()), e);
            }
        } else {
            throw new IllegalStateException(L.l("No active transaction."));
        }
    }

    public void registerInterposedSynchronization(Synchronization synchronization) {
        TransactionImpl transaction = this._transactionManager.getTransaction();
        if (transaction == null) {
            throw new IllegalStateException(L.l("No active transaction."));
        }
        transaction.registerInterposedSynchronization(synchronization);
    }

    public void setRollbackOnly() {
        TransactionImpl transaction = this._transactionManager.getTransaction();
        if (transaction != null) {
            try {
                transaction.setRollbackOnly();
            }
            catch (SystemException e) {
                log.log(Level.WARNING, L.l("Error setting roll-back: {0}", e.getMessage()), e);
            }
        } else {
            throw new IllegalStateException(L.l("No active transaction."));
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

