/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.env.thread.TaskWorker;
import com.caucho.env.thread.ThreadPool;
import com.caucho.loader.ClassLoaderListener;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.util.AlarmHeap;
import com.caucho.util.AlarmListener;
import com.caucho.util.ThreadTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Alarm
implements ThreadTask,
ClassLoaderListener {
    private static final Logger log = Logger.getLogger(Alarm.class.getName());
    private static final ClassLoader _systemLoader;
    private static final AlarmThread _alarmThread;
    private static final CoordinatorThread _coordinatorThread;
    private static volatile long _currentTime;
    private static volatile boolean _isCurrentTimeUsed;
    private static volatile boolean _isSlowTime;
    private static final AlarmHeap _heap;
    private static final AtomicInteger _runningAlarmCount;
    private static final boolean _isStressTest;
    private static long _testTime;
    private static long _testNanoDelta;
    private long _wakeTime;
    private AlarmListener _listener;
    private ClassLoader _contextLoader;
    private String _name;
    private boolean _isPriority = true;
    private int _heapIndex = 0;
    private volatile boolean _isRunning;

    protected Alarm() {
        this("alarm");
    }

    protected Alarm(String name) {
        this._name = name;
        this.addEnvironmentListener();
    }

    public Alarm(AlarmListener listener) {
        this("alarm[" + listener + "]", listener);
    }

    public Alarm(String name, AlarmListener listener) {
        this(name, listener, Thread.currentThread().getContextClassLoader());
    }

    public Alarm(String name, AlarmListener listener, ClassLoader loader) {
        this(name);
        this.setListener(listener);
        this.setContextLoader(loader);
    }

    public Alarm(String name, AlarmListener listener, long delta, ClassLoader loader) {
        this(name);
        this.setListener(listener);
        this.setContextLoader(loader);
        this.queue(delta);
    }

    public Alarm(String name, AlarmListener listener, long delta) {
        this(name, listener);
        this.queue(delta);
    }

    public Alarm(AlarmListener listener, long delta) {
        this(listener);
        this.queue(delta);
    }

    public String getName() {
        return this._name;
    }

    protected void setName(String name) {
        this._name = name;
    }

    public static boolean isActive() {
        return _testTime == 0L && _alarmThread != null;
    }

    public static long getCurrentTime() {
        if (!_isCurrentTimeUsed) {
            if (_testTime > 0L) {
                return _testTime;
            }
            if (_alarmThread == null) {
                return System.currentTimeMillis();
            }
            if (_isSlowTime) {
                return System.currentTimeMillis();
            }
            _isCurrentTimeUsed = true;
        }
        return _currentTime;
    }

    public static long getCurrentTimeActual() {
        if (_testTime > 0L) {
            return System.currentTimeMillis();
        }
        return Alarm.getCurrentTime();
    }

    public static long getExactTime() {
        if (_testTime > 0L) {
            return _testTime;
        }
        return System.currentTimeMillis();
    }

    public static long getExactTimeNanoseconds() {
        if (_testTime > 0L) {
            return (_testTime - 10000000L) * 1000000L + _testNanoDelta;
        }
        return System.nanoTime();
    }

    public static boolean isTest() {
        return _testTime > 0L;
    }

    public static void yieldIfTest() {
        if (_testTime > 0L) {
            // empty if block
        }
    }

    public long getWakeTime() {
        return this._wakeTime;
    }

    void setWakeTime(long wakeTime) {
        this._wakeTime = wakeTime;
    }

    int getHeapIndex() {
        return this._heapIndex;
    }

    void setHeapIndex(int index) {
        this._heapIndex = index;
    }

    public AlarmListener getListener() {
        return this._listener;
    }

    public void setListener(AlarmListener listener) {
        this._listener = listener;
    }

    public void setContextLoader(ClassLoader loader) {
        this._contextLoader = loader;
    }

    public ClassLoader getContextLoader() {
        return this._contextLoader;
    }

    public boolean isQueued() {
        return this._heapIndex != 0;
    }

    boolean isRunning() {
        return this._isRunning;
    }

    public void setPriority(boolean isPriority) {
        this._isPriority = isPriority;
    }

    public boolean isPriority() {
        return this._isPriority;
    }

    protected void addEnvironmentListener() {
    }

    public void queue(long delta) {
        long now = Alarm.getCurrentTime();
        boolean isNotify = _heap.queueAt(this, now + delta);
        if (isNotify) {
            _coordinatorThread.wake();
        }
    }

    public void queueAt(long wakeTime) {
        boolean isNotify = _heap.queueAt(this, wakeTime);
        if (isNotify) {
            _coordinatorThread.wake();
        }
    }

    public void dequeue() {
        if (this._heapIndex > 0) {
            _heap.dequeue(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                this.handleAlarm();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
                Object var3_2 = null;
                this._isRunning = false;
                _runningAlarmCount.decrementAndGet();
                return;
            }
            Object var3_1 = null;
            this._isRunning = false;
            _runningAlarmCount.decrementAndGet();
            return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._isRunning = false;
            _runningAlarmCount.decrementAndGet();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAlarm() {
        AlarmListener listener = this.getListener();
        if (listener == null) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader loader = this.getContextLoader();
        if (loader != null) {
            thread.setContextClassLoader(loader);
        } else {
            thread.setContextClassLoader(_systemLoader);
        }
        try {
            listener.handleAlarm(this);
            Object var5_4 = null;
            thread.setContextClassLoader(_systemLoader);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            thread.setContextClassLoader(_systemLoader);
            throw throwable;
        }
    }

    public void classLoaderInit(DynamicClassLoader loader) {
    }

    public void classLoaderDestroy(DynamicClassLoader loader) {
        this.close();
    }

    public void close() {
        this.dequeue();
    }

    static void testClear() {
        _heap.testClear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setTestTime(long time) {
        _testTime = time;
        if (_testTime > 0L) {
            if (time < _currentTime) {
                Alarm.testClear();
            }
            _currentTime = time;
        } else {
            _currentTime = System.currentTimeMillis();
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            Alarm alarm;
            while ((alarm = _heap.extractAlarm(Alarm.getCurrentTime())) != null) {
                alarm.run();
            }
            Object var6_4 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    static void setTestNanoDelta(long delta) {
        _testNanoDelta = delta;
    }

    public String toString() {
        return "Alarm[" + this._name + "]";
    }

    static {
        _heap = new AlarmHeap();
        _runningAlarmCount = new AtomicInteger();
        _currentTime = System.currentTimeMillis();
        ClassLoader systemLoader = null;
        AlarmThread alarmThread = null;
        CoordinatorThread coordinator = null;
        try {
            systemLoader = ClassLoader.getSystemClassLoader();
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            ClassLoader loader = Alarm.class.getClassLoader();
            if (loader == null || loader instanceof DynamicClassLoader || loader == systemLoader || systemLoader != null && loader == systemLoader.getParent()) {
                alarmThread = new AlarmThread();
                alarmThread.start();
                coordinator = new CoordinatorThread();
                coordinator.wake();
            }
        }
        catch (Throwable e) {
            log.fine("Alarm not started: " + e);
        }
        _systemLoader = systemLoader;
        _alarmThread = alarmThread;
        _coordinatorThread = coordinator;
        _isStressTest = System.getProperty("caucho.stress.test") != null;
    }

    static class CoordinatorThread
    extends TaskWorker {
        CoordinatorThread() {
        }

        protected boolean isPermanent() {
            return true;
        }

        public long runTask() {
            long next;
            long now;
            do {
                this.dispatchAlarm();
                next = _heap.nextAlarmTime();
                now = Alarm.getCurrentTime();
                if (next >= 0L) continue;
                return 120000L;
            } while (now >= next);
            return next - now;
        }

        private void dispatchAlarm() {
            try {
                Alarm alarm = _heap.extractAlarm(Alarm.getCurrentTime());
                if (alarm != null) {
                    _runningAlarmCount.incrementAndGet();
                    long now = _isStressTest ? Alarm.getExactTime() : Alarm.getCurrentTime();
                    long delta = now - alarm._wakeTime;
                    if (delta > 10000L) {
                        log.warning(this + " slow alarm " + alarm + " " + delta + "ms");
                    } else if (_isStressTest && delta > 100L) {
                        System.out.println(this + " slow alarm " + alarm + " " + delta);
                    }
                    if (alarm.isPriority()) {
                        ThreadPool.getThreadPool().schedulePriority(alarm);
                    } else {
                        ThreadPool.getThreadPool().schedule(alarm);
                    }
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    static class AlarmThread
    extends Thread {
        AlarmThread() {
            super("resin-timer");
            this.setDaemon(true);
            this.setPriority(10);
        }

        public void run() {
            int idleCount = 0;
            while (true) {
                try {
                    while (true) {
                        if (_testTime > 0L) {
                            _currentTime = _testTime;
                            LockSupport.park();
                            continue;
                        }
                        long now = System.currentTimeMillis();
                        _currentTime = now;
                        boolean isCurrentTimeUsed = _isCurrentTimeUsed;
                        _isCurrentTimeUsed = false;
                        if (isCurrentTimeUsed) {
                            _isSlowTime = false;
                        } else if (++idleCount == 10) {
                            _isSlowTime = true;
                        }
                        long sleepTime = _isSlowTime ? 1000L : 5L;
                        LockSupport.parkNanos(sleepTime * 1000000L);
                    }
                }
                catch (Throwable throwable) {
                    continue;
                }
                break;
            }
        }
    }
}

