/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

public class Hex {
    public static String toHex(byte[] bytes) {
        if (bytes == null) {
            return "null";
        }
        return Hex.toHex(bytes, 0, bytes.length);
    }

    public static String toHex(byte[] bytes, int offset, int len) {
        if (bytes == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            int d1 = bytes[offset + i] >> 4 & 0xF;
            int d2 = bytes[offset + i] & 0xF;
            if (d1 < 10) {
                sb.append((char)(48 + d1));
            } else {
                sb.append((char)(97 + d1 - 10));
            }
            if (d2 < 10) {
                sb.append((char)(48 + d2));
                continue;
            }
            sb.append((char)(97 + d2 - 10));
        }
        return sb.toString();
    }

    public static byte[] toBytes(String hex) {
        if (hex == null) {
            return null;
        }
        int len = hex.length();
        byte[] bytes = new byte[len / 2];
        int k = 0;
        for (int i = 0; i < len; i += 2) {
            int digit = 0;
            char ch = hex.charAt(i);
            if ('0' <= ch && ch <= '9') {
                digit = ch - 48;
            } else if ('a' <= ch && ch <= 'f') {
                digit = ch - 97 + 10;
            } else if ('A' <= ch && ch <= 'F') {
                digit = ch - 65 + 10;
            }
            ch = hex.charAt(i + 1);
            if ('0' <= ch && ch <= '9') {
                digit = 16 * digit + ch - 48;
            } else if ('a' <= ch && ch <= 'f') {
                digit = 16 * digit + ch - 97 + 10;
            } else if ('A' <= ch && ch <= 'F') {
                digit = 16 * digit + ch - 65 + 10;
            }
            bytes[k++] = (byte)digit;
        }
        return bytes;
    }
}

