/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.CacheListener;
import com.caucho.util.Primes;
import com.caucho.util.SyncCacheListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongKeyLruCache<V> {
    private static final Logger log = Logger.getLogger(LongKeyLruCache.class.getName());
    private static final int LRU_MASK = 0x3FFFFFFF;
    private final int _capacity;
    private final int _capacity1;
    private final CacheItem<V>[] _entries;
    private final Object[] _locks;
    private final int _prime;
    private final Object _lruLock = new Object();
    private int _size1;
    private CacheItem<V> _head1;
    private CacheItem<V> _tail1;
    private int _size2;
    private CacheItem<V> _head2;
    private CacheItem<V> _tail2;
    private final int _lruTimeout;
    private final AtomicBoolean _isLruTailRemove = new AtomicBoolean();
    private volatile int _lruCounter;
    private volatile long _hitCount;
    private volatile long _missCount;

    public LongKeyLruCache(int initialCapacity) {
        int capacity = this.calculateCapacity(initialCapacity);
        this._entries = new CacheItem[capacity];
        this._prime = Primes.getBiggestPrime(this._entries.length);
        this._locks = new Object[(this._entries.length >> 3) + 1];
        for (int i = 0; i < this._locks.length; ++i) {
            this._locks[i] = new Object();
        }
        this._capacity = initialCapacity;
        this._capacity1 = this._capacity / 2;
        this._lruTimeout = capacity > 32 ? capacity / 32 : 1;
    }

    public int size() {
        return this._size1 + this._size2;
    }

    public int getCapacity() {
        return this._capacity;
    }

    public LongKeyLruCache<V> ensureCapacity(int newCapacity) {
        int capacity = this.calculateCapacity(newCapacity);
        if (capacity <= this._entries.length) {
            return this;
        }
        return this.setCapacity(newCapacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LongKeyLruCache<V> setCapacity(int newCapacity) {
        int capacity = this.calculateCapacity(newCapacity);
        if (capacity == this._entries.length) {
            return this;
        }
        LongKeyLruCache newCache = new LongKeyLruCache(newCapacity);
        for (int i = 0; i < this._entries.length; ++i) {
            Object lock;
            Object object = lock = this.getLock(i);
            synchronized (object) {
                CacheItem<V> item = this._entries[i];
                while (item != null) {
                    newCache.put(item._key, item._value);
                    item = item._nextHash;
                }
                this._entries[i] = null;
                continue;
            }
        }
        return newCache;
    }

    private int calculateCapacity(int initialCapacity) {
        int capacity;
        for (capacity = 16; capacity < 8 * initialCapacity; capacity *= 2) {
        }
        return capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object listener;
        int i;
        ArrayList<CacheListener> listeners = null;
        ArrayList<SyncCacheListener> syncListeners = null;
        for (i = this._entries.length - 1; i >= 0; --i) {
            Object lock;
            Object object = lock = this.getLock(i);
            synchronized (object) {
                CacheItem<V> item = this._entries[i];
                while (item != null) {
                    this.removeLruItem(item);
                    if (item._value instanceof CacheListener) {
                        if (listeners == null) {
                            listeners = new ArrayList<CacheListener>();
                        }
                        listeners.add((CacheListener)item._value);
                    }
                    if (item._value instanceof SyncCacheListener) {
                        if (syncListeners == null) {
                            syncListeners = new ArrayList<SyncCacheListener>();
                        }
                        syncListeners.add((SyncCacheListener)item._value);
                    }
                    item = item._nextHash;
                }
                this._entries[i] = null;
                continue;
            }
        }
        int n = i = listeners == null ? -1 : listeners.size() - 1;
        while (i >= 0) {
            listener = (CacheListener)listeners.get(i);
            listener.removeEvent();
            --i;
        }
        int n2 = i = syncListeners == null ? -1 : syncListeners.size() - 1;
        while (i >= 0) {
            listener = (SyncCacheListener)syncListeners.get(i);
            listener.syncRemoveEvent();
            --i;
        }
    }

    public V get(long key) {
        int hash = LongKeyLruCache.hash(key) % this._prime;
        CacheItem<V> item = this._entries[hash];
        while (item != null) {
            if (item._key == key) {
                this.updateLru(item);
                ++this._hitCount;
                return item._value;
            }
            item = item._nextHash;
        }
        ++this._missCount;
        return null;
    }

    public V put(long key, V value) {
        V oldValue = this.put(key, value, true);
        if (oldValue instanceof CacheListener) {
            ((CacheListener)oldValue).removeEvent();
        }
        return oldValue;
    }

    public V putIfNew(long key, V value) {
        V oldValue = this.put(key, value, false);
        if (oldValue != null) {
            return oldValue;
        }
        return value;
    }

    public V putIfAbsent(long key, V value) {
        return this.put(key, value, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V put(long key, V value, boolean replace) {
        Object lock;
        this.removeLru();
        int hash = LongKeyLruCache.hash(key) % this._prime;
        V oldValue = null;
        Object object = lock = this.getLock(hash);
        synchronized (object) {
            CacheItem<V> item = this._entries[hash];
            while (item != null) {
                if (item._key == key) {
                    this.updateLru(item);
                    oldValue = item._value;
                    if (!replace) break;
                    if (oldValue instanceof SyncCacheListener) {
                        ((SyncCacheListener)oldValue).syncRemoveEvent();
                    }
                    item._value = value;
                    break;
                }
                item = item._nextHash;
            }
            if (item == null) {
                CacheItem<V> next = this._entries[hash];
                item = new CacheItem<V>(key, value);
                this.addNewLruItem(item);
                item._nextHash = next;
                this._entries[hash] = item;
                return null;
            }
        }
        if (replace && oldValue instanceof CacheListener) {
            ((CacheListener)oldValue).removeEvent();
        }
        return oldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNewLruItem(CacheItem<V> item) {
        Object object = this._lruLock;
        synchronized (object) {
            item._lruCounter = this._lruCounter = this._lruCounter + 1 & 0x3FFFFFFF;
            ++this._size1;
            item._nextLru = this._head1;
            if (this._head1 != null) {
                this._head1._prevLru = item;
            }
            this._head1 = item;
            if (this._tail1 == null) {
                this._tail1 = item;
            }
        }
    }

    private void updateLru(CacheItem<V> item) {
        long lruCounter = this._lruCounter;
        long itemCounter = item._lruCounter;
        long delta = lruCounter - itemCounter & 0x3FFFFFFFL;
        if ((long)this._lruTimeout < delta || delta < 0L) {
            this.updateLruImpl(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLruImpl(CacheItem<V> item) {
        Object object = this._lruLock;
        synchronized (object) {
            item._lruCounter = this._lruCounter = this._lruCounter + 1 & 0x3FFFFFFF;
            CacheItem prevLru = item._prevLru;
            CacheItem nextLru = item._nextLru;
            if (item._hitCount <= 0) {
                return;
            }
            if (item._hitCount == 1) {
                item._hitCount = 2;
                item._prevLru = null;
                item._nextLru = this._head2;
                if (prevLru != null) {
                    prevLru._nextLru = nextLru;
                } else {
                    assert (this._head1 == item);
                    this._head1 = nextLru;
                }
                if (nextLru != null) {
                    nextLru._prevLru = prevLru;
                } else {
                    assert (this._tail1 == item);
                    this._tail1 = prevLru;
                }
                if (this._head2 != null) {
                    this._head2._prevLru = item;
                } else {
                    assert (this._tail2 == null);
                    this._tail2 = item;
                }
                this._head2 = item;
                --this._size1;
                ++this._size2;
            } else {
                if (item == this._head2) {
                    return;
                }
                item._prevLru = null;
                item._nextLru = this._head2;
                prevLru._nextLru = nextLru;
                this._head2._prevLru = item;
                this._head2 = item;
                if (nextLru != null) {
                    nextLru._prevLru = prevLru;
                } else {
                    assert (this._tail2 == item);
                    this._tail2 = prevLru;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLru() {
        if (this._capacity <= this._size1 + this._size2 && this._isLruTailRemove.compareAndSet(false, true)) {
            try {
                while (this._capacity <= this._size1 + this._size2 && this.removeTail()) {
                }
                Object var2_1 = null;
                this._isLruTailRemove.set(false);
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this._isLruTailRemove.set(false);
                throw throwable;
            }
        }
    }

    public boolean removeTail() {
        CacheItem<V> tail = null;
        if (this._capacity1 <= this._size1) {
            tail = this._tail1;
        }
        if (tail == null && (tail = this._tail2) == null && (tail = this._tail1) == null) {
            return false;
        }
        if (tail == null) {
            return false;
        }
        V value = this.remove(tail._key, true);
        return value != null;
    }

    public V remove(long key) {
        return this.remove(key, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V remove(long key, boolean isTail) {
        Object lock;
        int hash = LongKeyLruCache.hash(key) % this._prime;
        V value = null;
        Object object = lock = this.getLock(hash);
        synchronized (object) {
            CacheItem<V> prevItem = null;
            CacheItem<V> item = this._entries[hash];
            while (item != null) {
                if (item._key == key) {
                    value = item._value;
                    SyncCacheListener syncListener = null;
                    if (value instanceof SyncCacheListener) {
                        syncListener = (SyncCacheListener)value;
                        if (isTail && !syncListener.startLruRemove()) {
                            item._lruCounter = this._lruCounter - this._lruTimeout - 2;
                            this.updateLruImpl(item);
                            return null;
                        }
                    }
                    this.removeLruItem(item);
                    if (syncListener != null) {
                        if (isTail) {
                            syncListener.syncLruRemoveEvent();
                        } else {
                            syncListener.syncRemoveEvent();
                        }
                    }
                    CacheItem nextHash = item._nextHash;
                    if (prevItem != null) {
                        prevItem._nextHash = nextHash;
                        break;
                    }
                    assert (this._entries[hash] == item);
                    this._entries[hash] = nextHash;
                    break;
                }
                prevItem = item;
                item = item._nextHash;
            }
        }
        if (value instanceof CacheListener) {
            ((CacheListener)value).removeEvent();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLruItem(CacheItem<V> item) {
        Object object = this._lruLock;
        synchronized (object) {
            this._lruCounter = this._lruCounter + 1 & 0x3FFFFFFF;
            CacheItem prevLru = item._prevLru;
            CacheItem nextLru = item._nextLru;
            item._prevLru = null;
            item._nextLru = null;
            int hitCount = item._hitCount;
            item._hitCount = -1;
            if (hitCount <= 0) {
                return;
            }
            if (hitCount == 1) {
                --this._size1;
                if (prevLru != null) {
                    prevLru._nextLru = nextLru;
                } else {
                    assert (this._head1 == item);
                    this._head1 = nextLru;
                }
                if (nextLru != null) {
                    nextLru._prevLru = prevLru;
                } else {
                    assert (this._tail1 == item);
                    this._tail1 = prevLru;
                }
            } else {
                --this._size2;
                if (prevLru != null) {
                    prevLru._nextLru = nextLru;
                } else {
                    assert (this._head2 == item);
                    this._head2 = nextLru;
                }
                if (nextLru != null) {
                    nextLru._prevLru = prevLru;
                } else {
                    assert (this._tail2 == item);
                    this._tail2 = prevLru;
                }
            }
        }
    }

    private static int hash(long key) {
        long hash = key;
        hash = 65537L * hash + (key >>> 8);
        hash = 65537L * hash + (key >>> 16);
        hash = 65537L * hash + (key >>> 32);
        hash = 65537L * hash + (key >>> 48);
        return (int)(hash & Integer.MAX_VALUE);
    }

    private Object getLock(int hash) {
        return this._locks[hash >> 3];
    }

    public Iterator<V> values() {
        ValueIterator iter = new ValueIterator(this);
        iter.init(this);
        return iter;
    }

    public Iterator<V> values(Iterator<V> oldIter) {
        ValueIterator iter = (ValueIterator)oldIter;
        iter.init(this);
        return oldIter;
    }

    public long getHitCount() {
        return this._hitCount;
    }

    public long getMissCount() {
        return this._missCount;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ValueIterator<V>
    implements Iterator<V> {
        private LongKeyLruCache<V> _cache;
        private CacheItem<V> _entry;
        private int _i = -1;

        ValueIterator(LongKeyLruCache<V> cache) {
            this.init(cache);
        }

        void init(LongKeyLruCache<V> cache) {
            this._cache = cache;
            this._entry = null;
            this._i = -1;
        }

        @Override
        public boolean hasNext() {
            int i;
            if (this._entry != null) {
                return true;
            }
            CacheItem[] entries = ((LongKeyLruCache)this._cache)._entries;
            int length = entries.length;
            for (i = this._i + 1; i < length; ++i) {
                if (entries[i] == null) continue;
                this._i = i - 1;
                return true;
            }
            this._i = i;
            return false;
        }

        @Override
        public V next() {
            int i;
            CacheItem entry = this._entry;
            if (entry != null) {
                this._entry = entry._nextHash;
                return entry._value;
            }
            CacheItem[] entries = ((LongKeyLruCache)this._cache)._entries;
            int length = entries.length;
            for (i = this._i + 1; i < length; ++i) {
                entry = entries[i];
                if (entry == null) continue;
                this._entry = entry._nextHash;
                this._i = i;
                return entry._value;
            }
            this._i = i;
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CacheItem<V> {
        CacheItem<V> _nextHash;
        CacheItem<V> _prevLru;
        CacheItem<V> _nextLru;
        long _key;
        V _value;
        int _index;
        int _hitCount = 1;
        int _lruCounter;

        CacheItem(long key, V value) {
            this._key = key;
            this._value = value;
        }
    }
}

