/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.inject.Module;
import com.caucho.vfs.ClientDisconnectException;
import com.caucho.vfs.JniSocketImpl;
import com.caucho.vfs.NullPath;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.SocketTimeoutException;
import com.caucho.vfs.StreamImpl;
import java.io.IOException;
import java.io.InterruptedIOException;

@Module
public class JniStream
extends StreamImpl {
    private static final int INTERRUPT_EXN = -2;
    private static final int DISCONNECT_EXN = -3;
    public static final int TIMEOUT_EXN = -4;
    private static NullPath NULL_PATH;
    private final JniSocketImpl _socket;
    private IOException _readException;
    private long _totalReadBytes;
    private long _totalWriteBytes;

    public JniStream(JniSocketImpl socket) {
        this._socket = socket;
        if (NULL_PATH == null) {
            NULL_PATH = new NullPath("jni-stream");
        }
        this.setPath(NULL_PATH);
    }

    public void init() {
        this._readException = null;
    }

    public boolean canRead() {
        return !this._socket.isClosed();
    }

    public int read(byte[] buf, int offset, int length) throws IOException {
        if (buf == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || buf.length < offset + length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this._readException != null) {
            throw this._readException;
        }
        int result = this._socket.read(buf, offset, length, -1L);
        if (result > 0) {
            this._totalReadBytes += (long)result;
            return result;
        }
        if (result < -1) {
            this._readException = this.exception(result);
            throw this._readException;
        }
        return -1;
    }

    public int readTimeout(byte[] buf, int offset, int length, long timeout) throws IOException {
        if (buf == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || buf.length < offset + length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int result = this._socket.read(buf, offset, length, timeout);
        if (result > 0) {
            this._totalReadBytes += (long)result;
            return result;
        }
        if (result == -4) {
            return ReadStream.READ_TIMEOUT;
        }
        if (result < -1) {
            throw this.exception(result);
        }
        return -1;
    }

    public int getAvailable() throws IOException {
        return 0;
    }

    public boolean canWrite() {
        return !this._socket.isClosed();
    }

    public void write(byte[] buf, int offset, int length, boolean isEnd) throws IOException {
        if (length <= 0) {
            return;
        }
        if (buf == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || buf.length < offset + length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int result = this._socket.write(buf, offset, length, isEnd);
        if (result <= -1) {
            throw this.exception(result);
        }
        this._totalWriteBytes += (long)result;
    }

    public void flush() throws IOException {
    }

    public long getTotalReadBytes() {
        return this._totalReadBytes;
    }

    public long getTotalWriteBytes() {
        return this._totalWriteBytes;
    }

    IOException exception(int result) throws IOException {
        switch (result) {
            case -2: {
                return new InterruptedIOException("interrupted i/o");
            }
            case -3: {
                return new ClientDisconnectException("connection reset by peer");
            }
            case -4: {
                return new SocketTimeoutException("client timeout");
            }
        }
        return new ClientDisconnectException("unknown exception=" + result);
    }

    public void close() throws IOException {
        this._socket.close();
    }
}

