/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.inject.Module;
import com.caucho.vfs.StreamImpl;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.channels.SelectableChannel;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

@Module
public abstract class QSocket {
    public abstract InetAddress getLocalAddress();

    public String getLocalHost() {
        InetAddress localAddress = this.getLocalAddress();
        if (localAddress != null) {
            return localAddress.getHostAddress();
        }
        return null;
    }

    public abstract int getLocalPort();

    public abstract InetAddress getRemoteAddress();

    public String getRemoteHost() {
        InetAddress remoteAddress = this.getRemoteAddress();
        if (remoteAddress != null) {
            return remoteAddress.getHostAddress();
        }
        return null;
    }

    public int getRemoteAddress(byte[] buffer, int offset, int length) {
        String name = this.getRemoteHost();
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            buffer[i + offset] = (byte)name.charAt(i);
        }
        return len;
    }

    public byte[] getRemoteIP() {
        InetAddress addr = this.getRemoteAddress();
        return addr.getAddress();
    }

    public abstract int getRemotePort();

    public boolean isSecure() {
        return false;
    }

    public SelectableChannel getSelectableChannel() {
        return null;
    }

    public boolean readNonBlock(int ms) {
        return false;
    }

    public String getCipherSuite() {
        return null;
    }

    public int getCipherBits() {
        return 0;
    }

    public X509Certificate getClientCertificate() throws CertificateException {
        return null;
    }

    public X509Certificate[] getClientCertificates() throws CertificateException {
        X509Certificate cert = this.getClientCertificate();
        if (cert != null) {
            return new X509Certificate[]{cert};
        }
        return null;
    }

    public abstract StreamImpl getStream() throws IOException;

    public abstract long getTotalReadBytes();

    public abstract long getTotalWriteBytes();

    public abstract boolean isClosed();

    public void forceShutdown() {
    }

    public abstract void close() throws IOException;
}

