/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.TempInputStream;
import com.caucho.vfs.TempInputStreamNoFree;
import com.caucho.vfs.TempReadStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TempOutputStream
extends OutputStream {
    private TempBuffer _head;
    private TempBuffer _tail;

    public byte[] getTail() {
        return this._tail.getBuffer();
    }

    public void write(int ch) {
        if (this._tail == null) {
            this.addBuffer(TempBuffer.allocate());
        } else if (this._tail._buf.length <= this._tail._length) {
            this.addBuffer(TempBuffer.allocate());
        }
        this._tail.getBuffer()[this._tail._length++] = (byte)ch;
    }

    public void write(byte[] buf, int offset, int length) {
        int sublen;
        TempBuffer tail = this._tail;
        int bufferSize = TempBuffer.SIZE;
        int tailLength = tail != null ? tail._length : 0;
        for (int index = 0; index < length; index += sublen) {
            if (tail == null) {
                this.addBuffer(TempBuffer.allocate());
                tail = this._tail;
                tailLength = tail._length;
            } else if (bufferSize <= tailLength) {
                this.addBuffer(TempBuffer.allocate());
                tail = this._tail;
                tailLength = tail._length;
            }
            sublen = bufferSize - tailLength;
            if (length - index < sublen) {
                sublen = length - index;
            }
            System.arraycopy(buf, index + offset, tail._buf, tailLength, sublen);
            tail._length = tailLength += sublen;
        }
    }

    public void write(byte[] buffer) {
        this.write(buffer, 0, buffer.length);
    }

    private void addBuffer(TempBuffer buf) {
        buf._next = null;
        if (this._tail != null) {
            this._tail._next = buf;
            this._tail = buf;
        } else {
            this._tail = buf;
            this._head = buf;
        }
        ++this._head._bufferCount;
    }

    public void flush() {
    }

    public void close() {
    }

    public ReadStream openRead() throws IOException {
        this.close();
        TempReadStream read = new TempReadStream(this._head);
        read.setFreeWhenDone(true);
        this._head = null;
        this._tail = null;
        return new ReadStream(read);
    }

    public InputStream getInputStream() throws IOException {
        this.close();
        TempBuffer head = this._head;
        this._head = null;
        this._tail = null;
        return new TempInputStream(head);
    }

    public InputStream openInputStream() throws IOException {
        this.close();
        TempBuffer head = this._head;
        this._head = null;
        this._tail = null;
        return new TempInputStream(head);
    }

    public InputStream openInputStreamNoFree() throws IOException {
        this.close();
        TempBuffer head = this._head;
        return new TempInputStreamNoFree(head);
    }

    public TempBuffer getHead() {
        return this._head;
    }

    public void clear() {
        this._head = null;
        this._tail = null;
    }

    public void writeToStream(OutputStream os) throws IOException {
        TempBuffer ptr = this._head;
        while (ptr != null) {
            os.write(ptr.getBuffer(), 0, ptr.getLength());
            ptr = ptr._next;
        }
    }

    public int getLength() {
        int length = 0;
        TempBuffer ptr = this._head;
        while (ptr != null) {
            length += ptr.getLength();
            ptr = ptr._next;
        }
        return length;
    }

    public byte[] toByteArray() {
        int len = this.getLength();
        byte[] data = new byte[len];
        int offset = 0;
        TempBuffer ptr = this._head;
        while (ptr != null) {
            System.arraycopy(ptr.getBuffer(), 0, data, offset, ptr.getLength());
            offset += ptr.getLength();
            ptr = ptr._next;
        }
        return data;
    }

    public void readAll(int position, char[] buffer, int offset, int length) {
        int len = this.getLength();
        TempBuffer ptr = this._head;
        while (ptr != null && ptr.getLength() <= position) {
            position -= ptr.getLength();
            ptr = ptr._next;
        }
        if (ptr == null) {
            return;
        }
        while (ptr != null && length >= 0) {
            int sublen = ptr.getLength() - position;
            if (length < sublen) {
                sublen = length;
            }
            byte[] dataBuffer = ptr.getBuffer();
            int tail = position + sublen;
            while (position < tail) {
                buffer[offset++] = (char)(dataBuffer[position] & 0xFF);
                ++position;
            }
            length -= sublen;
            ptr = ptr._next;
        }
    }

    public void readAll(int position, byte[] buffer, int offset, int length) {
        int len = this.getLength();
        TempBuffer ptr = this._head;
        while (ptr != null && ptr.getLength() <= position) {
            position -= ptr.getLength();
            ptr = ptr._next;
        }
        if (ptr == null) {
            return;
        }
        while (ptr != null && length >= 0) {
            int sublen = ptr.getLength() - position;
            if (length < sublen) {
                sublen = length;
            }
            byte[] dataBuffer = ptr.getBuffer();
            System.arraycopy(dataBuffer, position, buffer, offset, sublen);
            offset += sublen;
            position = 0;
            length -= sublen;
            ptr = ptr._next;
        }
    }

    public void destroy() {
        TempBuffer ptr = this._head;
        this._head = null;
        this._tail = null;
        TempBuffer.freeAll(ptr);
    }
}

