/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.ReadWritePair;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class VfsStream
extends StreamImpl {
    private static byte[] unixNewline = new byte[]{10};
    private InputStream is;
    private OutputStream _os;
    private boolean flushOnNewline;
    private boolean closeChildOnClose = true;
    private byte[] newline = unixNewline;
    private long position;

    public VfsStream() {
    }

    public VfsStream(InputStream is, OutputStream os) {
        this.init(is, os);
    }

    public VfsStream(InputStream is, OutputStream os, Path path) {
        this.init(is, os);
        this.setPath(path);
    }

    public void init(InputStream is, OutputStream os) {
        this.is = is;
        this._os = os;
        this.setPath(null);
        this.flushOnNewline = false;
        this.closeChildOnClose = true;
        this.position = 0L;
    }

    public void setNewline(byte[] newline) {
        this.newline = newline;
    }

    public byte[] getNewline() {
        return this.newline;
    }

    public static ReadWritePair openReadWrite(InputStream is, OutputStream os) {
        VfsStream s = new VfsStream(is, os);
        WriteStream writeStream = new WriteStream(s);
        ReadStream readStream = new ReadStream(s, writeStream);
        return new ReadWritePair(readStream, writeStream);
    }

    public static ReadStream openRead(InputStream is) {
        VfsStream s = new VfsStream(is, null);
        return new ReadStream(s);
    }

    public static ReadStream openRead(InputStream is, WriteStream ws) {
        VfsStream s = new VfsStream(is, null);
        return new ReadStream(s, ws);
    }

    public static WriteStream openWrite(OutputStream os) {
        VfsStream s = new VfsStream(null, os);
        return new WriteStream(s);
    }

    public boolean canRead() {
        return this.is != null;
    }

    public int read(byte[] buf, int offset, int length) throws IOException {
        if (this.is == null) {
            return -1;
        }
        int len = this.is.read(buf, offset, length);
        if (len > 0) {
            this.position += (long)len;
        }
        return len;
    }

    public boolean hasSkip() {
        return true;
    }

    public long skip(long n) throws IOException {
        return this.is.skip(n);
    }

    public int getAvailable() throws IOException {
        if (this.is == null) {
            return -1;
        }
        return this.is.available();
    }

    public long getReadPosition() {
        return this.position;
    }

    public boolean canWrite() {
        return this._os != null;
    }

    public boolean getFlushOnNewline() {
        return this.flushOnNewline;
    }

    public void setFlushOnNewline(boolean value) {
        this.flushOnNewline = value;
    }

    public void write(byte[] buf, int offset, int length, boolean isEnd) throws IOException {
        OutputStream os = this._os;
        if (os != null) {
            os.write(buf, offset, length);
        }
    }

    public void flushToDisk() throws IOException {
        this.flush();
    }

    public void flush() throws IOException {
        if (this._os != null) {
            this._os.flush();
        }
    }

    public void setCloseChildOnClose(boolean close) {
        this.closeChildOnClose = close;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() throws IOException {
        try {
            if (this._os != null && this.closeChildOnClose) {
                this._os.close();
                this._os = null;
            }
            Object var2_1 = null;
            if (this.is == null || !this.closeChildOnClose) return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.is == null || !this.closeChildOnClose) throw throwable;
            this.is.close();
            this.is = null;
            throw throwable;
        }
        this.is.close();
        this.is = null;
    }
}

