/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml;

import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.caucho.xml.NamespaceMap;
import com.caucho.xml.QName;
import com.caucho.xml.XmlChar;
import com.caucho.xml.XmlParseException;
import com.caucho.xml.XmlParser;
import java.util.HashMap;

class Policy {
    static L10N L = new L10N(Policy.class);
    static final int ERROR = 0;
    static final int IGNORE = 1;
    static final int PUSH = 2;
    static final int PUSH_EMPTY = 3;
    static final int PUSH_OPT = 4;
    static final int PUSH_VERBATIM = 5;
    static final int POP = 6;
    static final int POP_AND_LOOP = 7;
    private NamespaceMap namespaces;
    private HashMap nameCache = new HashMap();
    private HashMap _attrCache = new HashMap();
    protected QName opt;
    protected ReadStream is;
    boolean expandReferences = true;
    boolean optionalTags = true;
    boolean skipWhitespace;
    boolean skipComments;
    boolean strictComments;
    boolean strictAttributes;
    boolean entitiesAsText = false;
    boolean expandEntities = true;
    boolean strictCharacters;
    boolean strictXml;
    boolean singleTopElement;
    boolean normalizeWhitespace = false;
    boolean forgiving;
    boolean _isNamespaceAware = false;

    Policy() {
    }

    void init() {
        this.namespaces = null;
        this.nameCache.clear();
        this._attrCache.clear();
        this.opt = null;
        this.is = null;
        this.expandReferences = true;
        this.optionalTags = true;
        this.skipWhitespace = false;
        this.skipComments = false;
        this.strictComments = false;
        this.strictAttributes = false;
        this.entitiesAsText = false;
        this.expandEntities = true;
        this.strictCharacters = false;
        this.strictXml = false;
        this.singleTopElement = false;
        this.normalizeWhitespace = false;
        this.forgiving = false;
        this._isNamespaceAware = false;
    }

    void setStream(ReadStream is) {
        this.is = is;
    }

    QName getOpt() {
        return this.opt;
    }

    void setNamespace(NamespaceMap ns) {
        if (this.namespaces != ns) {
            this.nameCache.clear();
            this._attrCache.clear();
        }
        this.namespaces = ns;
    }

    void setNamespaceAware(boolean isNamespaceAware) {
        this._isNamespaceAware = isNamespaceAware;
    }

    void clearNamespaceCache() {
        this.namespaces = null;
        this.nameCache.clear();
        this._attrCache.clear();
    }

    QName getAttributeName(CharBuffer eltName, CharBuffer source) {
        return this.getAttributeName(eltName, source, false);
    }

    QName getAttributeName(CharBuffer eltName, CharBuffer source, boolean nsNull) {
        QName qname = (QName)this._attrCache.get(source);
        if (qname != null) {
            return qname;
        }
        int i = source.lastIndexOf(':');
        String fullName = source.toString();
        String prefix = null;
        String localName = null;
        String ns = null;
        if (!this._isNamespaceAware) {
            localName = fullName;
        } else if (i < 0) {
            localName = fullName;
        } else {
            prefix = source.substring(0, i);
            ns = NamespaceMap.get(this.namespaces, prefix);
            if (ns != null) {
                localName = source.substring(i + 1);
            } else if ("xml".equals(prefix)) {
                ns = "http://www.w3.org/XML/1998/namespace";
                localName = source.substring(i + 1);
            } else {
                prefix = null;
                localName = source.toString();
            }
        }
        qname = new QName(fullName, prefix, localName, ns);
        this._attrCache.put(source.clone(), qname);
        return qname;
    }

    QName getName(CharBuffer source) {
        QName qname = (QName)this.nameCache.get(source);
        if (qname != null) {
            return qname;
        }
        int i = source.lastIndexOf(':');
        String fullName = source.toString();
        String prefix = null;
        String localName = null;
        String ns = null;
        if (this._isNamespaceAware) {
            if (i < 0) {
                ns = NamespaceMap.get(this.namespaces, "");
                localName = source.toString();
            } else {
                prefix = source.substring(0, i);
                ns = NamespaceMap.get(this.namespaces, prefix);
                if (ns != null) {
                    localName = source.substring(i + 1);
                } else {
                    prefix = null;
                    localName = source.toString();
                }
            }
        }
        qname = new QName(fullName, prefix, localName, ns);
        this.nameCache.put(source.clone(), qname);
        return qname;
    }

    QName getNamespaceName(CharBuffer source) {
        QName qname = (QName)this.nameCache.get(source);
        if (qname != null) {
            return qname;
        }
        int i = source.lastIndexOf(':');
        String prefix = null;
        String localName = source.toString();
        qname = new QName(prefix, localName, null);
        this.nameCache.put(source.clone(), qname);
        return qname;
    }

    boolean isWhitespaceOnly(String s) {
        for (int i = s.length() - 1; i >= 0; --i) {
            if (XmlChar.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    int openAction(XmlParser parser, QName node, QName next) throws XmlParseException {
        String nodeName = node.getName();
        return 2;
    }

    int elementCloseAction(XmlParser parser, QName node, String tagEnd) throws XmlParseException {
        String nodeName = node.getName();
        if (nodeName.equals("#document") && tagEnd.equals("")) {
            return 6;
        }
        if (nodeName.equals(tagEnd)) {
            return 6;
        }
        String expect = nodeName;
        expect = expect.equals("#document") ? L.l("end of document") : "`</" + expect + ">'";
        tagEnd = tagEnd.equals("") ? L.l("end of file") : "`</" + tagEnd + ">'";
        throw parser.error(L.l("expected {0} at {1}", (Object)expect, tagEnd));
    }
}

