/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml.stream;

import com.caucho.util.L10N;
import com.caucho.xml.QDocument;
import com.caucho.xml.stream.NamespaceWriterContext;
import com.caucho.xml.stream.PropertyNotSupportedException;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMResultXMLStreamWriterImpl
implements XMLStreamWriter {
    private static final Logger log = Logger.getLogger(DOMResultXMLStreamWriterImpl.class.getName());
    private static final L10N L = new L10N(DOMResultXMLStreamWriterImpl.class);
    private DOMResult _result;
    private Document _document;
    private Node _current;
    private boolean _currentIsEmpty = false;
    private boolean _repair = false;
    private NamespaceWriterContext _tracker;
    private boolean _flushed = true;

    public DOMResultXMLStreamWriterImpl(DOMResult result) throws XMLStreamException {
        this(result, false);
    }

    public DOMResultXMLStreamWriterImpl(DOMResult result, boolean repair) throws XMLStreamException {
        this._result = result;
        this._repair = repair;
        this._tracker = new NamespaceWriterContext(repair);
        this._current = result.getNode();
        if (this._current == null) {
            this._document = new QDocument();
            this._current = this._document;
            result.setNode(this._document);
        } else {
            this._document = this._current.getNodeType() == 9 ? (Document)this._current : this._current.getOwnerDocument();
        }
    }

    public void close() throws XMLStreamException {
        this.writeEndDocument();
    }

    public void flush() throws XMLStreamException {
    }

    public NamespaceContext getNamespaceContext() {
        return this._tracker;
    }

    public String getPrefix(String uri) throws XMLStreamException {
        return this._tracker.getPrefix(uri);
    }

    public Object getProperty(String name) throws IllegalArgumentException {
        throw new PropertyNotSupportedException(name);
    }

    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this._tracker.declare("", uri, this._repair);
    }

    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        String message = "please do not set the NamespaceContext";
        throw new UnsupportedOperationException(message);
    }

    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this._tracker.declare(prefix, uri);
    }

    public void writeAttribute(String localName, String value) throws XMLStreamException {
        try {
            ((Element)this._current).setAttribute(localName, value);
        }
        catch (ClassCastException e) {
            throw new XMLStreamException(e);
        }
        catch (DOMException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        if (this._repair) {
            String prefix = this._tracker.declare(namespaceURI);
            if (prefix == null) {
                ((Element)this._current).setAttributeNS(namespaceURI, localName, value);
            } else {
                String qname = prefix + ':' + localName;
                ((Element)this._current).setAttributeNS(namespaceURI, qname, value);
            }
        } else {
            String prefix = this._tracker.getPrefix(namespaceURI);
            if (prefix == null) {
                throw new XMLStreamException(L.l("No prefix defined for namespace {0}", namespaceURI));
            }
            String qname = prefix + ':' + localName;
            ((Element)this._current).setAttributeNS(namespaceURI, qname, value);
        }
    }

    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        try {
            if (this._repair && this._tracker.getPrefix(namespaceURI) == null) {
                this._tracker.declare(prefix, namespaceURI, true);
            } else {
                this._tracker.declare(prefix, namespaceURI);
            }
            String qname = prefix + ':' + localName;
            ((Element)this._current).setAttributeNS(namespaceURI, qname, value);
        }
        catch (ClassCastException e) {
            throw new XMLStreamException(e);
        }
        catch (DOMException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeCData(String data) throws XMLStreamException {
        if (this._currentIsEmpty) {
            this.popContext();
            this._currentIsEmpty = false;
        }
        try {
            this._current.appendChild(this._document.createCDATASection(data));
        }
        catch (DOMException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.writeCharacters(new String(text, start, len));
    }

    public void writeCharacters(String text) throws XMLStreamException {
        if (this._currentIsEmpty) {
            this.popContext();
            this._currentIsEmpty = false;
        }
        try {
            this._current.appendChild(this._document.createTextNode(text));
        }
        catch (DOMException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeComment(String data) throws XMLStreamException {
        if (this._currentIsEmpty) {
            this.popContext();
            this._currentIsEmpty = false;
        }
        try {
            this._current.appendChild(this._document.createComment(data));
        }
        catch (DOMException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this._tracker.declare("", namespaceURI, true);
    }

    public void writeDTD(String dtd) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    public void writeEmptyElement(String localName) throws XMLStreamException {
        if (this._currentIsEmpty) {
            this.popContext();
        }
        try {
            Node parent = this._current;
            this._current = this._document.createElement(localName);
            parent.appendChild(this._current);
            if (!(parent instanceof Document)) {
                this.pushContext();
            }
            this._currentIsEmpty = true;
        }
        catch (DOMException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        if (this._currentIsEmpty) {
            this.popContext();
        }
        try {
            String prefix;
            String qname = localName;
            if (this._repair) {
                prefix = this._tracker.declare(namespaceURI);
                if (prefix != null) {
                    qname = prefix + ':' + localName;
                }
            } else {
                prefix = this._tracker.getPrefix(namespaceURI);
                if (prefix == null) {
                    throw new XMLStreamException(L.l("No prefix defined for namespace {0}", namespaceURI));
                }
                qname = prefix + ':' + localName;
            }
            Node parent = this._current;
            this._current = this._document.createElementNS(namespaceURI, qname);
            parent.appendChild(this._current);
            if (!(parent instanceof Document)) {
                this.pushContext();
            }
            this._currentIsEmpty = true;
        }
        catch (DOMException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        if (this._currentIsEmpty) {
            this.popContext();
        }
        try {
            if (this._repair && this._tracker.getPrefix(namespaceURI) == null) {
                this._tracker.declare(prefix, namespaceURI, true);
            }
            Node parent = this._current;
            String qname = prefix + ':' + localName;
            this._current = this._document.createElementNS(namespaceURI, qname);
            parent.appendChild(this._current);
            if (!(parent instanceof Document)) {
                this.pushContext();
            }
            this._currentIsEmpty = true;
        }
        catch (DOMException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeEndDocument() throws XMLStreamException {
    }

    public void writeEndElement() throws XMLStreamException {
        try {
            this.popContext();
            if (this._currentIsEmpty) {
                this.popContext();
            }
            this._currentIsEmpty = false;
        }
        catch (ClassCastException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeEntityRef(String name) throws XMLStreamException {
        if (this._currentIsEmpty) {
            this.popContext();
            this._currentIsEmpty = false;
        }
        try {
            this._current.appendChild(this._document.createEntityReference(name));
        }
        catch (DOMException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        if (prefix == null || "".equals(prefix) || "xmlns".equals(prefix)) {
            this.writeDefaultNamespace(namespaceURI);
        } else {
            this._tracker.declare(prefix, namespaceURI, true);
            if (!(this._current instanceof Element)) {
                throw new XMLStreamException(L.l("Cannot write namespace without an element"));
            }
            String qname = "xmlns:" + prefix;
            ((Element)this._current).setAttributeNS("http://www.w3.org/XML/1998/namespace", qname, namespaceURI);
        }
    }

    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.writeProcessingInstruction(target, "");
    }

    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        if (this._currentIsEmpty) {
            this.popContext();
            this._currentIsEmpty = false;
        }
        try {
            this._current.appendChild(this._document.createProcessingInstruction(target, data));
        }
        catch (DOMException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeStartDocument() throws XMLStreamException {
        this.writeStartDocument("1.0");
    }

    public void writeStartDocument(String version) throws XMLStreamException {
        this.writeStartDocument(version, "utf-8");
    }

    public void writeStartDocument(String version, String encoding) throws XMLStreamException {
        try {
            this._document.setXmlVersion(version);
        }
        catch (DOMException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeStartElement(String localName) throws XMLStreamException {
        if (this._currentIsEmpty) {
            this.popContext();
            this._currentIsEmpty = false;
        }
        try {
            Node parent = this._current;
            this._current = this._document.createElement(localName);
            parent.appendChild(this._current);
            if (!(parent instanceof Document)) {
                this.pushContext();
            }
            this._currentIsEmpty = false;
        }
        catch (DOMException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        if (this._currentIsEmpty) {
            this.popContext();
            this._currentIsEmpty = false;
        }
        try {
            String prefix;
            String qname = localName;
            if (this._repair) {
                prefix = this._tracker.declare(namespaceURI);
                if (prefix != null) {
                    qname = prefix + ':' + localName;
                }
            } else {
                prefix = this._tracker.getPrefix(namespaceURI);
                if (prefix == null) {
                    throw new XMLStreamException(L.l("No prefix defined for namespace {0}", namespaceURI));
                }
                qname = prefix + ':' + localName;
            }
            Node parent = this._current;
            this._current = this._document.createElementNS(namespaceURI, qname);
            parent.appendChild(this._current);
            if (!(parent instanceof Document)) {
                this.pushContext();
            }
            this._currentIsEmpty = false;
        }
        catch (DOMException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        if (this._currentIsEmpty) {
            this.popContext();
            this._currentIsEmpty = false;
        }
        try {
            if (this._repair && this._tracker.getPrefix(namespaceURI) == null) {
                this._tracker.declare(prefix, namespaceURI, true);
            }
            Node parent = this._current;
            String qname = prefix + ':' + localName;
            this._current = this._document.createElementNS(namespaceURI, qname);
            parent.appendChild(this._current);
            if (!(parent instanceof Document)) {
                this.pushContext();
            }
            this._currentIsEmpty = false;
        }
        catch (DOMException e) {
            throw new XMLStreamException(e);
        }
    }

    private void pushContext() throws DOMException {
        this._tracker.push();
        this._flushed = false;
    }

    private void popContext() throws DOMException, XMLStreamException {
        this._tracker.pop();
        this._current = this._current.getParentNode();
    }
}

