/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml.stream;

import java.util.NoSuchElementException;
import javax.xml.stream.EventFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

class FilteredEventReader
implements XMLEventReader {
    private XMLEventReader _reader;
    private EventFilter _filter;
    private XMLEvent _current;
    private XMLEvent _next;

    public FilteredEventReader(XMLEventReader reader, EventFilter filter) {
        this._reader = reader;
        this._filter = filter;
    }

    public void close() throws XMLStreamException {
        this._reader.close();
    }

    public String getElementText() throws XMLStreamException {
        return this._reader.getElementText();
    }

    public Object getProperty(String name) throws IllegalArgumentException {
        return this._reader.getProperty(name);
    }

    public boolean hasNext() {
        try {
            this.peek();
            return this._next != null;
        }
        catch (XMLStreamException e) {
            return false;
        }
    }

    public XMLEvent nextEvent() throws XMLStreamException {
        if (this._next != null) {
            this._current = this._next;
            this._next = null;
        } else {
            while (this._reader.hasNext()) {
                this._current = this._reader.nextEvent();
                if (this._filter.accept(this._current)) break;
                this._current = null;
            }
        }
        if (this._current == null) {
            throw new NoSuchElementException();
        }
        return this._current;
    }

    public XMLEvent nextTag() throws XMLStreamException {
        if (this._next != null) {
            this._current = this._next;
            this._next = null;
        } else {
            while (this._reader.hasNext()) {
                this._current = this._reader.nextTag();
                if (this._filter.accept(this._current)) break;
                this._current = null;
            }
        }
        if (this._current == null) {
            throw new NoSuchElementException();
        }
        return this._current;
    }

    public XMLEvent peek() throws XMLStreamException {
        if (this._next == null) {
            while (this._reader.hasNext()) {
                this._next = this._reader.nextEvent();
                if (this._filter.accept(this._next)) break;
                this._next = null;
            }
        }
        return this._next;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public XMLEvent next() {
        try {
            return this.nextEvent();
        }
        catch (XMLStreamException e) {
            return null;
        }
    }
}

