/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml2;

import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.caucho.xml2.Entities;
import com.caucho.xml2.NamespaceMap;
import com.caucho.xml2.QAttributes;
import com.caucho.xml2.QComment;
import com.caucho.xml2.QContentParticle;
import com.caucho.xml2.QDocumentType;
import com.caucho.xml2.QElementDef;
import com.caucho.xml2.QEntity;
import com.caucho.xml2.QNotation;
import com.caucho.xml2.QProcessingInstruction;
import com.caucho.xml2.XmlChar;
import com.caucho.xml2.XmlEntities;
import com.caucho.xml2.XmlParseException;
import com.caucho.xml2.XmlParser;
import com.caucho.xml2.readers.MacroReader;
import com.caucho.xml2.readers.XmlReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.xml.sax.SAXException;

public class DtdParser {
    private static final L10N L = new L10N(DtdParser.class);
    static HashMap<String, String> _attrTypes = new HashMap();
    static Entities _entities = new XmlEntities();
    private XmlParser _xmlParser;
    QAttributes _attributes;
    QAttributes _nullAttributes;
    boolean _inDtd;
    boolean _strictComments = true;
    CharBuffer _text;
    CharBuffer _eltName;
    CharBuffer _cb;
    CharBuffer _buf = new CharBuffer();
    String _textFilename;
    int _textLine;
    char[] _textBuffer = new char[1024];
    int _textLength;
    int _textCapacity = this._textBuffer.length;
    boolean _isIgnorableWhitespace;
    boolean _isJspText;
    CharBuffer _name = new CharBuffer();
    CharBuffer _nameBuffer = new CharBuffer();
    MacroReader _macro = new MacroReader();
    int _macroIndex = 0;
    int _macroLength = 0;
    char[] _macroBuffer;
    QName[] _elementNames = new QName[64];
    NamespaceMap[] _namespaces = new NamespaceMap[64];
    int[] _elementLines = new int[64];
    int _elementTop;
    NamespaceMap _namespaceMap;
    ArrayList<String> _attrNames = new ArrayList();
    ArrayList<String> _attrValues = new ArrayList();
    ReadStream _is;
    XmlReader _reader;
    String _extPublicId;
    String _extSystemId;
    QName _activeNode;
    QName _topNamespaceNode;
    boolean _isTagStart;
    boolean _stopOnIncludeEnd;
    boolean _hasTopElement;
    boolean _hasDoctype;
    QDocumentType _dtd;

    public DtdParser(XmlParser xmlParser, QDocumentType dtd) {
        this._xmlParser = xmlParser;
        this._dtd = dtd;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int parseDoctypeDecl(QDocumentType doctype) throws IOException, SAXException {
        this._hasDoctype = true;
        int ch = 0;
        ch = this._xmlParser.skipWhitespace(this.read());
        while (ch >= 0 && ch != 93) {
            if (ch == 60) {
                ch = this.read();
                if (ch == 33) {
                    String name;
                    ch = this.read();
                    if (XmlChar.isNameStart(ch)) {
                        ch = this._xmlParser.parseName(this._text, ch);
                        name = this._text.toString();
                        if (name.equals("ELEMENT")) {
                            this.parseElementDecl(doctype);
                        } else if (name.equals("ATTLIST")) {
                            this.parseAttlistDecl(doctype);
                        } else if (name.equals("NOTATION")) {
                            this.parseNotationDecl(doctype);
                        } else {
                            if (!name.equals("ENTITY")) throw this.error("unknown declaration '" + name + "'");
                            this.parseEntityDecl(doctype);
                        }
                    } else if (ch == 45) {
                        this.parseComment();
                    } else if (ch == 91) {
                        ch = this._xmlParser.parseName(this._text, this.read());
                        name = this._text.toString();
                        if (name.equals("IGNORE")) {
                            this.parseIgnore();
                        } else {
                            if (!name.equals("INCLUDE")) throw this.error(L.l("unknown declaration '{0}'", name));
                            this.parseIgnore();
                        }
                    }
                } else {
                    if (ch != 63) throw this.error(L.l("expected markup at {0}", this.badChar(ch)));
                    this.parsePI();
                }
            } else {
                if (ch != 37) throw this.error(L.l("expected '<' at {0}", this.badChar(ch)));
                ch = this._xmlParser.parseName(this._buf, this.read());
                if (ch != 59) {
                    throw this.error(L.l("'%{0};' expects ';' at {1}.  Parameter entities have a '%name;' syntax.", (Object)this._buf, this.badChar(ch)));
                }
                this.addPEReference(this._text, this._buf.toString());
            }
            this._text.clear();
            ch = this._xmlParser.skipWhitespace(this.read());
        }
        this._text.clear();
        return this.read();
    }

    private int parseNameToken(CharBuffer name, int ch) throws IOException, SAXException {
        name.clear();
        if (!XmlChar.isNameChar(ch)) {
            throw this.error(L.l("expected name at {0}", this.badChar(ch)));
        }
        while (XmlChar.isNameChar(ch)) {
            name.append((char)ch);
            ch = this.read();
        }
        return ch;
    }

    private void appendText(String s) {
        if (this._text.length() == 0) {
            this._textFilename = this.getFilename();
            this._textLine = this.getLine();
        }
        this._text.append(s);
    }

    private int parseCharacterReference() throws IOException, SAXException {
        int ch = this.read();
        int radix = 10;
        if (ch == 120) {
            radix = 16;
            ch = this.read();
        }
        int value = 0;
        while (ch != 59) {
            if (ch >= 48 && ch <= 57) {
                value = radix * value + ch - 48;
            } else if (radix == 16 && ch >= 97 && ch <= 102) {
                value = radix * value + ch - 97 + 10;
            } else if (radix == 16 && ch >= 65 && ch <= 70) {
                value = radix * value + ch - 65 + 10;
            } else {
                throw this.error(L.l("malformed entity ref at {0}", this.badChar(ch)));
            }
            ch = this.read();
        }
        if (value > 65535) {
            throw this.error(L.l("malformed entity ref at {0}", "" + value));
        }
        if (!this.isChar(value)) {
            throw this.error(L.l("illegal character ref at {0}", this.badChar(value)));
        }
        return value;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int parseValue(CharBuffer value, int ch, boolean isGeneral) throws IOException, SAXException {
        int end = ch;
        value.clear();
        if (end == 39 || end == 34) {
            ch = this.read();
        } else {
            value.append((char)end);
            ch = this.read();
            while (ch >= 0) {
                if (!XmlChar.isNameChar(ch)) throw this.error(L.l("XML attribute value must be quoted at '{0}'.  XML attribute syntax is either attr=\"value\" or attr='value'.", value));
                value.append((char)ch);
                ch = this.read();
            }
            throw this.error(L.l("XML attribute value must be quoted at '{0}'.  XML attribute syntax is either attr=\"value\" or attr='value'.", value));
        }
        while (ch != -1 && (end != 0 && ch != end || end == 0 && this.isAttributeChar(ch))) {
            block24: {
                block25: {
                    block26: {
                        if (end == 0 && ch == 47) {
                            ch = this.read();
                            if (!this.isWhitespace(ch) && ch != 62) {
                                value.append('/');
                                value.append((char)ch);
                                break block24;
                            } else {
                                this.unread(ch);
                                return 47;
                            }
                        }
                        if (ch != 38) break block25;
                        ch = this.read();
                        if (ch != 35) break block26;
                        value.append((char)this.parseCharacterReference());
                        break block24;
                    }
                    if (!isGeneral) {
                        value.append('&');
                        value.append((char)ch);
                        break block24;
                    } else if (XmlChar.isNameStart(ch)) {
                        ch = this._xmlParser.parseName(this._buf, ch);
                        String name = this._buf.toString();
                        if (ch != 59) {
                            throw this.error(L.l("expected '{0}' at {1}", (Object)";", this.badChar(ch)));
                        }
                        int lookup = _entities.getEntity(name);
                        if (lookup >= 0 && lookup <= 65535) {
                            ch = this.read();
                            value.append((char)lookup);
                            continue;
                        }
                        QEntity entity = this._dtd == null ? null : this._dtd.getEntity(name);
                        if (entity == null) throw this.error(L.l("expected local reference at '&{0};'", name));
                        if (entity._value == null) throw this.error(L.l("expected local reference at '&{0};'", name));
                        this._xmlParser.setMacroAttr(entity._value);
                    }
                    break block24;
                }
                if (ch == 37 && !isGeneral) {
                    ch = this.read();
                    if (!XmlChar.isNameStart(ch)) {
                        value.append('%');
                        continue;
                    }
                    if ((ch = this._xmlParser.parseName(this._buf, ch)) != 59) {
                        throw this.error(L.l("expected '{0}' at {1}", (Object)";", this.badChar(ch)));
                    }
                    this.addPEReference(value, this._buf.toString());
                } else if (isGeneral) {
                    if (ch == 13 && (ch = this.read()) != 10) {
                        value.append('\n');
                        continue;
                    }
                    value.append((char)ch);
                } else if (ch == 13) {
                    value.append(' ');
                    ch = this.read();
                    if (ch != 10) {
                        continue;
                    }
                } else if (ch == 10) {
                    value.append(' ');
                } else {
                    value.append((char)ch);
                }
            }
            ch = this.read();
        }
        if (end == 0) return ch;
        return this.read();
    }

    private boolean isAttributeChar(int ch) {
        switch (ch) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return false;
            }
            case 34: 
            case 39: 
            case 60: 
            case 61: 
            case 62: {
                return false;
            }
        }
        return true;
    }

    private int parsePI() throws IOException, SAXException {
        int ch = this.read();
        if (!XmlChar.isNameStart(ch)) {
            throw this.error(L.l("expected name after '<?' at {0}.  Processing instructions expect a name like <?foo ... ?>", this.badChar(ch)));
        }
        ch = this._xmlParser.parseName(this._text, ch);
        String piName = this._text.toString();
        if (!piName.equals("xml")) {
            return this.parsePITail(piName, ch);
        }
        throw this.error(L.l("<?xml ... ?> occurs after content.  The <?xml ... ?> prolog must be at the document start."));
    }

    private int parsePITail(String piName, int ch) throws IOException, SAXException {
        ch = this._xmlParser.skipWhitespace(ch);
        this._text.clear();
        while (ch != -1) {
            if (ch == 63) {
                ch = this.read();
                if (ch == 62) break;
                this._text.append('?');
                continue;
            }
            this._text.append((char)ch);
            ch = this.read();
        }
        QProcessingInstruction pi = new QProcessingInstruction(piName, this._text.toString());
        pi._owner = this._dtd._owner;
        this._dtd.appendChild(pi);
        return this.read();
    }

    private void parseComment() throws IOException, SAXException {
        int ch = this.read();
        if (ch != 45) {
            throw this.error(L.l("expected comment at {0}", this.badChar(ch)));
        }
        ch = this.read();
        block0: while (ch != -1) {
            if (ch == 45) {
                ch = this.read();
                while (ch == 45) {
                    ch = this.read();
                    if (ch == 62) break block0;
                    if (this._strictComments) {
                        throw this.error(L.l("XML forbids '--' in comments"));
                    }
                    if (ch != 45) continue block0;
                }
                continue;
            }
            if (!XmlChar.isChar(ch)) {
                throw this.error(L.l("bad character {0}", DtdParser.hex(ch)));
            }
            ch = this.read();
        }
        QComment comment = new QComment(this._buf.toString());
        comment._owner = this._dtd._owner;
        this._dtd.appendChild(comment);
    }

    private void parseIgnore() throws IOException, SAXException {
        int ch = this.read();
        while (ch >= 0) {
            if (ch != 93) {
                ch = this.read();
                continue;
            }
            ch = this.read();
            if (ch != 93 || (ch = this.read()) != 62) continue;
            return;
        }
    }

    private int parseContentSpec(QElementDef def, int ch) throws IOException, SAXException {
        if (XmlChar.isNameStart(ch = this.expandPE(ch))) {
            ch = this._xmlParser.parseName(this._text, ch);
            String name = this._text.toString();
            if (name.equals("EMPTY")) {
                def._content = "EMPTY";
                return ch;
            }
            if (name.equals("ANY")) {
                def._content = "ANY";
                return ch;
            }
            throw this.error(L.l("expected EMPTY or ANY at '{0}'", name));
        }
        if (ch != 40) {
            throw this.error(L.l("expected grammar definition starting with '(' at {0}.  <!ELEMENT> definitions have the syntax <!ELEMENT name - - (grammar)>", this.badChar(ch)));
        }
        QContentParticle cp = new QContentParticle();
        def._content = cp;
        return this.parseContentParticle(cp, true);
    }

    private int parseContentParticle(QContentParticle cp, boolean isTop) throws IOException, SAXException {
        boolean hasCdata = false;
        cp._separator = 0;
        cp._repeat = 0;
        int ch = this.expandPE(this.read());
        while (ch != -1) {
            Object child;
            if (ch == 40) {
                child = new QContentParticle();
                cp.addChild(child);
                ch = this.parseContentParticle((QContentParticle)child, false);
            } else if (XmlChar.isNameStart(ch)) {
                ch = this._xmlParser.parseName(this._text, ch);
                cp.addChild(this._text.toString());
            } else if (ch == 35) {
                ch = this._xmlParser.parseName(this._text, this.read());
                String name = this._text.toString();
                if (cp._children.size() != 0) {
                    throw this.error(L.l("'#{0}' must occur first", name));
                }
                if (!isTop) {
                    throw this.error(L.l("'#{0}' may only occur at top level", name));
                }
                if (!name.equals("PCDATA")) {
                    throw this.error(L.l("illegal content particle at '#{0}'", name));
                }
                cp.addChild("#PCDATA");
                hasCdata = true;
            } else {
                throw this.error(L.l("expected content particle at {0}", this.badChar(ch)));
            }
            ch = this.expandPE(ch);
            if (ch == 63 || ch == 42 || ch == 43) {
                QContentParticle cpChild;
                child = cp.getChild(cp.getChildSize() - 1);
                if (child instanceof QContentParticle) {
                    cpChild = (QContentParticle)child;
                    cpChild._repeat = ch;
                } else {
                    cpChild = new QContentParticle();
                    cpChild.addChild(child);
                    cpChild._repeat = ch;
                    cp.setChild(cp.getChildSize() - 1, cpChild);
                }
                ch = this.expandPE(this.read());
            }
            if (ch == 41) break;
            if (cp._separator == 0) {
                if (ch == 124) {
                    cp._separator = ch;
                } else {
                    if (hasCdata) {
                        throw this.error(L.l("#PCDATA must be separated by '|' at {0}", this.badChar(ch)));
                    }
                    if (ch == 44) {
                        cp._separator = ch;
                    } else {
                        throw this.error(L.l("expected separator at {0}", this.badChar(ch)));
                    }
                }
                ch = this.read();
            } else {
                if (ch != cp._separator) {
                    throw this.error(L.l("expected '{0}' at {1}", (Object)("" + (char)cp._separator), this.badChar(ch)));
                }
                ch = this.read();
            }
            ch = this.expandPE(ch);
        }
        ch = this.expandPE(this.read());
        if (hasCdata && (ch == 43 || ch == 63)) {
            throw this.error(L.l("pcdata clause can not have {0}", this.badChar(ch)));
        }
        if (ch == 42 || ch == 43 || ch == 63) {
            cp._repeat = ch;
            return this.read();
        }
        return ch;
    }

    private int expandPE(int ch) throws IOException, SAXException {
        ch = this._xmlParser.skipWhitespace(ch);
        while (ch == 37) {
            this.parsePEReference();
            ch = this._xmlParser.skipWhitespace(this.read());
        }
        return ch;
    }

    private void parsePEReference() throws IOException, SAXException {
        int ch = this._xmlParser.parseName(this._buf, this.read());
        if (ch != 59) {
            throw this.error(L.l("'%{0};' expects ';' at {1}.  Parameter entities have a '%name;' syntax.", (Object)this._buf, this.badChar(ch)));
        }
        this.addPEReference(this._text, this._buf.toString());
    }

    private void addPEReference(CharBuffer value, String name) throws IOException, SAXException {
        QEntity entity = this._dtd.getParameterEntity(name);
        if (entity == null && !this._dtd.isExternal()) {
            throw this.error(L.l("'%{0};' is an unknown parameter entity.  Parameter entities must be defined in an <!ENTITY> declaration before use.", name));
        }
        if (entity != null && entity._value != null) {
            this._xmlParser.setMacro(entity._value);
        } else if (entity != null && entity.getSystemId() != null) {
            this._xmlParser.pushInclude(entity.getPublicId(), entity.getSystemId());
        } else {
            value.append("%");
            value.append(name);
            value.append(";");
        }
    }

    private void parseElementDecl(QDocumentType doctype) throws IOException, SAXException {
        int ch = this._xmlParser.skipWhitespace(this.read());
        ch = this._xmlParser.parseName(this._text, ch);
        String name = this._text.toString();
        ch = this._xmlParser.skipWhitespace(ch);
        QElementDef def = this._dtd.addElement(name);
        def.setLocation(this.getSystemId(), this.getFilename(), this.getLine(), this.getColumn());
        boolean needsStartTag = true;
        boolean needsEndTag = true;
        ch = this.parseContentSpec(def, ch);
        ch = this._xmlParser.skipWhitespace(ch);
        if (ch != 62) {
            throw this.error(L.l("'<!ELEMENT' must close with '>' at {0}", this.badChar(ch)));
        }
    }

    private static String toAttrDefault(CharBuffer text) {
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '\"') {
                text.delete(i, i + 1);
                text.insert(i, "&#34;");
                --i;
                continue;
            }
            if (ch != '\'') continue;
            text.delete(i, i + 1);
            text.insert(i, "&#39;");
            --i;
        }
        return text.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseAttlistDecl(QDocumentType doctype) throws IOException, SAXException {
        int ch = this._xmlParser.skipWhitespace(this.read());
        ch = this._xmlParser.parseName(this._text, ch);
        String name = this._text.toString();
        ch = this._xmlParser.skipWhitespace(ch);
        QElementDef def = this._dtd.addElement(name);
        while (XmlChar.isNameStart(ch = this.expandPE(ch))) {
            ch = this._xmlParser.parseName(this._text, ch);
            String attrName = this._text.toString();
            String attrType = null;
            ArrayList<String> enumeration = null;
            if ((ch = this.expandPE(ch)) == 40) {
                attrType = "#ENUM";
                enumeration = new ArrayList<String>();
                do {
                    ch = this.expandPE(this.read());
                    ch = this.parseNameToken(this._text, ch);
                    enumeration.add(this._text.toString());
                } while ((ch = this.expandPE(ch)) == 124);
                if (ch != 41) {
                    throw this.error(L.l("expected '{0}' at {1}.  <!ATTRLIST> enumerations definitions are enclosed in '(' ... ')'.", (Object)")", this.badChar(ch)));
                }
                ch = this.read();
            } else {
                ch = this._xmlParser.parseName(this._text, ch);
                attrType = this._text.toString();
                if (attrType.equals("NOTATION")) {
                    enumeration = new ArrayList();
                    if ((ch = this.expandPE(ch)) != 40) {
                        throw this.error(L.l("expected '{0}' at {1}", (Object)"(", this.badChar(ch)));
                    }
                    do {
                        ch = this.expandPE(this.read());
                        ch = this._xmlParser.parseName(this._text, ch);
                        enumeration.add(this._text.toString());
                    } while ((ch = this.expandPE(ch)) == 124);
                    if (ch != 41) {
                        throw this.error(L.l("expected '{0}' at {1}", (Object)")", this.badChar(ch)));
                    }
                    ch = this.read();
                } else if (_attrTypes.get(attrType) == null) {
                    throw this.error(L.l("expected attribute type at '{0}'", attrType));
                }
            }
            ch = this._xmlParser.skipWhitespace(ch);
            String qualifier = null;
            String attrDefault = null;
            if (ch == 35) {
                ch = this._xmlParser.parseName(this._text, this.read());
                qualifier = "#" + this._text.toString();
                if (!qualifier.equals("#IMPLIED") && !qualifier.equals("#REQUIRED")) {
                    if (!qualifier.equals("#FIXED")) throw this.error(L.l("expected attribute default at '{0}'", qualifier));
                    ch = this._xmlParser.skipWhitespace(ch);
                    ch = this.parseValue(this._text, ch, false);
                    attrDefault = this._text.toString();
                }
            } else if (ch != 62) {
                ch = this.parseValue(this._text, ch, false);
                attrDefault = this._text.toString();
            }
            def.addAttribute(attrName, attrType, enumeration, qualifier, attrDefault);
            if (attrType != null && attrType.equals("ID")) {
                doctype.setElementId(name, attrName);
            }
            ch = this._xmlParser.skipWhitespace(ch);
        }
        if (ch == 62) return;
        throw this.error(L.l("expected '{0}' at {1}", (Object)">", this.badChar(ch)));
    }

    private void parseNotationDecl(QDocumentType doctype) throws IOException, SAXException {
        QNotation notation;
        int ch = this._xmlParser.skipWhitespace(this.read());
        ch = this._xmlParser.parseName(this._text, ch);
        String name = this._text.toString();
        ch = this._xmlParser.skipWhitespace(ch);
        ch = this._xmlParser.parseName(this._text, ch);
        String key = this._text.toString();
        ch = this._xmlParser.skipWhitespace(ch);
        ch = this.parseValue(this._text, ch, false);
        String id = this._text.toString();
        ch = this._xmlParser.skipWhitespace(ch);
        if (key.equals("PUBLIC")) {
            String systemId = null;
            if (ch == 34 || ch == 39) {
                ch = this.parseValue(this._text, ch, false);
                ch = this._xmlParser.skipWhitespace(ch);
                systemId = this._text.toString();
            }
            notation = new QNotation(name, id, systemId);
            notation._owner = doctype._owner;
            notation.setLocation(this.getSystemId(), this.getFilename(), this.getLine(), this.getColumn());
        } else if (key.equals("SYSTEM")) {
            notation = new QNotation(name, null, id);
            notation._owner = doctype._owner;
            notation.setLocation(this.getSystemId(), this.getFilename(), this.getLine(), this.getColumn());
        } else {
            throw this.error(L.l("expected PUBLIC or SYSTEM at '{0}'", key));
        }
        doctype.addNotation(notation);
        doctype.appendChild(notation);
        if (ch != 62) {
            throw this.error(L.l("expected '{0}' at {1}", (Object)">", this.badChar(ch)));
        }
    }

    private int parseExternalID(int ch) throws IOException, SAXException {
        ch = this._xmlParser.parseName(this._text, ch);
        String key = this._text.toString();
        ch = this._xmlParser.skipWhitespace(ch);
        this._extSystemId = null;
        this._extPublicId = null;
        if (key.equals("PUBLIC")) {
            ch = this.parseValue(this._text, ch, false);
            this._extPublicId = this._text.toString();
            ch = this._xmlParser.skipWhitespace(ch);
            if (this._extPublicId.indexOf(38) > 0) {
                throw this.error(L.l("Illegal character '&' in PUBLIC identifier '{0}'", this._extPublicId));
            }
            ch = this.parseValue(this._text, ch, false);
            ch = this._xmlParser.skipWhitespace(ch);
            this._extSystemId = this._text.toString();
        } else if (key.equals("SYSTEM")) {
            ch = this.parseValue(this._text, ch, false);
            this._extSystemId = this._text.toString();
        } else {
            throw this.error(L.l("expected PUBLIC or SYSTEM at '{0}'", key));
        }
        return ch;
    }

    private void parseEntityDecl(QDocumentType doctype) throws IOException, SAXException {
        QEntity entity;
        boolean isPe;
        int ch = this._xmlParser.skipWhitespace(this.read());
        boolean bl = isPe = ch == 37;
        if (isPe) {
            ch = this._xmlParser.skipWhitespace(this.read());
        }
        ch = this._xmlParser.parseName(this._text, ch);
        String name = this._text.toString();
        if ((ch = this._xmlParser.skipWhitespace(ch)) == 34 || ch == 39) {
            ch = this.parseValue(this._text, ch, false);
            entity = new QEntity(name, this._text.toString(), null, null);
            entity._owner = doctype._owner;
            entity.setLocation(this.getSystemId(), this.getFilename(), this.getLine(), this.getColumn());
        } else {
            ch = this.parseExternalID(ch);
            entity = new QEntity(name, null, this._extPublicId, this._extSystemId);
            entity._owner = doctype._owner;
            entity.setLocation(this.getSystemId(), this.getFilename(), this.getLine(), this.getColumn());
            ch = this._xmlParser.skipWhitespace(ch);
            if (!isPe && XmlChar.isNameStart(ch)) {
                ch = this._xmlParser.parseName(this._text, ch);
                String key = this._text.toString();
                if (key.equals("NDATA")) {
                    String ndata;
                    ch = this._xmlParser.skipWhitespace(ch);
                    ch = this._xmlParser.parseName(this._text, ch);
                    entity._ndata = ndata = this._text.toString();
                } else {
                    throw this.error(L.l("expected 'NDATA' at '{0}'", key));
                }
            }
        }
        entity._isPe = isPe;
        if (isPe) {
            doctype.addParameterEntity(entity);
        } else {
            doctype.addEntity(entity);
        }
        doctype.appendChild(entity);
        ch = this._xmlParser.skipWhitespace(ch);
        if (ch != 62) {
            throw this.error(L.l("expected '>' at {0}", this.badChar(ch)));
        }
    }

    private boolean isWhitespace(int ch) {
        return ch <= 32 && (ch == 32 || ch == 9 || ch == 10 || ch == 13);
    }

    private boolean isChar(int ch) {
        return ch >= 32 && ch <= 55295 || ch == 9 || ch == 10 || ch == 13 || ch >= 57344 && ch <= 65533;
    }

    private static String hex(int value) {
        CharBuffer cb = CharBuffer.allocate();
        for (int b = 3; b >= 0; --b) {
            int v = value >> 4 * b & 0xF;
            if (v < 10) {
                cb.append((char)(v + 48));
                continue;
            }
            cb.append((char)(v - 10 + 97));
        }
        return cb.close();
    }

    private int read() throws IOException, SAXException {
        return this._xmlParser.read();
    }

    public void unread(int ch) {
        this._xmlParser.unread(ch);
    }

    private String getSystemId() {
        return this._xmlParser.getSystemId();
    }

    private String getFilename() {
        return this._xmlParser.getFilename();
    }

    private XmlParseException error(String msg) {
        return this._xmlParser.error(msg);
    }

    private int getLine() {
        return this._xmlParser.getLine();
    }

    private int getColumn() {
        return this._xmlParser.getColumn();
    }

    private String badChar(int ch) {
        return XmlParser.badChar(ch);
    }

    static {
        _attrTypes.put("CDATA", "CDATA");
        _attrTypes.put("ID", "ID");
        _attrTypes.put("IDREF", "IDREF");
        _attrTypes.put("IDREFS", "IDREFS");
        _attrTypes.put("ENTITY", "ENTITY");
        _attrTypes.put("ENTITIES", "ENTITIES");
        _attrTypes.put("NMTOKEN", "NMTOKEN");
        _attrTypes.put("NMTOKENS", "NMTOKENS");
    }
}

