/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xmpp;

import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.xmpp.XmppMarshal;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.xml.namespace.QName;

public class XmppMarshalFactory {
    private static final Logger log = Logger.getLogger(XmppMarshalFactory.class.getName());
    private ClassLoader _loader;
    private HashMap<QName, XmppMarshal> _unserializeMap = new HashMap();
    private HashMap<String, XmppMarshal> _serializeMap = new HashMap();
    private Connection _jmsConn;

    public XmppMarshalFactory() {
        this._loader = Thread.currentThread().getContextClassLoader();
        this.init();
    }

    ClassLoader getClassLoader() {
        return this._loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init() {
        String resource = "META-INF/caucho/com.caucho.xmpp.XmppMarshal";
        try {
            Enumeration<URL> iter = this._loader.getResources(resource);
            while (iter.hasMoreElements()) {
                Object var7_7;
                URL url = iter.nextElement();
                ReadStream is = null;
                try {
                    try {
                        is = Vfs.lookup(url.toString()).openRead();
                        this.loadMarshal(is);
                    }
                    catch (IOException e) {
                        log.log(Level.WARNING, e.toString(), e);
                        var7_7 = null;
                        is.close();
                        continue;
                    }
                    var7_7 = null;
                    is.close();
                }
                catch (Throwable throwable) {
                    var7_7 = null;
                    is.close();
                    throw throwable;
                    return;
                }
            }
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    private void loadMarshal(ReadStream is) throws IOException {
        String line;
        while ((line = is.readLine()) != null) {
            int p = line.indexOf(35);
            if (p > 0) {
                line = line.substring(0, p);
            }
            if ((line = line.trim()).length() == 0) continue;
            try {
                String className;
                String marshalClassName = line;
                Class<?> cl = Class.forName(marshalClassName, false, this._loader);
                XmppMarshal marshal = (XmppMarshal)cl.newInstance();
                QName qName = null;
                if (marshal.getNamespaceURI() != null && marshal.getLocalName() != null) {
                    qName = new QName(marshal.getNamespaceURI(), marshal.getLocalName(), "");
                    this._unserializeMap.put(qName, marshal);
                }
                if ((className = marshal.getClassName()) != null) {
                    this._serializeMap.put(className, marshal);
                }
                if (!log.isLoggable(Level.FINEST)) continue;
                log.finest(this + " marshal: " + marshal + " " + qName + " " + className);
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    XmppMarshal getUnserialize(QName name) {
        return this._unserializeMap.get(name);
    }

    XmppMarshal getSerialize(String name) {
        return this._serializeMap.get(name);
    }
}

