/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xmpp;

import com.caucho.bam.ActorError;
import com.caucho.bam.ActorStream;
import com.caucho.vfs.ReadStream;
import com.caucho.xmpp.XmppContext;
import com.caucho.xmpp.XmppMarshal;
import com.caucho.xmpp.XmppMarshalFactory;
import com.caucho.xmpp.XmppStreamReader;
import com.caucho.xmpp.im.ImMessage;
import com.caucho.xmpp.im.ImPresence;
import com.caucho.xmpp.im.ImSessionQuery;
import com.caucho.xmpp.im.Text;
import com.caucho.xmpp.im.XmlData;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XmppReader {
    private static final Logger log = Logger.getLogger(XmppReader.class.getName());
    private ActorStream _toReply;
    private ActorStream _handler;
    private ReadStream _is;
    private XmppStreamReader _in;
    private XmppContext _xmppContext;
    private XmppMarshalFactory _marshalFactory;
    private String _uid;
    private String _jid;
    private boolean _isFinest;

    XmppReader(XmppContext context, ReadStream is, XmppStreamReader in, ActorStream toReply, ActorStream handler) {
        this._xmppContext = context;
        this._marshalFactory = context.getMarshalFactory();
        this._is = is;
        this._in = in;
        this._toReply = toReply;
        this._handler = handler;
        this._isFinest = log.isLoggable(Level.FINEST);
    }

    void setHandler(ActorStream handler) {
        this._handler = handler;
    }

    void setUid(String uid) {
        this._uid = uid;
    }

    void setJid(String jid) {
        this._jid = jid;
    }

    boolean readNext() throws IOException {
        XmppStreamReader in = this._in;
        if (in == null) {
            return false;
        }
        try {
            int tag;
            while ((tag = this._in.next()) > 0) {
                if (this._isFinest) {
                    this.debug(this._in);
                }
                if (tag == 2) {
                    if ("stream".equals(this._in.getLocalName())) {
                        if (log.isLoggable(Level.FINE)) {
                            log.fine(this + " end-stream");
                        }
                    } else {
                        log.warning(this + " " + this._in.getLocalName());
                    }
                    return false;
                }
                if (tag != 1) continue;
                boolean valid = false;
                if ("iq".equals(this._in.getLocalName())) {
                    valid = this.handleIq();
                } else if ("presence".equals(this._in.getLocalName())) {
                    valid = this.handlePresence();
                } else if ("message".equals(this._in.getLocalName())) {
                    valid = this.handleMessage();
                } else {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(this + " " + this._in.getLocalName() + " is an unknown tag");
                    }
                    return false;
                }
                if (!valid) {
                    return false;
                }
                if (this._in.available() >= 1) continue;
                return true;
            }
            if (this._isFinest) {
                log.finest(this + " end of stream");
            }
            return false;
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            return false;
        }
    }

    boolean handleMessage() throws IOException, XMLStreamException {
        int tag;
        String type = this._in.getAttributeValue(null, "type");
        String id = this._in.getAttributeValue(null, "id");
        String from = this._in.getAttributeValue(null, "from");
        String to = this._in.getAttributeValue(null, "to");
        if (type == null) {
            type = "normal";
        }
        ArrayList<Text> subjectList = null;
        ArrayList<Text> bodyList = null;
        ArrayList<Object> extraList = null;
        String thread = null;
        while (!((tag = this._in.next()) <= 0 || tag == 2 && "message".equals(this._in.getLocalName()))) {
            XmppMarshal marshal;
            String lang;
            if (this._isFinest) {
                this.debug(this._in);
            }
            if (tag != 1) continue;
            if ("body".equals(this._in.getLocalName()) && "jabber:client".equals(this._in.getNamespaceURI())) {
                lang = null;
                if (this._in.getAttributeCount() > 0 && "lang".equals(this._in.getAttributeLocalName(0))) {
                    lang = this._in.getAttributeValue(0);
                }
                tag = this._in.next();
                if (this._isFinest) {
                    this.debug(this._in);
                }
                String body = this._in.getText();
                if (bodyList == null) {
                    bodyList = new ArrayList<Text>();
                }
                bodyList.add(new Text(body, lang));
                this.expectEnd("body");
                continue;
            }
            if ("subject".equals(this._in.getLocalName()) && "jabber:client".equals(this._in.getNamespaceURI())) {
                lang = null;
                if (this._in.getAttributeCount() > 0 && "lang".equals(this._in.getAttributeLocalName(0))) {
                    lang = this._in.getAttributeValue(0);
                }
                tag = this._in.next();
                if (this._isFinest) {
                    this.debug(this._in);
                }
                String text = this._in.getText();
                if (subjectList == null) {
                    subjectList = new ArrayList<Text>();
                }
                subjectList.add(new Text(text, lang));
                this.expectEnd("subject");
                continue;
            }
            if ("thread".equals(this._in.getLocalName()) && "jabber:client".equals(this._in.getNamespaceURI())) {
                tag = this._in.next();
                if (this._isFinest) {
                    this.debug(this._in);
                }
                thread = this._in.getText();
                this.expectEnd("thread");
                continue;
            }
            String name = this._in.getLocalName();
            QName qName = this._in.getName();
            String uri = this._in.getNamespaceURI();
            if (extraList == null) {
                extraList = new ArrayList<Object>();
            }
            Object extra = (marshal = this._marshalFactory.getUnserialize(qName)) != null ? marshal.fromXml(this._in) : this.readAsXmlString(this._in);
            extraList.add(extra);
        }
        this.expectEnd("message", tag);
        Text[] subjectArray = null;
        if (subjectList != null) {
            subjectArray = new Text[subjectList.size()];
            subjectList.toArray(subjectArray);
        }
        Text[] bodyArray = null;
        if (bodyList != null) {
            bodyArray = new Text[bodyList.size()];
            bodyList.toArray(bodyArray);
        }
        Serializable[] extraArray = null;
        if (extraList != null) {
            extraArray = new Serializable[extraList.size()];
            extraList.toArray(extraArray);
        }
        if (this._jid != null) {
            from = this._jid;
        }
        if (to == null) {
            to = this._uid;
        }
        ImMessage message = new ImMessage(to, from, type, subjectArray, bodyArray, thread, extraArray);
        if (this._handler != null) {
            this._handler.message(to, from, message);
        }
        return true;
    }

    boolean handleIq() throws IOException, XMLStreamException {
        String type = this._in.getAttributeValue(null, "type");
        String id = this._in.getAttributeValue(null, "id");
        String from = this._in.getAttributeValue(null, "from");
        String to = this._in.getAttributeValue(null, "to");
        int tag = this._in.nextTag();
        if (this._isFinest) {
            this.debug(this._in);
        }
        String localName = this._in.getLocalName();
        String uri = this._in.getNamespaceURI();
        QName name = this._in.getName();
        Object query = null;
        XmppMarshal marshal = this._marshalFactory.getUnserialize(name);
        query = marshal != null ? marshal.fromXml(this._in) : this.readAsXmlString(this._in);
        ActorError error = null;
        this.skipToEnd("iq");
        if (this._jid != null) {
            from = this._jid;
        }
        if (to == null) {
            to = this._uid;
            if (query instanceof ImSessionQuery && "set".equals(type)) {
                long bamId = this._xmppContext.addId(id);
                this._toReply.queryResult(bamId, from, to, (Serializable)query);
                return true;
            }
        }
        if ("get".equals(type)) {
            long bamId = this._xmppContext.addId(id);
            if (this._handler != null) {
                this._handler.queryGet(bamId, to, from, (Serializable)query);
            }
        } else if ("set".equals(type)) {
            long bamId = this._xmppContext.addId(id);
            if (this._handler != null) {
                this._handler.querySet(bamId, to, from, (Serializable)query);
            }
        } else if ("result".equals(type)) {
            long bamId = Long.parseLong(id);
            if (this._handler != null) {
                this._handler.queryResult(bamId, to, from, (Serializable)query);
            }
        } else if ("error".equals(type)) {
            long bamId = Long.parseLong(id);
            if (this._handler != null) {
                this._handler.queryError(bamId, to, from, (Serializable)query, error);
            }
        } else if (log.isLoggable(Level.FINE)) {
            log.fine(this + " <" + this._in.getLocalName() + " xmlns=" + this._in.getNamespaceURI() + "> unknown type");
        }
        return true;
    }

    boolean handlePresence() throws IOException, XMLStreamException {
        int tag;
        String to;
        String type = this._in.getAttributeValue(null, "type");
        String id = this._in.getAttributeValue(null, "id");
        String from = this._in.getAttributeValue(null, "from");
        String target = to = this._in.getAttributeValue(null, "to");
        if (type == null) {
            type = "";
        }
        String show = null;
        Text status = null;
        int priority = 0;
        ArrayList<Serializable> extraList = new ArrayList<Serializable>();
        Object error = null;
        while (!((tag = this._in.nextTag()) <= 0 || "presence".equals(this._in.getLocalName()) && tag == 2)) {
            if (this._isFinest) {
                this.debug(this._in);
            }
            if (tag != 1) continue;
            if ("status".equals(this._in.getLocalName())) {
                tag = this._in.next();
                if (this._isFinest) {
                    this.debug(this._in);
                }
                status = new Text(this._in.getText());
                this.skipToEnd("status");
                continue;
            }
            if ("show".equals(this._in.getLocalName())) {
                tag = this._in.next();
                if (this._isFinest) {
                    this.debug(this._in);
                }
                show = this._in.getText();
                this.skipToEnd("show");
                continue;
            }
            if ("priority".equals(this._in.getLocalName())) {
                tag = this._in.next();
                if (this._isFinest) {
                    this.debug(this._in);
                }
                priority = Integer.parseInt(this._in.getText());
                this.skipToEnd("priority");
                continue;
            }
            String name = this._in.getLocalName();
            String uri = this._in.getNamespaceURI();
            String data = this._in.readAsXmlString();
            extraList.add(new XmlData(name, uri, data));
        }
        if (this._isFinest) {
            this.debug(this._in);
        }
        this.expectEnd("presence", tag);
        if (this._jid != null) {
            from = this._jid;
        }
        if (target == null) {
            target = this._uid;
        }
        ImPresence presence = new ImPresence(to, from, show, status, priority, extraList);
        if (this._handler != null) {
            // empty if block
        }
        return true;
    }

    protected void skipToEnd(String tagName) throws IOException, XMLStreamException {
        int tag;
        XmppStreamReader in = this._in;
        if (in == null) {
            return;
        }
        while ((tag = in.next()) > 0) {
            if (this._isFinest) {
                this.debug(in);
            }
            if (tag == 1 || tag != 2 || !tagName.equals(in.getLocalName())) continue;
            return;
        }
    }

    private void expectEnd(String tagName) throws IOException, XMLStreamException {
        this.expectEnd(tagName, this._in.nextTag());
    }

    private void expectEnd(String tagName, int tag) throws IOException, XMLStreamException {
        if (tag != 2) {
            throw new IllegalStateException("expected </" + tagName + "> at <" + this._in.getLocalName() + ">");
        }
        if (!tagName.equals(this._in.getLocalName())) {
            throw new IllegalStateException("expected </" + tagName + "> at </" + this._in.getLocalName() + ">");
        }
    }

    private String readAsXmlString(XMLStreamReader in) throws IOException, XMLStreamException {
        StringBuilder sb = new StringBuilder();
        int depth = 0;
        do {
            String prefix;
            if (1 == in.getEventType()) {
                ++depth;
                prefix = in.getPrefix();
                sb.append("<");
                if (!"".equals(prefix)) {
                    sb.append(prefix);
                    sb.append(":");
                }
                sb.append(in.getLocalName());
                if (in.getNamespaceURI() != null) {
                    if ("".equals(prefix)) {
                        sb.append(" xmlns");
                    } else {
                        sb.append(" xmlns:").append(prefix);
                    }
                    sb.append("=\"");
                    sb.append(in.getNamespaceURI()).append("\"");
                }
                for (int i = 0; i < in.getAttributeCount(); ++i) {
                    sb.append(" ");
                    sb.append(in.getAttributeLocalName(i));
                    sb.append("=\"");
                    sb.append(in.getAttributeValue(i));
                    sb.append("\"");
                }
                sb.append(">");
                log.finest(this + " " + sb);
                continue;
            }
            if (2 == in.getEventType()) {
                --depth;
                sb.append("</");
                prefix = in.getPrefix();
                if (!"".equals(prefix)) {
                    sb.append(prefix).append(":");
                }
                sb.append(in.getLocalName());
                sb.append(">");
                if (depth != 0) continue;
                return sb.toString();
            }
            if (4 == in.getEventType()) {
                sb.append(in.getText());
                continue;
            }
            log.finer(this + " tag=" + in.getEventType());
            return sb.toString();
        } while (in.next() >= 0);
        log.finer(this + " unexpected end of file");
        return sb.toString();
    }

    private void debug(XMLStreamReader in) throws IOException, XMLStreamException {
        if (1 == in.getEventType()) {
            StringBuilder sb = new StringBuilder();
            sb.append("<").append(in.getLocalName());
            if (in.getNamespaceURI() != null) {
                sb.append("{").append(in.getNamespaceURI()).append("}");
            }
            for (int i = 0; i < in.getAttributeCount(); ++i) {
                sb.append(" ");
                sb.append(in.getAttributeLocalName(i));
                sb.append("='");
                sb.append(in.getAttributeValue(i));
                sb.append("'");
            }
            sb.append(">");
            log.finest(this + " " + sb);
        } else if (2 == in.getEventType()) {
            log.finest(this + " </" + in.getLocalName() + ">");
        } else if (4 == in.getEventType()) {
            String text = in.getText().trim();
            if (!"".equals(text)) {
                log.finest(this + " text='" + text + "'");
            }
        } else {
            log.finest(this + " tag=" + in.getEventType());
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

