/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xmpp;

import com.caucho.bam.Broker;
import com.caucho.env.thread.ThreadPool;
import com.caucho.hemp.broker.HempBrokerManager;
import com.caucho.network.listen.AbstractProtocolConnection;
import com.caucho.network.listen.SocketLinkDuplexController;
import com.caucho.network.listen.TcpSocketLink;
import com.caucho.util.Base64;
import com.caucho.util.L10N;
import com.caucho.util.RandomUtil;
import com.caucho.vfs.IOExceptionWrapper;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import com.caucho.xmpp.Stanza;
import com.caucho.xmpp.XmppBrokerStream;
import com.caucho.xmpp.XmppProtocol;
import com.caucho.xmpp.XmppStreamReader;
import com.caucho.xmpp.XmppStreamReaderImpl;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XmppRequest
extends AbstractProtocolConnection {
    private static final L10N L = new L10N(XmppRequest.class);
    private static final Logger log = Logger.getLogger(XmppRequest.class.getName());
    private static final String STREAMS_NS = "http://etherx.jabber.org/streams";
    private static final String STARTTLS_NS = "urn:ietf:params:xml:ns:xmpp-tls";
    private static final String AUTH_NS = "urn:ietf:params:xml:ns:xmpp-sasl";
    private XmppProtocol _protocol;
    private HempBrokerManager _brokerManager;
    private Broker _broker;
    private TcpSocketLink _conn;
    private ReadStream _is;
    private WriteStream _os;
    private volatile int _requestId;
    private String _id;
    private String _host;
    private String _clientTo;
    private String _uid;
    private String _streamFrom;
    private String _clientBind;
    private String _name;
    private XmppStreamReader _in;
    private boolean _isAllowTls = false;
    private boolean _isRequireSession = true;
    private boolean _isPresent;
    private boolean _isThread;
    private final ThreadPool _threadPool;
    private final BlockingQueue<Stanza> _outboundQueue = new ArrayBlockingQueue<Stanza>(1024);
    private State _state;
    private boolean _isFinest;

    XmppRequest(XmppProtocol protocol, TcpSocketLink conn) {
        this._protocol = protocol;
        this._brokerManager = protocol.getBrokerManager();
        this._conn = conn;
        this._threadPool = ThreadPool.getThreadPool();
    }

    int getRequestId() {
        return this._requestId;
    }

    String getUid() {
        return this._uid;
    }

    public TcpSocketLink getConnection() {
        return this._conn;
    }

    XmppProtocol getProtocol() {
        return this._protocol;
    }

    public void init() {
    }

    public boolean isWaitForRead() {
        return true;
    }

    public void startConnection() {
        this._host = null;
        this._broker = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleRequest() throws IOException {
        boolean bl;
        ClassLoader oldLoader;
        Thread thread;
        block9: {
            thread = Thread.currentThread();
            oldLoader = thread.getContextClassLoader();
            try {
                boolean bl2;
                block8: {
                    try {
                        thread.setContextClassLoader(this._protocol.getClassLoader());
                        this._isFinest = log.isLoggable(Level.FINEST);
                        if (this._state == null) {
                            bl2 = this.handleInit();
                            Object var7_8 = null;
                            break block8;
                        }
                        XmppBrokerStream handler = new XmppBrokerStream(this, this._broker, this._is, this._in, this._os);
                        SocketLinkDuplexController controller = this._conn.startDuplex(handler);
                        bl = true;
                        break block9;
                    }
                    catch (XMLStreamException e) {
                        e.printStackTrace();
                        throw new IOExceptionWrapper(e);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        throw e;
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                        throw e;
                    }
                }
                thread.setContextClassLoader(oldLoader);
                return bl2;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                thread.setContextClassLoader(oldLoader);
                throw throwable;
            }
        }
        Object var7_9 = null;
        thread.setContextClassLoader(oldLoader);
        return bl;
    }

    private boolean handleInit() throws IOException, XMLStreamException {
        this._state = State.INIT;
        StringBuilder sb = new StringBuilder();
        Base64.encode(sb, RandomUtil.getRandomLong());
        while (sb.charAt(sb.length() - 1) == '=') {
            sb.setLength(sb.length() - 1);
        }
        this._id = sb.toString();
        this._is = this._conn.getReadStream();
        this._os = this._conn.getWriteStream();
        this._in = new XmppStreamReaderImpl(this._is, this._protocol.getMarshalFactory());
        if (!this.readStreamHeader()) {
            return false;
        }
        this.writeStreamHeader(this._host);
        this.readStreamInit();
        return true;
    }

    private boolean readStreamHeader() throws IOException, XMLStreamException {
        String name;
        int tag;
        while ((tag = this._in.next()) > 0 && tag != 1) {
            if (!this._isFinest) continue;
            this.debug(this._in);
        }
        if (this._isFinest) {
            this.debug(this._in);
        }
        if (!"stream".equals(name = this._in.getLocalName())) {
            this._os.print("<error><invalid-xml/></error>");
            if (log.isLoggable(Level.FINE)) {
                log.fine(L.l("{0}: '{1}' is an unknown tag from {2}", this, name, this._conn.getRemoteAddress()));
            }
            return false;
        }
        if (!STREAMS_NS.equals(this._in.getNamespaceURI())) {
            this._os.print("<error><bad-namespace-prefix/></error>");
            if (log.isLoggable(Level.FINE)) {
                log.fine(L.l("{0}: xmlns='{1}' is an unknown namespace from {2}", this, name, this._conn.getRemoteAddress()));
            }
            return false;
        }
        if (!"1.0".equals(this._in.getAttributeValue(null, "version"))) {
            this._os.print("<error><unsupported-version/></error>");
            if (log.isLoggable(Level.FINE)) {
                log.fine(L.l("{0}: version='{1}' is an unknown version from {2}", this, this._in.getAttributeValue(null, "version"), this._conn.getRemoteAddress()));
            }
            return false;
        }
        this._host = this._in.getAttributeValue(null, "to");
        String from = this._host;
        if (from == null) {
            from = this._conn.getLocalAddress().getHostAddress();
        }
        this._broker = this._brokerManager.findBroker(this._host);
        if (this._broker == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(L.l("{0}: host='{1}' is an unknown host", (Object)this, this._host));
            }
            this._os.print("<error><unknown-host/></error>");
            return false;
        }
        this._streamFrom = from;
        this._clientTo = from + "/" + this._id;
        return true;
    }

    private boolean skipToStartElement() throws IOException, XMLStreamException {
        int tag;
        while ((tag = this._in.next()) > 0 && tag != 1) {
            if (!this._isFinest) continue;
            this.debug(this._in);
        }
        if (tag >= 0 && this._isFinest) {
            this.debug(this._in);
        }
        return tag >= 0;
    }

    private boolean readStreamInit() throws IOException, XMLStreamException {
        if (!this.skipToStartElement()) {
            return false;
        }
        if ("starttls".equals(this._in.getLocalName()) && STARTTLS_NS.equals(this._in.getNamespaceURI()) && !this.startTls()) {
            return false;
        }
        if ("auth".equals(this._in.getLocalName()) && AUTH_NS.equals(this._in.getNamespaceURI())) {
            if (!this.handleAuth()) {
                return false;
            }
            if (!this.skipToStartElement()) {
                return false;
            }
        }
        return !"stream".equals(this._in.getLocalName()) || !STREAMS_NS.equals(this._in.getNamespaceURI()) || this.handleStream();
    }

    private boolean startTls() throws IOException, XMLStreamException {
        this.skipToEnd("starttls");
        this._os.print("<proceed xmlns='urn:ietf:params:xml:ns:xmpp-tls'/>");
        this._os.flush();
        System.out.println("STARTTLS");
        return true;
    }

    private void writeStreamHeader(String host) throws IOException {
        this._os.print("<stream:stream xmlns='jabber:client'");
        this._os.print(" xmlns:stream='http://etherx.jabber.org/streams'");
        this._os.print(" id='" + this._id + "'");
        this._os.print(" from='" + host + "'");
        this._os.print(" version='1.0'>");
        this._os.print("<stream:features>");
        this._os.print("<mechanisms xmlns='urn:ietf:params:xml:ns:xmpp-sasl'>");
        this._os.print("<mechanism>PLAIN</mechanism>");
        this._os.print("</mechanisms>");
        if (this._isAllowTls) {
            this._os.print("<starttls xmlns='urn:ietf:params:xml:ns:xmpp-tls'></starttls>");
        }
        this._os.print("<auth xmlns='http://jabber.org/features/iq-auth'></auth>");
        this._os.print("</stream:features>\n");
        this._os.flush();
    }

    private boolean handleStream() throws IOException, XMLStreamException {
        String name = this._in.getLocalName();
        String to = null;
        for (int i = this._in.getAttributeCount() - 1; i >= 0; --i) {
            String localName = this._in.getAttributeLocalName(i);
            String value = this._in.getAttributeValue(i);
            if (!"to".equals(localName)) continue;
            to = value;
        }
        String from = this._host;
        if (from == null) {
            from = to;
        }
        if (from == null) {
            from = this._conn.getLocalAddress().getHostAddress();
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " stream open(from=" + from + " id=" + this._id + ")");
        }
        this._os.print("<stream:stream xmlns='jabber:client'");
        this._os.print(" xmlns:stream='http://etherx.jabber.org/streams'");
        this._os.print(" id='" + this._id + "'");
        this._os.print(" from='" + from + "'");
        this._os.print(" version='1.0'>");
        this._os.print("<stream:features>");
        this._os.print("<bind xmlns='urn:ietf:params:xml:ns:xmpp-bind'/>");
        if (this._isRequireSession) {
            this._os.print("<session xmlns='urn:ietf:params:xml:ns:xmpp-session'/>");
        }
        this._os.print("</stream:features>");
        this._os.flush();
        return true;
    }

    private void skipToEnd(String tagName) throws IOException, XMLStreamException {
        int tag;
        XmppStreamReader in = this._in;
        if (in == null) {
            return;
        }
        while ((tag = in.next()) > 0) {
            if (this._isFinest) {
                this.debug(in);
            }
            if (tag == 1 || tag != 2 || !tagName.equals(in.getLocalName())) continue;
            return;
        }
    }

    private boolean handleAuth() throws IOException, XMLStreamException {
        String mechanism = this._in.getAttributeValue(null, "mechanism");
        if ("PLAIN".equals(mechanism)) {
            return this.handleAuthPlain();
        }
        throw new IllegalStateException("Unknown mechanism: " + mechanism);
    }

    private boolean handleAuthPlain() throws IOException, XMLStreamException {
        String decoded;
        int p;
        int tag;
        String value = null;
        while ((tag = this._in.next()) > 0 && tag != 1 && tag != 2) {
            if (this._isFinest) {
                this.debug(this._in);
            }
            if (tag != 4) continue;
            char[] buffer = this._in.getTextCharacters();
            int start = this._in.getTextStart();
            int len = this._in.getTextLength();
            value = new String(this._in.getTextCharacters(), start, len);
        }
        if (value == null) {
            return false;
        }
        if (this._isFinest) {
            this.debug(this._in);
        }
        if ((p = (decoded = Base64.decode(value)).indexOf(0, 1)) < 0) {
            return false;
        }
        String name = decoded.substring(1, p);
        String password = decoded.substring(p + 1);
        boolean isAuth = true;
        if (isAuth) {
            this._name = name;
            this._uid = this._name + "@" + this._host;
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " auth-plain success for " + name);
            }
            this._os.print("<success xmlns='urn:ietf:params:xml:ns:xmpp-sasl'></success>");
            this._os.flush();
            return true;
        }
        return false;
    }

    private void debug(XMLStreamReader in) throws IOException, XMLStreamException {
        if (1 == in.getEventType()) {
            StringBuilder sb = new StringBuilder();
            sb.append("<").append(in.getLocalName());
            if (in.getNamespaceURI() != null) {
                sb.append("{").append(in.getNamespaceURI()).append("}");
            }
            for (int i = 0; i < in.getAttributeCount(); ++i) {
                sb.append(" ");
                sb.append(in.getAttributeLocalName(i));
                sb.append("='");
                sb.append(in.getAttributeValue(i));
                sb.append("'");
            }
            sb.append(">");
            log.finest(this + " " + sb);
        } else if (2 == in.getEventType()) {
            log.finest(this + " </" + in.getLocalName() + ">");
        } else if (4 == in.getEventType()) {
            String text = in.getText().trim();
            if (!"".equals(text)) {
                log.finest(this + " text='" + text + "'");
            }
        } else {
            log.finest(this + " tag=" + in.getEventType());
        }
    }

    public boolean handleResume() throws IOException {
        return false;
    }

    public void onCloseConnection() {
        ++this._requestId;
        this._state = null;
        this._isPresent = false;
    }

    public String toString() {
        if (this._conn != null) {
            return this.getClass().getSimpleName() + "[" + this._conn.getId() + "]";
        }
        return this.getClass().getSimpleName() + "[]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        INIT;

    }
}

