/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xmpp;

import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.caucho.xml.stream.XMLStreamReaderImpl;
import com.caucho.xmpp.XmppMarshal;
import com.caucho.xmpp.XmppMarshalFactory;
import com.caucho.xmpp.XmppStreamReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public class XmppStreamReaderImpl
extends XMLStreamReaderImpl
implements XmppStreamReader {
    private static final L10N L = new L10N(XmppStreamReaderImpl.class);
    private static final Logger log = Logger.getLogger(XmppStreamReaderImpl.class.getName());
    private XmppMarshalFactory _marshalFactory;

    XmppStreamReaderImpl(ReadStream is, XmppMarshalFactory factory) throws XMLStreamException {
        super(is);
        this._marshalFactory = factory;
    }

    public Serializable readValue() throws IOException, XMLStreamException {
        QName name = this.getName();
        Object query = null;
        XmppMarshal marshal = this._marshalFactory.getUnserialize(name);
        if (marshal != null) {
            return marshal.fromXml(this);
        }
        return this.readAsXmlString();
    }

    public String readAsXmlString() throws IOException, XMLStreamException {
        StringBuilder sb = new StringBuilder();
        int depth = 0;
        do {
            String prefix;
            if (1 == this.getEventType()) {
                ++depth;
                prefix = this.getPrefix();
                sb.append("<");
                if (!"".equals(prefix)) {
                    sb.append(prefix);
                    sb.append(":");
                }
                sb.append(this.getLocalName());
                if (this.getNamespaceURI() != null) {
                    if ("".equals(prefix)) {
                        sb.append(" xmlns");
                    } else {
                        sb.append(" xmlns:").append(prefix);
                    }
                    sb.append("=\"");
                    sb.append(this.getNamespaceURI()).append("\"");
                }
                for (int i = 0; i < this.getAttributeCount(); ++i) {
                    sb.append(" ");
                    sb.append(this.getAttributeLocalName(i));
                    sb.append("=\"");
                    sb.append(this.getAttributeValue(i));
                    sb.append("\"");
                }
                sb.append(">");
                log.finest(this + " " + sb);
                continue;
            }
            if (2 == this.getEventType()) {
                --depth;
                sb.append("</");
                prefix = this.getPrefix();
                if (!"".equals(prefix)) {
                    sb.append(prefix).append(":");
                }
                sb.append(this.getLocalName());
                sb.append(">");
                if (depth != 0) continue;
                return sb.toString();
            }
            if (4 == this.getEventType()) {
                sb.append(this.getText());
                continue;
            }
            log.finer(this + " tag=" + this.getEventType());
            return sb.toString();
        } while (this.next() >= 0);
        log.finer(this + " unexpected end of file");
        return sb.toString();
    }
}

