/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xmpp.data;

import com.caucho.xmpp.AbstractXmppMarshal;
import com.caucho.xmpp.XmppStreamReader;
import com.caucho.xmpp.XmppStreamWriter;
import com.caucho.xmpp.data.DataField;
import com.caucho.xmpp.data.DataForm;
import com.caucho.xmpp.data.DataInstructions;
import com.caucho.xmpp.data.DataItem;
import com.caucho.xmpp.data.DataOption;
import com.caucho.xmpp.data.DataReported;
import com.caucho.xmpp.data.DataValue;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XmppDataFormMarshal
extends AbstractXmppMarshal {
    private static final Logger log = Logger.getLogger(XmppDataFormMarshal.class.getName());
    private static final boolean _isFinest = log.isLoggable(Level.FINEST);

    public String getNamespaceURI() {
        return "jabber:x:data";
    }

    public String getLocalName() {
        return "x";
    }

    public String getClassName() {
        return DataForm.class.getName();
    }

    public void toXml(XmppStreamWriter out, Serializable object) throws IOException, XMLStreamException {
        DataItem[] items;
        DataField[] fields;
        DataInstructions[] instructions;
        DataForm form = (DataForm)object;
        out.writeStartElement("", this.getLocalName(), this.getNamespaceURI());
        out.writeNamespace("", this.getNamespaceURI());
        if (form.getType() != null) {
            out.writeAttribute("type", form.getType());
        }
        if (form.getTitle() != null) {
            out.writeStartElement("title");
            out.writeCharacters(form.getTitle());
            out.writeEndElement();
        }
        if ((instructions = form.getInstructions()) != null) {
            for (DataInstructions instruction : instructions) {
                this.toXml(out, instruction);
            }
        }
        if ((fields = form.getField()) != null) {
            for (DataField field : fields) {
                this.toXml(out, field);
            }
        }
        if (form.getReported() != null) {
            this.toXml(out, form.getReported());
        }
        if ((items = form.getItem()) != null) {
            for (DataItem item : items) {
                this.toXml(out, item);
            }
        }
        out.writeEndElement();
    }

    private void toXml(XmppStreamWriter out, DataField field) throws IOException, XMLStreamException {
        DataOption[] options;
        DataValue[] values;
        out.writeStartElement("field");
        if (field.getLabel() != null) {
            out.writeAttribute("label", field.getLabel());
        }
        if (field.getType() != null) {
            out.writeAttribute("type", field.getType());
        }
        if (field.getVar() != null) {
            out.writeAttribute("var", field.getVar());
        }
        if (field.getDesc() != null) {
            out.writeStartElement("desc");
            out.writeCharacters(field.getDesc());
            out.writeEndElement();
        }
        if (field.isRequired()) {
            out.writeStartElement("required");
            out.writeEndElement();
        }
        if ((values = field.getValue()) != null) {
            for (int i = 0; i < values.length; ++i) {
                DataValue value = values[i];
                out.writeStartElement("value");
                out.writeCharacters(value.getValue());
                out.writeEndElement();
            }
        }
        if ((options = field.getOption()) != null) {
            for (int i = 0; i < options.length; ++i) {
                this.toXml(out, options[i]);
            }
        }
        out.writeEndElement();
    }

    private void toXml(XmppStreamWriter out, DataOption option) throws IOException, XMLStreamException {
        DataValue[] values;
        out.writeStartElement("option");
        if (option.getLabel() != null) {
            out.writeAttribute("label", option.getLabel());
        }
        if ((values = option.getValue()) != null) {
            for (int i = 0; i < values.length; ++i) {
                DataValue value = values[i];
                out.writeStartElement("value");
                out.writeCharacters(value.getValue());
                out.writeEndElement();
            }
        }
        out.writeEndElement();
    }

    private void toXml(XmppStreamWriter out, DataItem item) throws IOException, XMLStreamException {
        out.writeStartElement("item");
        DataField[] fields = item.getField();
        if (fields != null) {
            for (int i = 0; i < fields.length; ++i) {
                this.toXml(out, fields[i]);
            }
        }
        out.writeEndElement();
    }

    private void toXml(XmppStreamWriter out, DataReported reported) throws IOException, XMLStreamException {
        out.writeStartElement("reported");
        DataField[] fields = reported.getField();
        if (fields != null) {
            for (int i = 0; i < fields.length; ++i) {
                this.toXml(out, fields[i]);
            }
        }
        out.writeEndElement();
    }

    private void toXml(XmppStreamWriter out, DataInstructions instructions) throws IOException, XMLStreamException {
        out.writeStartElement("instructions");
        if (instructions.getValue() != null) {
            out.writeCharacters(instructions.getValue());
        }
        out.writeEndElement();
    }

    public Serializable fromXml(XmppStreamReader in) throws IOException, XMLStreamException {
        boolean isFinest = log.isLoggable(Level.FINEST);
        String type = in.getAttributeValue(null, "type");
        DataForm form = new DataForm(type);
        ArrayList<DataField> fieldList = new ArrayList<DataField>();
        ArrayList<DataItem> itemList = new ArrayList<DataItem>();
        ArrayList<DataInstructions> instructionsList = new ArrayList<DataInstructions>();
        int tag = in.nextTag();
        while (tag > 0) {
            if (isFinest) {
                this.debug(in);
            }
            if (2 == tag) {
                form.setFieldList(fieldList);
                form.setItemList(itemList);
                form.setInstructionsList(instructionsList);
                return form;
            }
            if (1 == tag && "field".equals(in.getLocalName())) {
                fieldList.add(this.parseField(in));
            } else if (1 == tag && "item".equals(in.getLocalName())) {
                itemList.add(this.parseItem(in));
            } else if (1 == tag && "reported".equals(in.getLocalName())) {
                form.setReported(this.parseReported(in));
            } else if (1 == tag && "title".equals(in.getLocalName())) {
                String title = in.getElementText();
                form.setTitle(title);
                this.skipToEnd(in, "title");
            } else if (1 == tag && "instructions".equals(in.getLocalName())) {
                String value = in.getElementText();
                instructionsList.add(new DataInstructions(value));
                this.skipToEnd(in, "instructions");
            } else if (1 == tag) {
                log.finer(this + " <" + in.getLocalName() + "> is an unknown tag");
                this.skipToEnd(in, in.getLocalName());
            }
            tag = in.nextTag();
        }
        return null;
    }

    public DataField parseField(XMLStreamReader in) throws IOException, XMLStreamException {
        String label = in.getAttributeValue(null, "label");
        String type = in.getAttributeValue(null, "type");
        String var = in.getAttributeValue(null, "var");
        DataField field = new DataField(type, var, label);
        ArrayList<DataValue> valueList = new ArrayList<DataValue>();
        ArrayList<DataOption> optionList = new ArrayList<DataOption>();
        int tag = in.nextTag();
        while (tag > 0) {
            if (_isFinest) {
                this.debug(in);
            }
            if (2 == tag) {
                field.setValueList(valueList);
                field.setOptionList(optionList);
                return field;
            }
            if (1 == tag && "desc".equals(in.getLocalName())) {
                String desc = in.getElementText();
                field.setDesc(desc);
                this.skipToEnd(in, "desc");
            } else if (1 == tag && "option".equals(in.getLocalName())) {
                optionList.add(this.parseOption(in));
            } else if (1 == tag && "required".equals(in.getLocalName())) {
                field.setRequired(true);
                this.skipToEnd(in, "required");
            } else if (1 == tag && "value".equals(in.getLocalName())) {
                String value = in.getElementText();
                valueList.add(new DataValue(value));
                this.skipToEnd(in, "value");
            } else if (1 == tag) {
                log.finer(this + " <" + in.getLocalName() + "> is an unknown tag");
                this.skipToEnd(in, in.getLocalName());
            }
            tag = in.nextTag();
        }
        this.skipToEnd(in, "field");
        return field;
    }

    public DataItem parseItem(XMLStreamReader in) throws IOException, XMLStreamException {
        DataItem item = new DataItem();
        ArrayList<DataField> fieldList = new ArrayList<DataField>();
        int tag = in.nextTag();
        while (tag > 0) {
            if (_isFinest) {
                this.debug(in);
            }
            if (2 == tag) {
                item.setFieldList(fieldList);
                return item;
            }
            if (1 == tag && "field".equals(in.getLocalName())) {
                fieldList.add(this.parseField(in));
            } else if (1 == tag) {
                log.finer(this + " <" + in.getLocalName() + "> is an unknown tag");
                this.skipToEnd(in, in.getLocalName());
            }
            tag = in.nextTag();
        }
        this.skipToEnd(in, "item");
        return item;
    }

    public DataReported parseReported(XMLStreamReader in) throws IOException, XMLStreamException {
        DataReported reported = new DataReported();
        ArrayList<DataField> fieldList = new ArrayList<DataField>();
        int tag = in.nextTag();
        while (tag > 0) {
            if (_isFinest) {
                this.debug(in);
            }
            if (2 == tag) {
                reported.setFieldList(fieldList);
                return reported;
            }
            if (1 == tag && "field".equals(in.getLocalName())) {
                fieldList.add(this.parseField(in));
            } else if (1 == tag) {
                log.finer(this + " <" + in.getLocalName() + "> is an unknown tag");
                this.skipToEnd(in, in.getLocalName());
            }
            tag = in.nextTag();
        }
        this.skipToEnd(in, "reported");
        return reported;
    }

    public DataOption parseOption(XMLStreamReader in) throws IOException, XMLStreamException {
        String label = in.getAttributeValue(null, "label");
        DataOption option = new DataOption(label);
        ArrayList<DataValue> valueList = new ArrayList<DataValue>();
        int tag = in.nextTag();
        while (tag > 0) {
            if (_isFinest) {
                this.debug(in);
            }
            if (2 == tag) {
                option.setValueList(valueList);
                return option;
            }
            if (1 == tag && "value".equals(in.getLocalName())) {
                String value = in.getElementText();
                valueList.add(new DataValue(value));
                this.skipToEnd(in, "value");
            } else if (1 == tag) {
                log.finer(this + " <" + in.getLocalName() + "> is an unknown tag");
                this.skipToEnd(in, in.getLocalName());
            }
            tag = in.nextTag();
        }
        this.skipToEnd(in, "option");
        return option;
    }
}

