/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xmpp.disco;

import com.caucho.xmpp.AbstractXmppMarshal;
import com.caucho.xmpp.XmppStreamReader;
import com.caucho.xmpp.XmppStreamWriter;
import com.caucho.xmpp.disco.DiscoFeature;
import com.caucho.xmpp.disco.DiscoIdentity;
import com.caucho.xmpp.disco.DiscoInfoQuery;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XmppDiscoInfoQueryMarshal
extends AbstractXmppMarshal {
    private static final Logger log = Logger.getLogger(XmppDiscoInfoQueryMarshal.class.getName());
    private static final boolean _isFinest = log.isLoggable(Level.FINEST);

    public String getNamespaceURI() {
        return "http://jabber.org/protocol/disco#info";
    }

    public String getLocalName() {
        return "query";
    }

    public String getClassName() {
        return DiscoInfoQuery.class.getName();
    }

    public void toXml(XmppStreamWriter out, Serializable object) throws IOException, XMLStreamException {
        DiscoFeature[] featureList;
        DiscoIdentity[] identityList;
        DiscoInfoQuery discoInfo = (DiscoInfoQuery)object;
        out.writeStartElement("", this.getLocalName(), this.getNamespaceURI());
        out.writeNamespace("", this.getNamespaceURI());
        if (discoInfo.getNode() != null) {
            out.writeAttribute("node", discoInfo.getNode());
        }
        if ((identityList = discoInfo.getIdentity()) != null) {
            for (DiscoIdentity identity : identityList) {
                out.writeStartElement("identity");
                out.writeAttribute("category", identity.getCategory());
                out.writeAttribute("type", identity.getType());
                if (identity.getName() != null) {
                    out.writeAttribute("name", identity.getName());
                }
                out.writeEndElement();
            }
        }
        if ((featureList = discoInfo.getFeature()) != null) {
            for (DiscoFeature feature : featureList) {
                out.writeStartElement("feature");
                out.writeAttribute("var", feature.getVar());
                out.writeEndElement();
            }
        }
        out.writeEndElement();
    }

    public Serializable fromXml(XmppStreamReader in) throws IOException, XMLStreamException {
        boolean isFinest = log.isLoggable(Level.FINEST);
        int tag = in.nextTag();
        String node = in.getAttributeValue(null, "node");
        DiscoInfoQuery discoInfo = new DiscoInfoQuery(node);
        ArrayList<DiscoIdentity> identityList = new ArrayList<DiscoIdentity>();
        ArrayList<DiscoFeature> featureList = new ArrayList<DiscoFeature>();
        while (tag > 0) {
            if (isFinest) {
                this.debug(in);
            }
            if (2 == tag) {
                discoInfo.setIdentityList(identityList);
                discoInfo.setFeatureList(featureList);
                return discoInfo;
            }
            if (1 == tag && "feature".equals(in.getLocalName())) {
                featureList.add(this.parseFeature(in));
            } else if (1 == tag && "identity".equals(in.getLocalName())) {
                identityList.add(this.parseIdentity(in));
            } else if (1 == tag) {
                log.finer(this + " <" + in.getLocalName() + "> is an unknown tag");
                this.skipToEnd(in, in.getLocalName());
            }
            tag = in.nextTag();
        }
        return null;
    }

    public DiscoFeature parseFeature(XMLStreamReader in) throws IOException, XMLStreamException {
        String var = in.getAttributeValue(null, "var");
        this.skipToEnd(in, "feature");
        return new DiscoFeature(var);
    }

    public DiscoIdentity parseIdentity(XMLStreamReader in) throws IOException, XMLStreamException {
        String category = in.getAttributeValue(null, "category");
        String type = in.getAttributeValue(null, "type");
        String name = in.getAttributeValue(null, "name");
        this.skipToEnd(in, "identity");
        return new DiscoIdentity(category, type, name);
    }
}

