/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xmpp.disco;

import com.caucho.xmpp.AbstractXmppMarshal;
import com.caucho.xmpp.XmppStreamReader;
import com.caucho.xmpp.XmppStreamWriter;
import com.caucho.xmpp.disco.DiscoItem;
import com.caucho.xmpp.disco.DiscoItemsQuery;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XmppDiscoItemsQueryMarshal
extends AbstractXmppMarshal {
    private static final Logger log = Logger.getLogger(XmppDiscoItemsQueryMarshal.class.getName());
    private static final boolean _isFinest = log.isLoggable(Level.FINEST);

    public String getNamespaceURI() {
        return "http://jabber.org/protocol/disco#items";
    }

    public String getLocalName() {
        return "query";
    }

    public String getClassName() {
        return DiscoItemsQuery.class.getName();
    }

    public void toXml(XmppStreamWriter out, Serializable object) throws IOException, XMLStreamException {
        DiscoItem[] items;
        DiscoItemsQuery discoItems = (DiscoItemsQuery)object;
        out.writeStartElement("", this.getLocalName(), this.getNamespaceURI());
        out.writeNamespace("", this.getNamespaceURI());
        if (discoItems.getNode() != null) {
            out.writeAttribute("node", discoItems.getNode());
        }
        if ((items = discoItems.getItems()) != null) {
            for (DiscoItem item : items) {
                out.writeStartElement("item");
                out.writeAttribute("jid", item.getJid());
                if (item.getName() != null) {
                    out.writeAttribute("name", item.getName());
                }
                if (item.getNode() != null) {
                    out.writeAttribute("node", item.getNode());
                }
                out.writeEndElement();
            }
        }
        out.writeEndElement();
    }

    public Serializable fromXml(XmppStreamReader in) throws IOException, XMLStreamException {
        boolean isFinest = log.isLoggable(Level.FINEST);
        int tag = in.nextTag();
        String node = in.getAttributeValue(null, "node");
        DiscoItemsQuery discoItems = new DiscoItemsQuery(node);
        ArrayList<DiscoItem> itemList = new ArrayList<DiscoItem>();
        while (tag > 0) {
            if (isFinest) {
                this.debug(in);
            }
            if (2 == tag) {
                discoItems.setItemList(itemList);
                return discoItems;
            }
            if (1 == tag && "item".equals(in.getLocalName())) {
                itemList.add(this.parseItem(in));
            } else if (1 == tag) {
                log.finer(this + " <" + in.getLocalName() + "> is an unknown tag");
                this.skipToEnd(in, in.getLocalName());
            }
            tag = in.nextTag();
        }
        return null;
    }

    public DiscoItem parseItem(XMLStreamReader in) throws IOException, XMLStreamException {
        String jid = in.getAttributeValue(null, "jid");
        String name = in.getAttributeValue(null, "name");
        String node = in.getAttributeValue(null, "node");
        this.skipToEnd(in, "item");
        return new DiscoItem(jid, name, node);
    }
}

