/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xmpp.im;

import com.caucho.xmpp.im.Text;
import java.io.Serializable;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImMessage
implements Serializable {
    private String _to;
    private String _from;
    private String _type = "normal";
    private Text[] _subject;
    private Text[] _body;
    private String _thread;
    private Serializable[] _extra;

    private ImMessage() {
    }

    public ImMessage(String body) {
        this._type = "chat";
        this._body = new Text[]{new Text(body)};
    }

    public ImMessage(String type, String body) {
        this._type = type;
        this._body = new Text[]{new Text(body)};
    }

    public ImMessage(String to, String from, String body) {
        this._type = "chat";
        this._to = to;
        this._from = from;
        this._body = new Text[]{new Text(body)};
    }

    public ImMessage(String to, String from, String body, Serializable extra) {
        this._type = "chat";
        this._to = to;
        this._from = from;
        this._body = new Text[]{new Text(body)};
        this._extra = new Serializable[]{extra};
    }

    public ImMessage(String to, String from, String body, Serializable[] extra) {
        this._type = "chat";
        this._to = to;
        this._from = from;
        this._body = new Text[]{new Text(body)};
        this._extra = extra;
    }

    public ImMessage(String to, String from, String type, Text[] subject, Text[] body, String thread, Serializable[] extra) {
        this._to = to;
        this._from = from;
        this._type = type;
        this._subject = subject;
        this._body = body;
        this._thread = thread;
        this._extra = extra;
    }

    public String getTo() {
        return this._to;
    }

    public String getFrom() {
        return this._from;
    }

    public String getType() {
        return this._type;
    }

    public Text[] getSubjects() {
        return this._subject;
    }

    public String getSubjectString() {
        if (this._subject == null || this._subject.length == 0) {
            return null;
        }
        return this._subject[0].getValue();
    }

    public Text[] getBodys() {
        return this._body;
    }

    public String getBodyString() {
        if (this._body == null || this._body.length == 0) {
            return null;
        }
        return this._body[0].getValue();
    }

    public void setThread(String thread) {
        this._thread = thread;
    }

    public String getThread() {
        return this._thread;
    }

    public Serializable[] getExtra() {
        return this._extra;
    }

    public void setExtra(Serializable[] extra) {
        this._extra = extra;
    }

    public void setExtraList(ArrayList<Serializable> extraList) {
        if (extraList != null && extraList.size() > 0) {
            this._extra = new Serializable[extraList.size()];
            extraList.toArray(this._extra);
        } else {
            this._extra = null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[");
        sb.append(this._type);
        if (this._to != null) {
            sb.append(",to=").append(this._to);
        }
        if (this._from != null) {
            sb.append(",from=").append(this._from);
        }
        if (this._subject != null) {
            for (Text text : this._subject) {
                if (text.getLang() != null) {
                    sb.append(",subject(").append(text.getLang()).append(")='");
                } else {
                    sb.append(",subject='");
                }
                sb.append(text.getValue());
                sb.append("'");
            }
        }
        if (this._body != null && this._body.length != 0) {
            for (Serializable serializable : this._body) {
                if (((Text)serializable).getLang() != null) {
                    sb.append(",body(").append(((Text)serializable).getLang()).append(")='");
                } else {
                    sb.append(",body='");
                }
                sb.append(((Text)serializable).getValue());
                sb.append("'");
            }
        }
        if (this._thread != null) {
            sb.append(",thread=");
            sb.append(this._thread);
        }
        if (this._extra != null) {
            for (Serializable serializable : this._extra) {
                sb.append(",extra=").append(serializable);
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

