/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xmpp.im;

import com.caucho.xmpp.AbstractXmppMarshal;
import com.caucho.xmpp.XmppStreamReader;
import com.caucho.xmpp.XmppStreamWriter;
import com.caucho.xmpp.im.ImBindQuery;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;

public class XmppImBindQueryMarshal
extends AbstractXmppMarshal {
    private static final Logger log = Logger.getLogger(XmppImBindQueryMarshal.class.getName());

    public String getNamespaceURI() {
        return "urn:ietf:params:xml:ns:xmpp-bind";
    }

    public String getLocalName() {
        return "bind";
    }

    public String getClassName() {
        return ImBindQuery.class.getName();
    }

    public void toXml(XmppStreamWriter out, Serializable object) throws IOException, XMLStreamException {
        ImBindQuery bind = (ImBindQuery)object;
        out.writeStartElement("", this.getLocalName(), this.getNamespaceURI());
        out.writeNamespace("", this.getNamespaceURI());
        if (bind.getResource() != null) {
            out.writeStartElement("resource");
            out.writeCharacters(bind.getResource());
            out.writeEndElement();
        }
        if (bind.getJid() != null) {
            out.writeStartElement("jid");
            out.writeCharacters(bind.getJid());
            out.writeEndElement();
        }
        out.writeEndElement();
    }

    public Serializable fromXml(XmppStreamReader in) throws IOException, XMLStreamException {
        int tag;
        boolean isFinest = log.isLoggable(Level.FINEST);
        String resource = null;
        String jid = null;
        while ((tag = in.nextTag()) > 0) {
            if (isFinest) {
                this.debug(in);
            }
            if (2 == tag) {
                return new ImBindQuery(resource, jid);
            }
            if (1 == tag && "resource".equals(in.getLocalName())) {
                resource = in.getElementText();
                this.skipToEnd(in, "resource");
                continue;
            }
            if (1 == tag && "jid".equals(in.getLocalName())) {
                jid = in.getElementText();
                this.skipToEnd(in, "jid");
                continue;
            }
            log.warning(this + " unexpected tag " + in.getLocalName());
            this.skipToEnd(in, "bind");
            return null;
        }
        return null;
    }
}

