/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xmpp.im;

import com.caucho.xmpp.AbstractXmppMarshal;
import com.caucho.xmpp.XmppStreamReader;
import com.caucho.xmpp.XmppStreamWriter;
import com.caucho.xmpp.im.RosterItem;
import com.caucho.xmpp.im.RosterQuery;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;

public class XmppRosterQueryMarshal
extends AbstractXmppMarshal {
    private static final Logger log = Logger.getLogger(XmppRosterQueryMarshal.class.getName());

    public String getNamespaceURI() {
        return "jabber:iq:roster";
    }

    public String getLocalName() {
        return "query";
    }

    public String getClassName() {
        return RosterQuery.class.getName();
    }

    public void toXml(XmppStreamWriter out, Serializable object) throws IOException, XMLStreamException {
        RosterQuery roster = (RosterQuery)object;
        out.writeStartElement("", "query", "jabber:iq:roster");
        out.writeNamespace("", "jabber:iq:roster");
        RosterItem[] items = roster.getItems();
        if (items != null) {
            for (RosterItem item : items) {
                String[] groups;
                out.writeStartElement("item");
                if (item.getAsk() != null) {
                    out.writeAttribute("ask", item.getAsk());
                }
                if (item.getJid() != null) {
                    out.writeAttribute("jid", item.getJid());
                }
                if (item.getName() != null) {
                    out.writeAttribute("name", item.getName());
                }
                if (item.getSubscription() != null) {
                    out.writeAttribute("subscription", item.getSubscription());
                }
                if ((groups = item.getGroup()) != null) {
                    for (String group : groups) {
                        out.writeStartElement("group");
                        out.writeCharacters(group);
                        out.writeEndElement();
                    }
                }
                out.writeEndElement();
            }
        }
        out.writeEndElement();
    }

    public Serializable fromXml(XmppStreamReader in) throws IOException, XMLStreamException {
        ArrayList<RosterItem> itemList = new ArrayList<RosterItem>();
        boolean isFinest = log.isLoggable(Level.FINEST);
        int tag = in.nextTag();
        while (tag > 0) {
            if (isFinest) {
                this.debug(in);
            }
            if (2 == tag) {
                return new RosterQuery(itemList);
            }
            if (1 != tag || !"item".equals(in.getLocalName())) {
                log.warning("expected start");
                this.skipToEnd(in, "query");
                return null;
            }
            String ask = null;
            String jid = null;
            String name = null;
            String subscription = null;
            for (int i = 0; i < in.getAttributeCount(); ++i) {
                String attr = in.getAttributeLocalName(i);
                if ("ask".equals(attr)) {
                    ask = in.getAttributeValue(i);
                    continue;
                }
                if ("jid".equals(attr)) {
                    jid = in.getAttributeValue(i);
                    continue;
                }
                if ("name".equals(attr)) {
                    name = in.getAttributeValue(i);
                    continue;
                }
                if (!"subscription".equals(attr)) continue;
                subscription = in.getAttributeValue(i);
            }
            ArrayList<String> groups = new ArrayList<String>();
            tag = in.nextTag();
            while (1 == in.getEventType() && "group".equals(in.getLocalName())) {
                groups.add(in.getElementText());
                this.skipToEnd(in, "group");
            }
            this.skipToEnd(in, "item");
            RosterItem item = new RosterItem(ask, jid, name, subscription, groups);
            itemList.add(item);
            tag = in.nextTag();
        }
        return null;
    }
}

