/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xmpp.muc;

import com.caucho.xmpp.AbstractXmppMarshal;
import com.caucho.xmpp.XmppStreamReader;
import com.caucho.xmpp.XmppStreamWriter;
import com.caucho.xmpp.muc.MucAdminQuery;
import com.caucho.xmpp.muc.MucContinue;
import com.caucho.xmpp.muc.MucUserItem;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XmppMucAdminQueryMarshal
extends AbstractXmppMarshal {
    private static final Logger log = Logger.getLogger(XmppMucAdminQueryMarshal.class.getName());
    private static final boolean _isFinest = log.isLoggable(Level.FINEST);

    public String getNamespaceURI() {
        return "http://jabber.org/protocol/muc#admin";
    }

    public String getLocalName() {
        return "query";
    }

    public String getClassName() {
        return MucAdminQuery.class.getName();
    }

    public void toXml(XmppStreamWriter out, Serializable object) throws IOException, XMLStreamException {
        MucAdminQuery mucAdmin = (MucAdminQuery)object;
        out.writeStartElement("", this.getLocalName(), this.getNamespaceURI());
        out.writeNamespace("", this.getNamespaceURI());
        MucUserItem[] items = mucAdmin.getItems();
        if (items != null) {
            for (MucUserItem item : items) {
                this.toXml(out, item);
            }
        }
        out.writeEndElement();
    }

    private void toXml(XmppStreamWriter out, MucUserItem item) throws IOException, XMLStreamException {
        out.writeStartElement("item");
        if (item.getAffiliation() != null) {
            out.writeAttribute("affiliation", item.getAffiliation());
        }
        if (item.getJid() != null) {
            out.writeAttribute("jid", item.getJid());
        }
        if (item.getNick() != null) {
            out.writeAttribute("nick", item.getNick());
        }
        if (item.getRole() != null) {
            out.writeAttribute("role", item.getRole());
        }
        if (item.getActor() != null) {
            out.writeStartElement("actor");
            out.writeAttribute("jid", item.getActor());
            out.writeEndElement();
        }
        if (item.getReason() != null) {
            out.writeStartElement("reason");
            out.writeCharacters(item.getReason());
            out.writeEndElement();
        }
        out.writeEndElement();
    }

    public Serializable fromXml(XmppStreamReader in) throws IOException, XMLStreamException {
        boolean isFinest = log.isLoggable(Level.FINEST);
        int tag = in.nextTag();
        MucAdminQuery mucAdmin = new MucAdminQuery();
        ArrayList<MucUserItem> itemList = new ArrayList<MucUserItem>();
        while (tag > 0) {
            if (isFinest) {
                this.debug(in);
            }
            if (2 == tag) {
                mucAdmin.setItemList(itemList);
                return mucAdmin;
            }
            if (1 == tag && "item".equals(in.getLocalName())) {
                itemList.add(this.parseItem(in));
            } else if (1 == tag) {
                log.finer(this + " <" + in.getLocalName() + "> is an unknown tag");
                this.skipToEnd(in, in.getLocalName());
            }
            tag = in.nextTag();
        }
        return null;
    }

    private MucUserItem parseItem(XMLStreamReader in) throws IOException, XMLStreamException {
        String affiliation = in.getAttributeValue(null, "affiliation");
        String jid = in.getAttributeValue(null, "jid");
        String nick = in.getAttributeValue(null, "nick");
        String role = in.getAttributeValue(null, "role");
        MucUserItem item = new MucUserItem();
        if (affiliation != null) {
            item.setAffiliation(affiliation);
        }
        if (jid != null) {
            item.setJid(jid);
        }
        if (nick != null) {
            item.setNick(nick);
        }
        if (role != null) {
            item.setRole(role);
        }
        int tag = in.nextTag();
        while (tag > 0) {
            if (_isFinest) {
                this.debug(in);
            }
            if (2 == tag) {
                return item;
            }
            if (1 == tag && "actor".equals(in.getLocalName())) {
                item.setActor(in.getAttributeValue(null, "jid"));
                this.skipToEnd(in, "actor");
            } else if (1 == tag && "continue".equals(in.getLocalName())) {
                String thread = in.getAttributeValue(null, "thread");
                item.setContinue(new MucContinue(thread));
                this.skipToEnd(in, "continue");
            } else if (1 == tag && "reason".equals(in.getLocalName())) {
                item.setReason(in.getElementText());
                this.skipToEnd(in, "reason");
            }
            tag = in.nextTag();
        }
        return null;
    }
}

