/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xmpp.muc;

import com.caucho.xmpp.AbstractXmppMarshal;
import com.caucho.xmpp.XmppStreamReader;
import com.caucho.xmpp.XmppStreamWriter;
import com.caucho.xmpp.data.DataForm;
import com.caucho.xmpp.muc.MucOwnerDestroyQuery;
import com.caucho.xmpp.muc.MucOwnerFormQuery;
import com.caucho.xmpp.muc.MucOwnerQuery;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;

public class XmppMucOwnerQueryMarshal
extends AbstractXmppMarshal {
    private static final Logger log = Logger.getLogger(XmppMucOwnerQueryMarshal.class.getName());
    private static final boolean _isFinest = log.isLoggable(Level.FINEST);

    public String getNamespaceURI() {
        return "http://jabber.org/protocol/muc#owner";
    }

    public String getLocalName() {
        return "query";
    }

    public String getClassName() {
        return null;
    }

    public void toXml(XmppStreamWriter out, Serializable object) throws IOException, XMLStreamException {
        throw new UnsupportedOperationException();
    }

    public Serializable fromXml(XmppStreamReader in) throws IOException, XMLStreamException {
        boolean isFinest = log.isLoggable(Level.FINEST);
        int tag = in.nextTag();
        MucOwnerQuery mucOwner = null;
        while (tag > 0) {
            if (isFinest) {
                this.debug(in);
            }
            if (2 == tag) {
                return mucOwner;
            }
            if (1 == tag && "jabber:x:data".equals(in.getNamespaceURI())) {
                DataForm form = (DataForm)in.readValue();
                mucOwner = new MucOwnerFormQuery(form);
            } else if (1 == tag && "destroy".equals(in.getLocalName())) {
                mucOwner = this.parseDestroy(in);
            } else if (1 == tag) {
                log.finer(this + " <" + in.getLocalName() + "> is an unknown tag");
                this.skipToEnd(in, in.getLocalName());
            }
            tag = in.nextTag();
        }
        return null;
    }

    private MucOwnerDestroyQuery parseDestroy(XmppStreamReader in) throws IOException, XMLStreamException {
        boolean isFinest = log.isLoggable(Level.FINEST);
        String jid = in.getAttributeValue(null, "jid");
        String password = in.getAttributeValue(null, "password");
        String reason = in.getAttributeValue(null, "reason");
        this.skipToEnd(in, "destroy");
        return new MucOwnerDestroyQuery(jid, password, reason);
    }
}

