/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xmpp.muc;

import com.caucho.util.QDate;
import com.caucho.xmpp.AbstractXmppMarshal;
import com.caucho.xmpp.XmppStreamReader;
import com.caucho.xmpp.XmppStreamWriter;
import com.caucho.xmpp.muc.MucHistory;
import com.caucho.xmpp.muc.MucQuery;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XmppMucQueryMarshal
extends AbstractXmppMarshal {
    private static final Logger log = Logger.getLogger(XmppMucQueryMarshal.class.getName());
    private static final boolean _isFinest = log.isLoggable(Level.FINEST);

    public String getNamespaceURI() {
        return "http://jabber.org/protocol/muc";
    }

    public String getLocalName() {
        return "query";
    }

    public String getClassName() {
        return MucQuery.class.getName();
    }

    public void toXml(XmppStreamWriter out, Serializable object) throws IOException, XMLStreamException {
        MucQuery muc = (MucQuery)object;
        out.writeStartElement("", this.getLocalName(), this.getNamespaceURI());
        out.writeNamespace("", this.getNamespaceURI());
        if (muc.getPassword() != null) {
            out.writeAttribute("password", muc.getPassword());
        }
        if (muc.getHistory() != null) {
            this.toXml(out, muc.getHistory());
        }
        out.writeEndElement();
    }

    private void toXml(XmppStreamWriter out, MucHistory history) throws IOException, XMLStreamException {
        out.writeStartElement("history");
        if (history.getMaxChars() > 0) {
            out.writeAttribute("maxchars", String.valueOf(history.getMaxChars()));
        }
        if (history.getMaxStanzas() > 0) {
            out.writeAttribute("maxstanzas", String.valueOf(history.getMaxStanzas()));
        }
        if (history.getSeconds() > 0) {
            out.writeAttribute("seconds", String.valueOf(history.getSeconds()));
        }
        if (history.getSince() != null) {
            out.writeAttribute("since", QDate.formatISO8601(history.getSince().getTime()));
        }
        out.writeEndElement();
    }

    public Serializable fromXml(XmppStreamReader in) throws IOException, XMLStreamException {
        boolean isFinest = log.isLoggable(Level.FINEST);
        int tag = in.nextTag();
        MucQuery muc = new MucQuery();
        while (tag > 0) {
            if (isFinest) {
                this.debug(in);
            }
            if (2 == tag) {
                return muc;
            }
            if (1 == tag && "password".equals(in.getLocalName())) {
                muc.setPassword(in.getElementText());
                this.skipToEnd(in, "password");
            } else if (1 == tag && "history".equals(in.getLocalName())) {
                muc.setHistory(this.parseHistory(in));
            } else if (1 == tag) {
                log.finer(this + " <" + in.getLocalName() + "> is an unknown tag");
                this.skipToEnd(in, in.getLocalName());
            }
            tag = in.nextTag();
        }
        return null;
    }

    private MucHistory parseHistory(XMLStreamReader in) throws IOException, XMLStreamException {
        String maxChars = in.getAttributeValue(null, "maxchars");
        String maxStanzas = in.getAttributeValue(null, "maxstanzas");
        String seconds = in.getAttributeValue(null, "seconds");
        String since = in.getAttributeValue(null, "since");
        MucHistory history = new MucHistory();
        if (maxChars != null) {
            history.setMaxChars(Integer.parseInt(maxChars));
        }
        if (maxStanzas != null) {
            history.setMaxStanzas(Integer.parseInt(maxStanzas));
        }
        if (seconds != null) {
            history.setSeconds(Integer.parseInt(seconds));
        }
        if (since != null) {
            try {
                history.setSince(new Date(new QDate().parseDate(since)));
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        this.skipToEnd(in, "history");
        return history;
    }
}

