/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xmpp.muc;

import com.caucho.xmpp.AbstractXmppMarshal;
import com.caucho.xmpp.XmppStreamReader;
import com.caucho.xmpp.XmppStreamWriter;
import com.caucho.xmpp.muc.MucContinue;
import com.caucho.xmpp.muc.MucDecline;
import com.caucho.xmpp.muc.MucDestroy;
import com.caucho.xmpp.muc.MucInvite;
import com.caucho.xmpp.muc.MucStatus;
import com.caucho.xmpp.muc.MucUserItem;
import com.caucho.xmpp.muc.MucUserQuery;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XmppMucUserQueryMarshal
extends AbstractXmppMarshal {
    private static final Logger log = Logger.getLogger(XmppMucUserQueryMarshal.class.getName());
    private static final boolean _isFinest = log.isLoggable(Level.FINEST);

    public String getNamespaceURI() {
        return "http://jabber.org/protocol/muc#user";
    }

    public String getLocalName() {
        return "x";
    }

    public String getClassName() {
        return MucUserQuery.class.getName();
    }

    public void toXml(XmppStreamWriter out, Serializable object) throws IOException, XMLStreamException {
        MucStatus[] statusList;
        MucDestroy destroy;
        MucDecline decline;
        MucInvite[] invites;
        MucUserQuery mucUser = (MucUserQuery)object;
        out.writeStartElement("", this.getLocalName(), this.getNamespaceURI());
        out.writeNamespace("", this.getNamespaceURI());
        if (mucUser.getItem() != null) {
            this.toXml(out, mucUser.getItem());
        }
        if ((invites = mucUser.getInvite()) != null) {
            for (MucInvite invite : invites) {
                out.writeStartElement("invite");
                if (invite.getTo() != null) {
                    out.writeAttribute("to", invite.getTo());
                }
                if (invite.getFrom() != null) {
                    out.writeAttribute("from", invite.getFrom());
                }
                if (invite.getReason() != null) {
                    out.writeStartElement("reason");
                    out.writeCharacters(invite.getReason());
                    out.writeEndElement();
                }
                out.writeEndElement();
            }
        }
        if ((decline = mucUser.getDecline()) != null) {
            out.writeStartElement("decline");
            if (decline.getTo() != null) {
                out.writeAttribute("to", decline.getTo());
            }
            if (decline.getFrom() != null) {
                out.writeAttribute("from", decline.getFrom());
            }
            if (decline.getReason() != null) {
                out.writeStartElement("reason");
                out.writeCharacters(decline.getReason());
                out.writeEndElement();
            }
            out.writeEndElement();
        }
        if ((destroy = mucUser.getDestroy()) != null) {
            out.writeStartElement("destroy");
            if (destroy.getJid() != null) {
                out.writeAttribute("jid", destroy.getJid());
            }
            if (destroy.getReason() != null) {
                out.writeStartElement("reason");
                out.writeCharacters(destroy.getReason());
                out.writeEndElement();
            }
            out.writeEndElement();
        }
        if ((statusList = mucUser.getStatus()) != null) {
            for (MucStatus status : statusList) {
                out.writeStartElement("status");
                out.writeAttribute("code", String.valueOf(status.getCode()));
                out.writeEndElement();
            }
        }
        out.writeEndElement();
    }

    private void toXml(XmppStreamWriter out, MucUserItem item) throws IOException, XMLStreamException {
        out.writeStartElement("item");
        if (item.getAffiliation() != null) {
            out.writeAttribute("affiliation", item.getAffiliation());
        }
        if (item.getJid() != null) {
            out.writeAttribute("jid", item.getJid());
        }
        if (item.getNick() != null) {
            out.writeAttribute("nick", item.getNick());
        }
        if (item.getRole() != null) {
            out.writeAttribute("role", item.getRole());
        }
        if (item.getActor() != null) {
            out.writeStartElement("actor");
            out.writeAttribute("jid", item.getActor());
            out.writeEndElement();
        }
        if (item.getReason() != null) {
            out.writeStartElement("reason");
            out.writeCharacters(item.getReason());
            out.writeEndElement();
        }
        out.writeEndElement();
    }

    public Serializable fromXml(XmppStreamReader in) throws IOException, XMLStreamException {
        boolean isFinest = log.isLoggable(Level.FINEST);
        int tag = in.nextTag();
        MucUserQuery mucUser = new MucUserQuery();
        ArrayList<MucInvite> inviteList = new ArrayList<MucInvite>();
        ArrayList<MucStatus> statusList = new ArrayList<MucStatus>();
        while (tag > 0) {
            if (isFinest) {
                this.debug(in);
            }
            if (2 == tag) {
                mucUser.setInviteList(inviteList);
                mucUser.setStatusList(statusList);
                return mucUser;
            }
            if (1 == tag && "decline".equals(in.getLocalName())) {
                mucUser.setDecline(this.parseDecline(in));
            } else if (1 == tag && "destroy".equals(in.getLocalName())) {
                mucUser.setDestroy(this.parseDestroy(in));
            } else if (1 == tag && "invite".equals(in.getLocalName())) {
                inviteList.add(this.parseInvite(in));
            } else if (1 == tag && "item".equals(in.getLocalName())) {
                mucUser.setItem(this.parseItem(in));
            } else if (1 == tag && "status".equals(in.getLocalName())) {
                statusList.add(this.parseStatus(in));
            }
            tag = in.nextTag();
        }
        return null;
    }

    public MucInvite parseInvite(XMLStreamReader in) throws IOException, XMLStreamException {
        String to = in.getAttributeValue(null, "to");
        String from = in.getAttributeValue(null, "from");
        String reason = null;
        int tag = in.nextTag();
        while (tag > 0) {
            if (_isFinest) {
                this.debug(in);
            }
            if (2 == tag) {
                return new MucInvite(to, from, reason);
            }
            if (1 == tag && "reason".equals(in.getLocalName())) {
                reason = in.getElementText();
                this.skipToEnd(in, "reason");
            }
            tag = in.nextTag();
        }
        return null;
    }

    public MucDecline parseDecline(XMLStreamReader in) throws IOException, XMLStreamException {
        String to = in.getAttributeValue(null, "to");
        String from = in.getAttributeValue(null, "from");
        String reason = null;
        int tag = in.nextTag();
        while (tag > 0) {
            if (_isFinest) {
                this.debug(in);
            }
            if (2 == tag) {
                return new MucDecline(to, from, reason);
            }
            if (1 == tag && "reason".equals(in.getLocalName())) {
                reason = in.getElementText();
                this.skipToEnd(in, "reason");
            }
            tag = in.nextTag();
        }
        return null;
    }

    public MucDestroy parseDestroy(XMLStreamReader in) throws IOException, XMLStreamException {
        String jid = in.getAttributeValue(null, "jid");
        String reason = null;
        int tag = in.nextTag();
        while (tag > 0) {
            if (_isFinest) {
                this.debug(in);
            }
            if (2 == tag) {
                return new MucDestroy(jid, reason);
            }
            if (1 == tag && "reason".equals(in.getLocalName())) {
                reason = in.getElementText();
                this.skipToEnd(in, "reason");
            }
            tag = in.nextTag();
        }
        return null;
    }

    private MucUserItem parseItem(XMLStreamReader in) throws IOException, XMLStreamException {
        String affiliation = in.getAttributeValue(null, "affiliation");
        String jid = in.getAttributeValue(null, "jid");
        String nick = in.getAttributeValue(null, "nick");
        String role = in.getAttributeValue(null, "role");
        MucUserItem item = new MucUserItem();
        if (affiliation != null) {
            item.setAffiliation(affiliation);
        }
        if (jid != null) {
            item.setJid(jid);
        }
        if (nick != null) {
            item.setNick(nick);
        }
        if (role != null) {
            item.setRole(role);
        }
        int tag = in.nextTag();
        while (tag > 0) {
            if (_isFinest) {
                this.debug(in);
            }
            if (2 == tag) {
                return item;
            }
            if (1 == tag && "actor".equals(in.getLocalName())) {
                item.setActor(in.getAttributeValue(null, "jid"));
                this.skipToEnd(in, "actor");
            } else if (1 == tag && "continue".equals(in.getLocalName())) {
                String thread = in.getAttributeValue(null, "thread");
                item.setContinue(new MucContinue(thread));
                this.skipToEnd(in, "continue");
            } else if (1 == tag && "reason".equals(in.getLocalName())) {
                item.setReason(in.getElementText());
                this.skipToEnd(in, "reason");
            }
            tag = in.nextTag();
        }
        return null;
    }

    public MucStatus parseStatus(XMLStreamReader in) throws IOException, XMLStreamException {
        String codeString = in.getAttributeValue(null, "code");
        int code = 0;
        if (codeString != null) {
            code = Integer.parseInt(codeString);
        }
        int tag = in.nextTag();
        while (tag > 0) {
            if (_isFinest) {
                this.debug(in);
            }
            if (2 == tag) {
                return new MucStatus(code);
            }
            tag = in.nextTag();
        }
        return null;
    }
}

