/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xmpp.pubsub;

import com.caucho.xmpp.pubsub.PubSubItem;
import com.caucho.xmpp.pubsub.PubSubQuery;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PubSubItemsQuery
extends PubSubQuery {
    private int _maxItems;
    private String _node;
    private String _subid;
    private PubSubItem[] _items;

    public PubSubItemsQuery() {
    }

    public PubSubItemsQuery(String node) {
        this._node = node;
    }

    public PubSubItemsQuery(String node, String subid, int maxItems) {
        this._node = node;
        this._subid = subid;
        this._maxItems = maxItems;
    }

    public String getNode() {
        return this._node;
    }

    public String getSubid() {
        return this._subid;
    }

    public int getMaxItems() {
        return this._maxItems;
    }

    public PubSubItem[] getItems() {
        return this._items;
    }

    public void setItems(PubSubItem[] items) {
        this._items = items;
    }

    public void setItemList(ArrayList<PubSubItem> itemList) {
        if (itemList != null && itemList.size() > 0) {
            this._items = new PubSubItem[itemList.size()];
            itemList.toArray(this._items);
        } else {
            this._items = null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        if (this._node != null) {
            sb.append("node=").append(this._node);
        }
        if (this._subid != null) {
            sb.append(",subid=").append(this._subid);
        }
        if (this._maxItems > 0) {
            sb.append(",max-items=").append(this._maxItems);
        }
        if (this._items != null) {
            for (PubSubItem item : this._items) {
                sb.append(",item=").append(item);
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

