/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xmpp.pubsub;

import com.caucho.xmpp.AbstractXmppMarshal;
import com.caucho.xmpp.XmppStreamReader;
import com.caucho.xmpp.XmppStreamWriter;
import com.caucho.xmpp.pubsub.PubSubItem;
import com.caucho.xmpp.pubsub.PubSubItemsQuery;
import com.caucho.xmpp.pubsub.PubSubOptions;
import com.caucho.xmpp.pubsub.PubSubPublishQuery;
import com.caucho.xmpp.pubsub.PubSubQuery;
import com.caucho.xmpp.pubsub.PubSubSubscribeQuery;
import com.caucho.xmpp.pubsub.PubSubUnsubscribeQuery;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;

public class XmppPubSubQueryMarshal
extends AbstractXmppMarshal {
    private static final Logger log = Logger.getLogger(XmppPubSubQueryMarshal.class.getName());
    private static final boolean _isFinest = log.isLoggable(Level.FINEST);

    public String getNamespaceURI() {
        return "http://jabber.org/protocol/pubsub";
    }

    public String getLocalName() {
        return "pubsub";
    }

    public String getClassName() {
        return null;
    }

    public void toXml(XmppStreamWriter out, Serializable object) throws IOException, XMLStreamException {
        throw new UnsupportedOperationException();
    }

    public Serializable fromXml(XmppStreamReader in) throws IOException, XMLStreamException {
        boolean isFinest = log.isLoggable(Level.FINEST);
        PubSubQuery query = null;
        int tag = in.nextTag();
        while (tag > 0) {
            if (isFinest) {
                this.debug(in);
            }
            if (2 == tag) {
                return query;
            }
            if (1 == tag && "options".equals(in.getLocalName())) {
                PubSubOptions options = this.parseOptions(in);
                if (query instanceof PubSubSubscribeQuery) {
                    PubSubSubscribeQuery subscribe = (PubSubSubscribeQuery)query;
                    subscribe.setOptions(options);
                } else {
                    log.fine(this + " options with no subscribe: " + query);
                }
            } else if (1 == tag && "items".equals(in.getLocalName())) {
                query = this.parseItems(in);
            } else if (1 == tag && "publish".equals(in.getLocalName())) {
                query = this.parsePublish(in);
            } else if (1 == tag && "subscribe".equals(in.getLocalName())) {
                query = this.parseSubscribe(in);
            } else if (1 == tag && "unsubscribe".equals(in.getLocalName())) {
                query = this.parseUnsubscribe(in);
            } else if (1 == tag) {
                log.finer(this + " <" + in.getLocalName() + "> is an unknown tag");
                this.skipToEnd(in, in.getLocalName());
            }
            tag = in.nextTag();
        }
        return null;
    }

    public PubSubItemsQuery parseItems(XmppStreamReader in) throws IOException, XMLStreamException {
        String node = in.getAttributeValue(null, "node");
        String subid = in.getAttributeValue(null, "subid");
        String maxItemsString = in.getAttributeValue(null, "max-items");
        int maxItems = 0;
        if (maxItemsString != null) {
            maxItems = Integer.parseInt(maxItemsString);
        }
        PubSubItemsQuery items = new PubSubItemsQuery(node, subid, maxItems);
        ArrayList<PubSubItem> itemList = new ArrayList<PubSubItem>();
        int tag = in.nextTag();
        while (tag > 0) {
            if (_isFinest) {
                this.debug(in);
            }
            if (2 == tag) {
                items.setItemList(itemList);
                return items;
            }
            if (1 == tag && "item".equals(in.getLocalName())) {
                itemList.add(this.parseItem(in));
            } else if (1 == tag) {
                log.finer(this + " <" + in.getLocalName() + "> is an unknown tag");
                this.skipToEnd(in, in.getLocalName());
            }
            tag = in.nextTag();
        }
        this.skipToEnd(in, "items");
        return items;
    }

    public PubSubPublishQuery parsePublish(XmppStreamReader in) throws IOException, XMLStreamException {
        String node = in.getAttributeValue(null, "node");
        PubSubPublishQuery pubsub = new PubSubPublishQuery(node);
        int tag = in.nextTag();
        while (tag > 0) {
            if (_isFinest) {
                this.debug(in);
            }
            if (2 == tag) {
                return pubsub;
            }
            if (1 == tag && "item".equals(in.getLocalName())) {
                pubsub.setItem(this.parseItem(in));
            } else if (1 == tag) {
                log.finer(this + " <" + in.getLocalName() + "> is an unknown tag");
                this.skipToEnd(in, in.getLocalName());
            }
            tag = in.nextTag();
        }
        this.skipToEnd(in, "publish");
        return pubsub;
    }

    public PubSubSubscribeQuery parseSubscribe(XmppStreamReader in) throws IOException, XMLStreamException {
        String jid = in.getAttributeValue(null, "jid");
        String node = in.getAttributeValue(null, "node");
        PubSubSubscribeQuery subscribe = new PubSubSubscribeQuery(jid, node);
        this.skipToEnd(in, "subscribe");
        return subscribe;
    }

    public PubSubUnsubscribeQuery parseUnsubscribe(XmppStreamReader in) throws IOException, XMLStreamException {
        String jid = in.getAttributeValue(null, "jid");
        String node = in.getAttributeValue(null, "node");
        String subid = in.getAttributeValue(null, "subid");
        PubSubUnsubscribeQuery unsubscribe = new PubSubUnsubscribeQuery(jid, node, subid);
        this.skipToEnd(in, "unsubscribe");
        return unsubscribe;
    }

    public PubSubOptions parseOptions(XmppStreamReader in) throws IOException, XMLStreamException {
        String jid = in.getAttributeValue(null, "jid");
        String node = in.getAttributeValue(null, "node");
        String subid = in.getAttributeValue(null, "subid");
        PubSubOptions options = new PubSubOptions(jid, node, subid);
        this.skipToEnd(in, "options");
        return options;
    }

    private PubSubItem parseItem(XmppStreamReader in) throws IOException, XMLStreamException {
        String id = in.getAttributeValue(null, "id");
        PubSubItem item = new PubSubItem((Serializable)((Object)id));
        int tag = in.next();
        Serializable value = in.readValue();
        item.setValue(value);
        this.skipToEnd(in, "item");
        return item;
    }
}

