/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl;

import com.caucho.util.CharBuffer;
import com.caucho.util.IntArray;
import com.caucho.xsl.XslWriter;
import java.util.ArrayList;

public class XslNumberFormat {
    private String head;
    private String tail;
    private String[] separators;
    private int[] formats;
    private int[] zeroSize;
    private String format;
    private String lang;
    private boolean isAlphabetic;
    private String groupSeparator;
    private int groupSize;

    public XslNumberFormat(String format, String lang, boolean isAlphabetic, String groupSeparator, int groupSize) {
        this.format = format;
        this.lang = lang;
        this.isAlphabetic = isAlphabetic;
        if (groupSize <= 0) {
            groupSize = 3;
            groupSeparator = "";
        }
        if (groupSeparator == null) {
            groupSeparator = "";
        }
        this.groupSeparator = groupSeparator;
        this.groupSize = groupSize;
        if (format == null) {
            format = "1";
        }
        int headIndex = format.length();
        ArrayList<String> separators = new ArrayList<String>();
        IntArray zeroSizes = new IntArray();
        IntArray formats = new IntArray();
        CharBuffer cb = new CharBuffer();
        int i = 0;
        while (i < format.length()) {
            char ch;
            cb.clear();
            while (i < format.length() && !Character.isLetterOrDigit(ch = format.charAt(i))) {
                cb.append(ch);
                ++i;
            }
            if (this.head == null) {
                this.head = cb.toString();
            } else if (i >= format.length()) {
                this.tail = cb.toString();
            } else {
                separators.add(cb.toString());
            }
            if (i >= format.length()) break;
            int zeroSize = 1;
            int code = 48;
            while (i < format.length() && Character.isLetterOrDigit(ch = format.charAt(i))) {
                if (!Character.isDigit(ch)) {
                    code = code != 48 || zeroSize != 1 ? 0 : (int)ch;
                } else if (Character.digit(ch, 10) == 0 && zeroSize >= 0) {
                    ++zeroSize;
                } else {
                    code = Character.digit(ch, 10) == 1 ? ch - '\u0001' : 0;
                }
                ++i;
            }
            if (code == 0) {
                code = 48;
            }
            zeroSizes.add(zeroSize);
            formats.add(code);
        }
        if (formats.size() == 0) {
            this.tail = this.head;
            this.head = "";
            formats.add(48);
            zeroSizes.add(0);
        }
        if (separators.size() == 0) {
            separators.add(".");
        }
        if (separators.size() < formats.size()) {
            separators.add((String)separators.get(separators.size() - 1));
        }
        this.separators = separators.toArray(new String[separators.size()]);
        this.zeroSize = zeroSizes.toArray();
        this.formats = formats.toArray();
        if (this.head == null) {
            this.head = "";
        }
        if (this.tail == null) {
            this.tail = "";
        }
    }

    public String getFormat() {
        return this.format;
    }

    public String getLang() {
        return this.lang;
    }

    public boolean isAlphabetic() {
        return this.isAlphabetic;
    }

    public String getGroupSeparator() {
        return this.groupSeparator;
    }

    public int getGroupSize() {
        return this.groupSize;
    }

    void format(XslWriter out, IntArray numbers) {
        CharBuffer buf = new CharBuffer();
        buf.append(this.head);
        for (int i = numbers.size() - 1; i >= 0; --i) {
            int index = numbers.size() - i - 1;
            if (index >= this.formats.length) {
                index = this.formats.length - 1;
            }
            char code = (char)this.formats[index];
            int zeroCount = this.zeroSize[index];
            int count = numbers.get(i);
            switch (code) {
                case 'i': {
                    this.romanize(buf, "mdclxvi", count);
                    break;
                }
                case 'I': {
                    this.romanize(buf, "MDCLXVI", count);
                    break;
                }
                case 'a': {
                    this.formatAlpha(buf, 'a', count);
                    break;
                }
                case 'A': {
                    this.formatAlpha(buf, 'A', count);
                    break;
                }
                default: {
                    this.formatDecimal(buf, code, zeroCount, count);
                }
            }
            if (i <= 0) continue;
            buf.append(this.separators[index]);
        }
        buf.append(this.tail);
        out.print(buf.toString());
    }

    private void romanize(CharBuffer cb, String xvi, int count) {
        if (count <= 0) {
            throw new RuntimeException();
        }
        if (count > 5000) {
            cb.append(count);
            return;
        }
        while (count > 1000) {
            cb.append(xvi.charAt(0));
            count -= 1000;
        }
        this.romanize(cb, xvi.charAt(0), xvi.charAt(1), xvi.charAt(2), count / 100);
        this.romanize(cb, xvi.charAt(2), xvi.charAt(3), xvi.charAt(4), (count %= 100) / 10);
        this.romanize(cb, xvi.charAt(4), xvi.charAt(5), xvi.charAt(6), count %= 10);
    }

    private void romanize(CharBuffer cb, char x, char v, char i, int count) {
        switch (count) {
            case 0: {
                break;
            }
            case 1: {
                cb.append(i);
                break;
            }
            case 2: {
                cb.append(i);
                cb.append(i);
                break;
            }
            case 3: {
                cb.append(i);
                cb.append(i);
                cb.append(i);
                break;
            }
            case 4: {
                cb.append(i);
                cb.append(v);
                break;
            }
            case 5: {
                cb.append(v);
                break;
            }
            case 6: {
                cb.append(v);
                cb.append(i);
                break;
            }
            case 7: {
                cb.append(v);
                cb.append(i);
                cb.append(i);
                break;
            }
            case 8: {
                cb.append(v);
                cb.append(i);
                cb.append(i);
                cb.append(i);
                break;
            }
            case 9: {
                cb.append(i);
                cb.append(x);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    private void formatAlpha(CharBuffer cb, char a, int count) {
        if (count <= 0) {
            throw new RuntimeException();
        }
        int index = cb.length();
        while (count > 0) {
            cb.insert(index, (char)(a + --count % 26));
            count /= 26;
        }
    }

    private void formatDecimal(CharBuffer cb, int code, int zeroCount, int count) {
        int digits = 0;
        int index = cb.length();
        while (count > 0) {
            if (digits > 0 && digits % this.groupSize == 0) {
                cb.insert(index, this.groupSeparator);
            }
            cb.insert(index, (char)(code + count % 10));
            count /= 10;
            ++digits;
        }
        while (cb.length() - index < zeroCount) {
            cb.insert(index, (char)code);
        }
    }
}

