/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl;

import com.caucho.util.CharBuffer;
import com.caucho.util.CharCursor;
import com.caucho.util.CharScanner;
import com.caucho.util.L10N;
import com.caucho.util.StringCharCursor;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.xml.CauchoNode;
import com.caucho.xml.QAbstractNode;
import com.caucho.xml.QDocument;
import com.caucho.xml.QElement;
import com.caucho.xml.QName;
import com.caucho.xml.QNode;
import com.caucho.xml.Xml;
import com.caucho.xml.XmlChar;
import com.caucho.xml.XmlUtil;
import com.caucho.xsl.XslParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

class XslParser {
    private static final Logger log = Logger.getLogger(XslParser.class.getName());
    static final L10N L = new L10N(XslParser.class);
    private static final String XSLNS = "http://www.w3.org/1999/XSL/Transform";
    private static final String XTPNS = "http://www.caucho.com/XTP/1.0";
    static final String XMLNS = "http://www.w3.org/2000/xmlns/";
    static HashMap<String, String> _xslCommands = new HashMap();
    static HashMap<String, String> _xtpCommands;
    public boolean strictXsl;
    boolean rawText;
    int line;
    int textLine;
    ReadStream is;
    CharBuffer tag = new CharBuffer();
    CharBuffer text = new CharBuffer();
    QDocument xsl;
    private int peek = -1;
    private boolean seenCr;
    private String defaultMode;
    private HashMap<String, String> _namespaces;
    private HashMap macros = new HashMap();
    private boolean inTemplate;
    private CharScanner wsScanner = new CharScanner(" \t");
    private CharScanner delimScanner = new CharScanner(" \t;=");

    XslParser() {
    }

    Document parse(ReadStream is) throws IOException, XslParseException {
        Element out;
        this.is = is;
        this.line = 1;
        this.defaultMode = null;
        this.xsl = (QDocument)Xml.createDocument();
        if (is.getPath().getLastModified() > 0L) {
            ArrayList<Path> depends = new ArrayList<Path>();
            depends.add(is.getPath());
            this.xsl.setProperty("caucho.depends", depends);
        }
        this.xsl.setRootFilename(is.getPath().getURL());
        this._namespaces = new HashMap();
        QNode top = (QNode)((Object)this.xsl.createDocumentFragment());
        top.setLocation(is.getPath().getURL(), is.getUserPath(), this.line, 0);
        this.rawText = false;
        String encoding = null;
        int ch = this.read();
        if (ch == 239) {
            ch = this.read();
            if (ch != 187) {
                this.peek = 187;
                ch = 239;
            } else {
                ch = this.read();
                if (ch != 191) {
                    throw this.error(L.l("Expected 0xbf in UTF-8 header"));
                }
                is.setEncoding("UTF-8");
                ch = this.read();
            }
        }
        if (ch == 60) {
            ch = this.read();
            if (ch == 63) {
                ProcessingInstruction pi = this.parsePi();
                if (pi.getNodeName().equals("xml")) {
                    encoding = XmlUtil.getPIAttribute(pi.getNodeValue(), "encoding");
                    if (encoding != null) {
                        is.setEncoding(encoding);
                    }
                } else {
                    top.appendChild(pi);
                }
                ch = this.read();
            } else {
                this.peek = ch;
                ch = 60;
            }
        }
        this.parseNode(top, "", true, ch);
        QElement elt = null;
        for (Node node = top.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !node.getNodeName().equals("xsl:stylesheet")) continue;
            if (elt != null) {
                throw this.error(L.l("xsl:stylesheet must be sole top element"));
            }
            elt = (QElement)node;
        }
        if (elt == null) {
            elt = (QElement)this.xsl.createElementNS(XSLNS, "xsl:stylesheet");
            elt.setAttribute("version", "1.0");
            elt.setLocation(is.getURL(), is.getUserPath(), 1, 0);
            elt.setAttribute("resin:stylescript", "true");
            out = this.xsl.createElementNS(XSLNS, "xsl:output");
            elt.appendChild(out);
            elt.appendChild(top);
        }
        if (encoding != null) {
            out = this.xsl.createElementNS(XSLNS, "xsl:output");
            out.setAttribute("encoding", encoding);
            elt.insertBefore(out, elt.getFirstChild());
        }
        this.xsl.appendChild(elt);
        return this.xsl;
    }

    private void parseNode(Node parent, String tagEnd, boolean isSpecial, int ch) throws IOException, XslParseException {
        boolean hasContent = false;
        this.text.clear();
        if (tagEnd == ">>" && (ch == 10 || ch == 13)) {
            ch = this.read();
        }
        block8: while (ch >= 0) {
            switch (ch) {
                case 92: {
                    hasContent = true;
                    ch = this.read();
                    if (ch == 60) {
                        this.addText('<');
                        ch = this.read();
                        continue block8;
                    }
                    this.addText('\\');
                    continue block8;
                }
                case 60: {
                    String tag;
                    hasContent = true;
                    ch = this.read();
                    if (ch == 47) {
                        ch = this.readTag(this.read());
                        tag = this.tag.toString();
                        if (tag.equals(tagEnd)) {
                            if ((ch = this.skipWhitespace(ch)) != 62) {
                                throw this.error(L.l("expected `{0}' at {1}", (Object)">", this.badChar(ch)));
                            }
                            this.addText(parent);
                            if (tag.equals("xsl:template")) {
                                this.inTemplate = false;
                            }
                            return;
                        }
                        if (this.rawText) {
                            this.addText("</" + tag + ">");
                            ch = this.read();
                            continue block8;
                        }
                        throw this.error(L.l("`</{0}>' has no matching open tag", tag));
                    }
                    if (ch == 35) {
                        this.addText(parent);
                        ch = this.parseScriptlet(parent);
                        continue block8;
                    }
                    if (ch == 63) {
                        this.addText(parent);
                        ProcessingInstruction pi = this.parsePi();
                        parent.appendChild(pi);
                        ch = this.read();
                        continue block8;
                    }
                    if (ch == 33) {
                        this.addText(parent);
                        ch = this.parseDecl(parent);
                        continue block8;
                    }
                    if (ch == 123) {
                        this.addText(parent);
                        this.parseValueOf(parent);
                        ch = this.read();
                        continue block8;
                    }
                    ch = this.readTag(ch);
                    tag = this.tag.toString();
                    if (!this.rawText && !tag.equals("") || tag.startsWith("xsl:") || tag.startsWith("jsp:") || tag.startsWith("xtp:") || this.macros.get(tag) != null) {
                        this.addText(parent);
                        this.parseElement(parent, tag, ch, isSpecial);
                        ch = this.read();
                        continue block8;
                    }
                    this.addText("<");
                    this.addText(tag);
                    continue block8;
                }
                case 62: {
                    Element elt;
                    int ch1 = this.read();
                    if (ch1 == 62 && tagEnd == ">>") {
                        if (this.text.length() > 0 && this.text.charAt(this.text.length() - 1) == '\n') {
                            this.text.setLength(this.text.length() - 1);
                        }
                        if (this.text.length() > 0 && this.text.charAt(this.text.length() - 1) == '\r') {
                            this.text.setLength(this.text.length() - 1);
                        }
                        if (!hasContent) {
                            elt = this.xsl.createElementNS(XSLNS, "xsl:text");
                            parent.appendChild(elt);
                            this.addText(elt);
                        } else {
                            this.addText(parent);
                        }
                        return;
                    }
                    hasContent = true;
                    this.addText('>');
                    ch = ch1;
                    continue block8;
                }
                case 36: {
                    Element elt;
                    hasContent = true;
                    ch = this.read();
                    if (ch == 36) {
                        this.addText('$');
                        ch = this.read();
                        continue block8;
                    }
                    if (ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90) {
                        String name = this.parseName(ch);
                        this.addText(parent);
                        this.text.clear();
                        ch = this.parseExtension(parent, name);
                        continue block8;
                    }
                    if (ch == 40) {
                        this.addText(parent);
                        elt = this.xsl.createElementNS(XSLNS, "xsl:value-of");
                        CharBuffer test = CharBuffer.allocate();
                        this.lexToRparen(test);
                        elt.setAttribute("select", test.close());
                        parent.appendChild(elt);
                        ch = this.read();
                        continue block8;
                    }
                    this.addText('$');
                    ch = this.read();
                    continue block8;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    this.addText((char)ch);
                    ch = this.read();
                    continue block8;
                }
                case 38: {
                    ch = this.parseEntityReference();
                    continue block8;
                }
            }
            hasContent = true;
            if (isSpecial) {
                this.parseSpecial(parent, ch);
                ch = this.read();
                continue;
            }
            this.addText((char)ch);
            ch = this.read();
        }
        this.addText(parent);
        if (!tagEnd.equals("")) {
            throw this.error(L.l("expected close of `{0}' (open at {1})", (Object)tagEnd, ((CauchoNode)parent).getLine()));
        }
    }

    private Element parseElement(Node parent, String name, int ch, boolean isSpecial) throws IOException, XslParseException {
        HashMap<String, String> oldNamespaces = this._namespaces;
        QElement element = null;
        int p = name.indexOf(58);
        if (p >= 0) {
            String prefix = name.substring(0, p);
            String uri = this._namespaces.get(prefix);
            if (uri != null) {
                element = (QElement)this.xsl.createElementNS(uri, name);
            } else if (prefix.equals("xsl")) {
                element = (QElement)this.xsl.createElementNS(XSLNS, name);
            }
        }
        try {
            if (element == null) {
                element = (QElement)this.xsl.createElement(name);
            }
        }
        catch (DOMException e) {
            throw this.error(e);
        }
        element.setLocation(this.is.getURL(), this.is.getUserPath(), this.line, 0);
        ch = this.parseAttributes(null, element, ch, false);
        if (name.equals("xsl:stylesheet") && element.getAttribute("parsed-content").equals("false")) {
            this.rawText = true;
            Element child = this.xsl.createElementNS(XSLNS, "xsl:output");
            child.setAttribute("disable-output-escaping", "yes");
            element.appendChild(child);
        }
        if (this.rawText && (name.startsWith("xsl") || name.startsWith("xtp")) && element.getAttribute("xml:space").equals("")) {
            element.setAttribute("xml:space", "default");
        }
        if (name.equals("xsl:template")) {
            this.inTemplate = true;
            String macroName = element.getAttribute("name");
            if (!macroName.equals("")) {
                this.macros.put(macroName, macroName);
            }
        }
        String oldMode = this.defaultMode;
        if (name.equals("xtp:mode")) {
            this.defaultMode = element.getAttribute("mode");
        } else {
            parent.appendChild(element);
            parent = element;
        }
        if (ch == 62) {
            this.parseNode(parent, name, isSpecial && name.equals("xsl:stylesheet"), this.read());
        } else if (ch == 47) {
            ch = this.read();
            if (ch != 62) {
                throw this.error(L.l("expected `{0}' at {1}", (Object)">", this.badChar(ch)));
            }
        } else {
            throw this.error(L.l("expected `{0}' at {1}", (Object)">", this.badChar(ch)));
        }
        this.defaultMode = oldMode;
        this._namespaces = oldNamespaces;
        return element;
    }

    private int parseEntityReference() throws IOException, XslParseException {
        int ch = this.read();
        if (ch == 35) {
            int code = 0;
            ch = this.read();
            if (ch == 120) {
                ch = this.read();
                while (ch > 0 && ch != 59) {
                    if (ch >= 48 && ch <= 57) {
                        code = 16 * code + ch - 48;
                    } else if (ch >= 97 && ch <= 102) {
                        code = 16 * code + ch - 97 + 10;
                    } else {
                        if (ch < 65 || ch > 70) break;
                        code = 16 * code + ch - 65 + 10;
                    }
                    ch = this.read();
                }
                if (ch == 59) {
                    this.addText((char)code);
                    return this.read();
                }
                this.addText("&#x");
                this.addText(String.valueOf(code));
                return ch;
            }
            while (ch >= 48 && ch <= 57) {
                code = 10 * code + ch - 48;
                ch = this.read();
            }
            if (ch == 59) {
                this.addText((char)code);
                return this.read();
            }
            this.addText("&#");
            this.addText(String.valueOf(code));
            return ch;
        }
        CharBuffer cb = CharBuffer.allocate();
        while (ch >= 97 && ch <= 122) {
            cb.append((char)ch);
            ch = this.read();
        }
        if (ch != 59) {
            this.addText('&');
            this.addText(cb.close());
        } else {
            if (cb.matches("lt")) {
                this.addText('<');
                return this.read();
            }
            if (cb.matches("gt")) {
                this.addText('>');
                return this.read();
            }
            if (cb.matches("amp")) {
                this.addText('&');
                return this.read();
            }
            if (cb.matches("quot")) {
                this.addText('\"');
                return this.read();
            }
            if (cb.matches("apos")) {
                this.addText('\'');
                return this.read();
            }
            this.addText('&');
            this.addText(cb.close());
        }
        return ch;
    }

    private int parseScriptlet(Node parent) throws IOException, XslParseException {
        QNode node;
        String filename = this.is.getUserPath();
        int line = this.line;
        int ch = this.read();
        if (ch == 61) {
            node = (QNode)((Object)this.xsl.createElementNS(XTPNS, "xtp:expression"));
            ch = this.read();
        } else if (ch == 33) {
            node = (QNode)((Object)this.xsl.createElementNS(XTPNS, "xtp:declaration"));
            ch = this.read();
        } else {
            if (ch == 64) {
                this.parseDirective(parent);
                return this.read();
            }
            node = (QNode)((Object)this.xsl.createElementNS(XTPNS, "xtp:scriptlet"));
        }
        node.setLocation(this.is.getURL(), this.is.getUserPath(), line, 0);
        parent.appendChild(node);
        this.text.clear();
        while (ch >= 0) {
            if (ch == 35) {
                ch = this.read();
                if (ch == 62) break;
                this.addText('#');
                continue;
            }
            this.addText((char)ch);
            ch = this.read();
        }
        node.appendChild(this.xsl.createTextNode(this.text.toString()));
        this.text.clear();
        return this.read();
    }

    private void parseDirective(Node parent) throws IOException, XslParseException {
        String contentType;
        int ch = this.skipWhitespace(this.read());
        ch = this.readTag(ch);
        String name = this.tag.toString();
        if (!name.equals("page") && !name.equals("cache")) {
            throw this.error(L.l("unknown directive `{0}'", name));
        }
        QElement elt = (QElement)this.xsl.createElementNS(XTPNS, "xtp:directive." + name);
        elt.setLocation(this.is.getURL(), this.is.getUserPath(), this.line, 0);
        parent.appendChild(elt);
        ch = this.parseAttributes(parent, elt, ch, true);
        if (ch != 35) {
            throw this.error(L.l("expected `{0}' at {1}", (Object)"#", this.badChar(ch)));
        }
        ch = this.read();
        if (ch != 62) {
            throw this.error(L.l("expected `{0}' at {1}", (Object)">", this.badChar(ch)));
        }
        if (name.equals("page") && !(contentType = elt.getAttribute("contentType")).equals("")) {
            this.parseContentType(parent, contentType);
        }
    }

    private int parseStatement(Node parent, int ch) throws IOException, XslParseException {
        if ((ch = this.skipWhitespace(ch)) == 36) {
            ch = this.read();
            if (XmlChar.isNameStart(ch)) {
                String name = this.parseName(ch);
                return this.parseExtension(parent, name);
            }
            if (ch == 40) {
                Element elt = this.xsl.createElementNS(XSLNS, "xsl:value-of");
                CharBuffer test = CharBuffer.allocate();
                this.lexToRparen(test);
                elt.setAttribute("select", test.close());
                parent.appendChild(elt);
                return this.read();
            }
            throw this.error(L.l("expected statement at {0}", this.badChar(ch)));
        }
        if (ch == 60) {
            this.parseBlock(parent, ch);
            return this.read();
        }
        if (ch == 59) {
            return this.read();
        }
        throw this.error(L.l("expected statement at {0}", this.badChar(ch)));
    }

    private int parseExtension(Node parent, String name) throws IOException, XslParseException {
        int ch = this.read();
        if (name.equals("if")) {
            return this.parseIf(parent, ch);
        }
        String arg = _xslCommands.get(name);
        if (arg != null) {
            QElement elt = (QElement)this.xsl.createElementNS(XSLNS, "xsl:" + name);
            elt.setLocation(this.is.getURL(), this.is.getUserPath(), this.line, 0);
            parent.appendChild(elt);
            ch = this.skipWhitespace(ch);
            if (ch == 40) {
                this.parseArgs(elt, arg);
                ch = this.skipWhitespace(this.read());
            }
            return this.parseStatement(elt, ch);
        }
        arg = _xtpCommands.get(name);
        if (arg != null) {
            QElement elt = (QElement)this.xsl.createElement("xtp:" + name);
            elt.setLocation(this.is.getURL(), this.is.getUserPath(), this.line, 0);
            parent.appendChild(elt);
            ch = this.skipWhitespace(ch);
            if (ch == 40) {
                this.parseArgs(elt, arg);
                ch = this.skipWhitespace(this.read());
            }
            return this.parseStatement(elt, ch);
        }
        if ((ch = this.skipWhitespace(ch)) == 61) {
            QElement elt = (QElement)this.xsl.createElement("xtp:assign");
            elt.setLocation(this.is.getURL(), this.is.getUserPath(), this.line, 0);
            elt.setAttribute("name", name.intern());
            parent.appendChild(elt);
            ch = this.skipWhitespace(this.read());
            if (ch != 36) {
                return this.parseStatement(elt, ch);
            }
            ch = this.read();
            if (ch != 40) {
                this.peek = ch;
                return this.parseStatement(elt, ch);
            }
            CharBuffer test = CharBuffer.allocate();
            this.lexToRparen(test);
            elt.setAttribute("select", test.close());
            return this.read();
        }
        QElement elt = (QElement)this.xsl.createElement(name);
        elt.setLocation(this.is.getURL(), this.is.getUserPath(), this.line, 0);
        parent.appendChild(elt);
        if (ch == 40) {
            this.parseArgs(elt, arg);
            ch = this.skipWhitespace(this.read());
        }
        return this.parseStatement(elt, ch);
    }

    private int parseIf(Node parent, int ch) throws IOException, XslParseException {
        QElement choose = (QElement)this.xsl.createElementNS(XSLNS, "xsl:choose");
        choose.setLocation(this.is.getURL(), this.is.getUserPath(), this.line, 0);
        parent.appendChild(choose);
        while (true) {
            this.lexExpect(ch, 40);
            CharBuffer test = CharBuffer.allocate();
            this.lexToRparen(test);
            QElement elt = (QElement)this.xsl.createElementNS(XSLNS, "xsl:when");
            choose.appendChild(elt);
            elt.setLocation(this.is.getURL(), this.is.getUserPath(), this.line, 0);
            elt.setAttribute("test", test.close());
            ch = this.parseStatement(elt, this.skipWhitespace(this.read()));
            ch = this.skipWhitespace(ch);
            if (ch != 36) {
                return ch;
            }
            ch = this.read();
            if (!XmlChar.isNameStart(ch)) {
                this.peek = ch;
                return 36;
            }
            String name = this.parseName(ch);
            if (!name.equals("else")) {
                return this.parseExtension(parent, name);
            }
            ch = this.skipWhitespace(this.read());
            if (ch == 60) {
                elt = (QElement)this.xsl.createElementNS(XSLNS, "xsl:otherwise");
                choose.appendChild(elt);
                elt.setLocation(this.is.getURL(), this.is.getUserPath(), this.line, 0);
                return this.parseStatement(elt, this.skipWhitespace(ch));
            }
            name = this.parseName(this.read());
            if (!name.equals("if")) {
                throw this.error(L.l("expected $if at `${0}'", name));
            }
            ch = this.read();
        }
    }

    private String parseName(int ch) throws IOException, XslParseException {
        CharBuffer cb = CharBuffer.allocate();
        while (XmlChar.isNameChar(ch)) {
            cb.append((char)ch);
            ch = this.read();
        }
        this.peek = ch;
        return cb.close();
    }

    private void parseArgs(Element elt, String arg) throws IOException, XslParseException {
        CharBuffer cb = CharBuffer.allocate();
        String key = null;
        boolean isFirst = true;
        int ch = this.read();
        while (ch >= 0 && ch != 41) {
            cb.append((char)ch);
            switch (ch) {
                case 40: {
                    this.lexToRparen(cb);
                    cb.append(')');
                    break;
                }
                case 34: 
                case 39: {
                    this.lexString(cb, ch);
                    break;
                }
                case 61: {
                    ch = this.read();
                    if (ch == 62) {
                        cb.setLength(cb.length() - 1);
                        key = cb.toString().trim();
                        cb.clear();
                        break;
                    }
                    this.peek = ch;
                    break;
                }
                case 44: {
                    cb.setLength(cb.length() - 1);
                    if (key != null) {
                        elt.setAttribute(key, cb.toString());
                    } else if (arg != null && isFirst) {
                        elt.setAttribute(arg, cb.toString());
                    } else {
                        throw this.error(L.l("unexpected arg `{0}'", cb));
                    }
                    cb.clear();
                    isFirst = false;
                    key = null;
                }
            }
            ch = this.read();
        }
        if (ch != 41) {
            throw this.error(L.l("expected `{0}' at {1}", (Object)")", this.badChar(ch)));
        }
        if (key != null) {
            elt.setAttribute(key, cb.close());
        } else if (arg != null && cb.length() > 0 && isFirst) {
            elt.setAttribute(arg, cb.close());
        } else if (cb.length() > 0) {
            throw this.error(L.l("unexpected arg `{0}'", cb));
        }
    }

    private void lexToRparen(CharBuffer cb) throws IOException, XslParseException {
        String filename = this.getFilename();
        int line = this.getLine();
        int ch = this.read();
        while (ch >= 0 && ch != 41) {
            cb.append((char)ch);
            switch (ch) {
                case 40: {
                    this.lexToRparen(cb);
                    cb.append(')');
                    break;
                }
                case 34: 
                case 39: {
                    this.lexString(cb, ch);
                }
            }
            ch = this.read();
        }
        if (ch != 41) {
            throw this.error(L.l("expected `{0}' at {1}.  Open at {2}", ")", this.badChar(ch), filename + ":" + line));
        }
    }

    private void lexString(CharBuffer cb, int end) throws IOException, XslParseException {
        int ch = this.read();
        while (ch >= 0 && ch != end) {
            cb.append((char)ch);
            ch = this.read();
        }
        if (ch != end) {
            throw this.error(L.l("expected `{0}' at {1}", (Object)("" + (char)end), this.badChar(ch)));
        }
        cb.append((char)end);
    }

    private void lexExpect(int ch, int match) throws IOException, XslParseException {
        while (XmlChar.isWhitespace((char)ch)) {
            ch = this.read();
        }
        if (ch != match) {
            throw this.error(L.l("expected `{0}' at {1}", (Object)("" + (char)match), this.badChar(ch)));
        }
    }

    private void parseContentType(Node parent, String contentType) throws IOException, XslParseException {
        StringCharCursor cursor = new StringCharCursor(contentType);
        CharBuffer buf = new CharBuffer();
        this.wsScanner.skip(cursor);
        this.delimScanner.scan(cursor, buf);
        if (buf.length() <= 0) {
            return;
        }
        Element output = this.xsl.createElementNS(XSLNS, "xsl:output");
        parent.appendChild(output);
        output.setAttribute("media-type", buf.toString());
        this.delimScanner.skip(cursor);
        buf.clear();
        this.delimScanner.scan(cursor, buf);
        this.wsScanner.skip(cursor);
        if (((CharCursor)cursor).current() == '=' && buf.toString().equals("charset")) {
            this.delimScanner.skip(cursor);
            buf.clear();
            this.delimScanner.scan(cursor, buf);
            if (buf.length() > 0) {
                output.setAttribute("encoding", Encoding.getMimeName(buf.toString()));
                this.is.setEncoding(buf.toString());
            }
        }
    }

    private int parseAttributes(Node parent, Element elt, int ch, boolean isDirective) throws IOException, XslParseException {
        HashMap<String, String> newNamespaces = null;
        ch = this.skipWhitespace(ch);
        while (XmlChar.isNameStart(ch)) {
            ch = this.readTag(ch);
            String name = this.tag.toString();
            ch = this.skipWhitespace(ch);
            String value = null;
            if (ch == 61) {
                ch = this.skipWhitespace(this.read());
                ch = this.readValue(ch);
                ch = this.skipWhitespace(ch);
                value = this.tag.toString();
            }
            if (isDirective && name.equals("import")) {
                Element copy = (Element)elt.cloneNode(false);
                copy.setAttribute(name, value);
                parent.appendChild(copy);
                continue;
            }
            if (name.startsWith("xmlns")) {
                QElement qElt = (QElement)elt;
                if (newNamespaces == null) {
                    newNamespaces = new HashMap<String, String>(this._namespaces);
                    this._namespaces = newNamespaces;
                }
                String prefix = name.startsWith("xmlns:") ? name.substring(6) : "";
                this._namespaces.put(prefix, value);
                qElt.setAttributeNS(XMLNS, name, value);
                if (prefix == "" || !qElt.getNodeName().startsWith(prefix)) continue;
                QDocument doc = this.xsl;
                QName newName = doc.createName(value, qElt.getNodeName());
                qElt.setName(newName);
                continue;
            }
            int p = name.indexOf(58);
            if (p >= 0) {
                String prefix = name.substring(0, p);
                String uri = this._namespaces.get(prefix);
                if (uri != null) {
                    QElement qElt = (QElement)elt;
                    qElt.setAttributeNS(uri, name, value);
                    continue;
                }
                elt.setAttribute(name, value);
                continue;
            }
            elt.setAttribute(name, value);
        }
        return ch;
    }

    private ProcessingInstruction parsePi() throws IOException, XslParseException {
        int ch = this.read();
        if (!XmlChar.isNameStart(ch)) {
            throw this.error(L.l("expected name at {0}", this.badChar(ch)));
        }
        ch = this.readTag(ch);
        String name = this.tag.toString();
        this.text.clear();
        while (ch >= 0) {
            if (ch == 63) {
                ch = this.read();
                if (ch == 62) {
                    ProcessingInstruction pi = this.xsl.createProcessingInstruction(name, this.text.toString());
                    this.text.clear();
                    return pi;
                }
                this.addText('?');
                continue;
            }
            this.addText((char)ch);
            ch = this.read();
        }
        throw this.error(L.l("expected `{0}' at {1}", (Object)">", this.badChar(-1)));
    }

    private int parseDecl(Node parent) throws IOException, XslParseException {
        int ch = this.read();
        if (ch == 91) {
            ch = this.read();
            if (ch != 67) {
                this.addText("<![");
                return ch;
            }
            ch = this.read();
            if (ch != 68) {
                this.addText("<![C");
                return ch;
            }
            ch = this.read();
            if (ch != 65) {
                this.addText("<![CD");
                return ch;
            }
            ch = this.read();
            if (ch != 84) {
                this.addText("<![CDA");
                return ch;
            }
            ch = this.read();
            if (ch != 65) {
                this.addText("<![CDAT");
                return ch;
            }
            ch = this.read();
            if (ch != 91) {
                this.addText("<![CDATA");
                return ch;
            }
            ch = this.read();
            while (ch > 0) {
                if (ch == 93) {
                    ch = this.read();
                    while (ch == 93) {
                        ch = this.read();
                        if (ch == 62) {
                            return this.read();
                        }
                        this.addText(']');
                    }
                    this.addText(']');
                    continue;
                }
                this.addText((char)ch);
                ch = this.read();
            }
            return ch;
        }
        if (ch != 45) {
            this.addText("<!");
            return ch;
        }
        ch = this.read();
        if (ch != 45) {
            this.addText("<!-");
            return ch;
        }
        while (ch >= 0) {
            ch = this.read();
            if (ch != 45) continue;
            ch = this.read();
            while (ch == 45) {
                ch = this.read();
                if (ch != 62) continue;
                return this.read();
            }
        }
        throw this.error(L.l("expected `{0}' at {1}", (Object)"-->", this.badChar(-1)));
    }

    private void parseValueOf(Node parent) throws IOException, XslParseException {
        int ch = this.read();
        while (ch >= 0) {
            if (ch == 125) {
                ch = this.read();
                if (ch == 62) {
                    QElement elt = (QElement)this.xsl.createElementNS(XSLNS, "xsl:value-of");
                    elt.setAttribute("select", this.text.toString());
                    elt.setLocation(this.is.getURL(), this.is.getUserPath(), this.line, 0);
                    parent.appendChild(elt);
                    this.text.clear();
                    return;
                }
                this.addText('}');
                continue;
            }
            this.addText((char)ch);
            ch = this.read();
        }
    }

    private void parseSpecial(Node parent, int ch) throws IOException, XslParseException {
        char tail = '#';
        String element = "xtp:scriptlet";
        this.text.clear();
        String filename = this.is.getUserPath();
        int line = this.line;
        while (ch >= 0) {
            if (ch == 60) {
                filename = this.is.getUserPath();
                line = this.line;
                ch = this.read();
                if (ch == 35) {
                    tail = '#';
                    ch = this.read();
                    if (ch != 61) break;
                    ch = this.read();
                    element = "xtp:expression";
                    break;
                }
                if (ch == 60) {
                    tail = '>';
                    break;
                }
                if (ch != 92) continue;
                this.addText((char)this.read());
                ch = this.read();
                continue;
            }
            this.addText((char)ch);
            ch = this.read();
        }
        while (this.text.length() > 0 && Character.isSpace(this.text.charAt(this.text.length() - 1))) {
            this.text.setLength(this.text.length() - 1);
        }
        QElement template = (QElement)this.xsl.createElementNS(XSLNS, "xsl:template");
        parent.appendChild(template);
        String match = this.text.toString();
        template.setAttribute("match", match);
        boolean isName = true;
        for (int i = 0; i < match.length(); ++i) {
            if (XmlChar.isNameChar(match.charAt(i))) continue;
            isName = false;
            break;
        }
        if (isName) {
            // empty if block
        }
        if (this.defaultMode != null) {
            template.setAttribute("mode", this.defaultMode);
        }
        template.setLocation(filename, filename, line, 0);
        this.text.clear();
        this.inTemplate = true;
        if (tail == '>') {
            if (this.rawText) {
                template.setAttribute("xml:space", "preserve");
            }
            this.parseNode(template, ">>", false, this.read());
            this.inTemplate = false;
            return;
        }
        QNode scriptlet = (QNode)((Object)this.xsl.createElementNS(XTPNS, element));
        scriptlet.setLocation(filename, filename, line, 0);
        while (ch >= 0) {
            if (ch == tail) {
                ch = this.read();
                if (ch == 62) break;
                this.addText(tail);
                continue;
            }
            this.addText((char)ch);
            ch = this.read();
        }
        scriptlet.appendChild(this.xsl.createTextNode(this.text.toString()));
        template.appendChild(scriptlet);
        this.text.clear();
        this.inTemplate = false;
    }

    private void parseBlock(Node parent, int ch) throws IOException, XslParseException {
        char tail = '#';
        String element = "xtp:scriptlet";
        while (XmlChar.isWhitespace((char)ch)) {
            ch = this.read();
        }
        if (ch == 59) {
            return;
        }
        if (ch != 60) {
            throw this.error(L.l("expected `{0}' at {1}", (Object)"<", this.badChar(ch)));
        }
        String filename = this.is.getUserPath();
        int line = this.line;
        ch = this.read();
        if (ch == 35) {
            tail = '#';
            ch = this.read();
            if (ch == 61) {
                ch = this.read();
                element = "xtp:expression";
            }
        } else if (ch == 60) {
            tail = '>';
        } else {
            throw this.error(L.l("expected block at {1}", (Object)"block", this.badChar(ch)));
        }
        if (tail == '>') {
            if (this.rawText) {
                ((Element)parent).setAttribute("xml:space", "preserve");
            }
            this.parseNode(parent, ">>", false, this.read());
            return;
        }
        QNode scriptlet = (QNode)((Object)this.xsl.createElementNS(XTPNS, element));
        scriptlet.setLocation(filename, filename, line, 0);
        while (ch >= 0) {
            if (ch == tail) {
                ch = this.read();
                if (ch == 62) break;
                this.addText(tail);
                continue;
            }
            this.addText((char)ch);
            ch = this.read();
        }
        scriptlet.appendChild(this.xsl.createTextNode(this.text.toString()));
        parent.appendChild(scriptlet);
        this.text.clear();
    }

    private void addText(char ch) {
        if (this.text.length() == 0) {
            this.textLine = ch == '\n' ? this.line - 1 : this.line;
        }
        this.text.append(ch);
    }

    private void addText(String s) {
        if (this.text.length() == 0) {
            this.textLine = this.line;
        }
        this.text.append(s);
    }

    private int skipWhitespace(int ch) throws IOException {
        while (XmlChar.isWhitespace(ch)) {
            ch = this.read();
        }
        return ch;
    }

    private int readTag(int ch) throws IOException {
        this.tag.clear();
        while (XmlChar.isNameChar(ch)) {
            this.tag.append((char)ch);
            ch = this.read();
        }
        return ch;
    }

    private int readValue(int ch) throws IOException, XslParseException {
        this.tag.clear();
        if (ch == 39) {
            ch = this.read();
            while (ch >= 0 && ch != 39) {
                if (ch == 38) {
                    ch = this.parseEntityReference();
                    this.tag.append(this.text);
                    this.text.clear();
                    this.unread(ch);
                } else {
                    this.tag.append((char)ch);
                }
                ch = this.read();
            }
            if (ch != 39) {
                throw this.error(L.l("expected `{0}' at {1}", (Object)"'", this.badChar(ch)));
            }
            return this.read();
        }
        if (ch == 34) {
            ch = this.read();
            while (ch >= 0 && ch != 34) {
                if (ch == 38) {
                    ch = this.parseEntityReference();
                    this.tag.append(this.text);
                    this.text.clear();
                    this.unread(ch);
                } else {
                    this.tag.append((char)ch);
                }
                ch = this.read();
            }
            if (ch != 34) {
                throw this.error(L.l("expected `{0}' at {1}", (Object)"\"", this.badChar(ch)));
            }
            return this.read();
        }
        if (XmlChar.isNameChar(ch)) {
            while (XmlChar.isNameChar(ch)) {
                this.tag.append((char)ch);
                ch = this.read();
            }
            return ch;
        }
        throw this.error(L.l("expected attribute value at {0}", this.badChar(ch)));
    }

    private void addText(Node parent) {
        if (this.text.getLength() != 0) {
            Text textNode = this.xsl.createTextNode(this.text.toString());
            QAbstractNode node = (QAbstractNode)((Object)textNode);
            node.setLocation(this.is.getURL(), this.is.getUserPath(), this.textLine, 0);
            parent.appendChild(textNode);
        }
        this.text.clear();
    }

    private XslParseException error(String message) {
        return new XslParseException(this.getFilename() + ":" + this.getLine() + ": " + message);
    }

    private XslParseException error(Exception e) {
        if (e.getMessage() != null) {
            return new XslParseException(this.getFilename() + ":" + this.getLine() + ": " + e.getMessage());
        }
        return new XslParseException(this.getFilename() + ":" + this.getLine() + ": " + e);
    }

    private String getFilename() {
        return this.is.getPath().getUserPath();
    }

    private int getLine() {
        return this.line;
    }

    private String badChar(int ch) {
        if (ch < 0) {
            return L.l("end of file");
        }
        if (ch == 10 || ch == 13) {
            return L.l("end of line");
        }
        return "`" + (char)ch + "'";
    }

    public int read() throws IOException {
        if (this.peek >= 0) {
            int ch = this.peek;
            this.peek = -1;
            return ch;
        }
        int ch = this.is.readChar();
        if (ch == 13) {
            ch = this.is.readChar();
            if (ch != 10 && ch >= 0) {
                this.peek = ch == 13 ? 10 : ch;
            }
            ch = 10;
        }
        if (ch == 10) {
            ++this.line;
        }
        return ch;
    }

    void unread(int ch) {
        this.peek = ch;
    }

    static {
        _xslCommands.put("apply-templates", "select");
        _xslCommands.put("call-template", "name");
        _xslCommands.put("apply-imports", "");
        _xslCommands.put("for-each", "select");
        _xslCommands.put("value-of", "select");
        _xslCommands.put("copy-of", "select");
        _xslCommands.put("number", "value");
        _xslCommands.put("choose", "");
        _xslCommands.put("when", "test");
        _xslCommands.put("otherwise", "");
        _xslCommands.put("if", "test");
        _xslCommands.put("text", "");
        _xslCommands.put("copy", "");
        _xslCommands.put("variable", "name");
        _xslCommands.put("param", "name");
        _xslCommands.put("with-param", "name");
        _xslCommands.put("message", "");
        _xslCommands.put("fallback", "");
        _xslCommands.put("processing-instruction", "name");
        _xslCommands.put("comment", "");
        _xslCommands.put("element", "name");
        _xslCommands.put("attribute", "name");
        _xslCommands.put("import", "href");
        _xslCommands.put("include", "href");
        _xslCommands.put("strip-space", "elements");
        _xslCommands.put("preserve-space", "elements");
        _xslCommands.put("output", "");
        _xslCommands.put("key", "");
        _xslCommands.put("decimal-format", "");
        _xslCommands.put("attribute-set", "name");
        _xslCommands.put("variable", "name");
        _xslCommands.put("param", "name");
        _xslCommands.put("template", "match");
        _xslCommands.put("namespace-alias", "");
        _xslCommands.put("result-document", "href");
        _xtpCommands = new HashMap();
        _xtpCommands.put("while", "test");
        _xtpCommands.put("expression", "expr");
        _xtpCommands.put("expr", "expr");
        _xtpCommands.put("scriptlet", "");
        _xtpCommands.put("declaration", "");
        _xtpCommands.put("directive.page", "");
        _xtpCommands.put("directive.cache", "");
    }
}

