/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.tools.doclets.formats.html;

import com.liferay.tools.doclets.formats.html.AbstractExecutableMemberWriter;
import com.liferay.tools.doclets.formats.html.ClassWriterImpl;
import com.liferay.tools.doclets.formats.html.ConfigurationImpl;
import com.liferay.tools.doclets.formats.html.LinkInfoImpl;
import com.liferay.tools.doclets.formats.html.SubWriterHolderWriter;
import com.liferay.tools.doclets.formats.html.TagletOutputImpl;
import com.liferay.tools.doclets.internal.toolkit.taglets.DeprecatedTaglet;
import com.liferay.tools.doclets.internal.toolkit.util.Util;
import com.liferay.tools.doclets.internal.toolkit.util.VisibleMemberMap;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.SourcePosition;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import java.lang.reflect.Modifier;
import java.util.List;

public abstract class AbstractMemberWriter {
    protected boolean printedSummaryHeader = false;
    protected final SubWriterHolderWriter writer;
    protected final ClassDoc classdoc;
    public final boolean nodepr;

    public AbstractMemberWriter(SubWriterHolderWriter writer, ClassDoc classdoc) {
        this.writer = writer;
        this.nodepr = this.configuration().nodeprecated;
        this.classdoc = classdoc;
    }

    public AbstractMemberWriter(SubWriterHolderWriter writer) {
        this(writer, null);
    }

    public abstract void printSummaryLabel(ClassDoc var1);

    public abstract void printInheritedSummaryLabel(ClassDoc var1);

    public abstract void printSummaryAnchor(ClassDoc var1);

    public abstract void printInheritedSummaryAnchor(ClassDoc var1);

    protected abstract void printSummaryType(ProgramElementDoc var1);

    protected void writeSummaryLink(ClassDoc cd, ProgramElementDoc member) {
        this.writeSummaryLink(3, cd, member);
    }

    protected abstract void writeSummaryLink(int var1, ClassDoc var2, ProgramElementDoc var3);

    protected abstract void writeInheritedSummaryLink(ClassDoc var1, ProgramElementDoc var2);

    protected abstract void writeDeprecatedLink(ProgramElementDoc var1);

    protected abstract void printNavSummaryLink(ClassDoc var1, boolean var2);

    protected abstract void printNavDetailLink(boolean var1);

    protected void print(String str) {
        this.writer.print(str);
        this.writer.displayLength += str.length();
    }

    protected void print(char ch) {
        this.writer.print(ch);
        ++this.writer.displayLength;
    }

    protected void bold(String str) {
        this.writer.bold(str);
        this.writer.displayLength += str.length();
    }

    protected String modifierString(MemberDoc member) {
        int ms = member.modifierSpecifier();
        int no = 288;
        return Modifier.toString(ms & ~no);
    }

    protected String typeString(MemberDoc member) {
        String type = "";
        if (member instanceof MethodDoc) {
            type = ((MethodDoc)member).returnType().toString();
        } else if (member instanceof FieldDoc) {
            type = ((FieldDoc)member).type().toString();
        }
        return type;
    }

    protected void printModifiers(MemberDoc member) {
        String mod = this.modifierString(member);
        if ((member.isField() || member.isMethod()) && this.writer instanceof ClassWriterImpl && ((ClassWriterImpl)this.writer).getClassDoc().isInterface()) {
            mod = Util.replaceText(mod, "public", "").trim();
        }
        if (mod.length() > 0) {
            this.print(mod);
            this.print(' ');
        }
    }

    protected String makeSpace(int len) {
        if (len <= 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    protected void printStaticAndType(boolean isStatic, Type type) {
        this.writer.printTypeSummaryHeader();
        if (isStatic) {
            this.print("static");
        }
        this.writer.space();
        if (type != null) {
            this.writer.printLink(new LinkInfoImpl(3, type));
        }
        this.writer.printTypeSummaryFooter();
    }

    protected void printModifierAndType(ProgramElementDoc member, Type type) {
        this.writer.printTypeSummaryHeader();
        this.printModifier(member);
        if (type == null) {
            this.writer.space();
            if (member.isClass()) {
                this.print("class");
            } else {
                this.print("interface");
            }
        } else if (member instanceof ExecutableMemberDoc && ((ExecutableMemberDoc)member).typeParameters().length > 0) {
            this.writer.table(0, 0, 0);
            this.writer.trAlignVAlign("right", "");
            this.writer.tdNowrap();
            this.writer.font("-1");
            this.writer.code();
            int displayLength = ((AbstractExecutableMemberWriter)this).writeTypeParameters((ExecutableMemberDoc)member);
            if (displayLength > 10) {
                this.writer.br();
            }
            this.writer.printLink(new LinkInfoImpl(17, type));
            this.writer.codeEnd();
            this.writer.fontEnd();
            this.writer.tdEnd();
            this.writer.trEnd();
            this.writer.tableEnd();
        } else {
            this.writer.space();
            this.writer.printLink(new LinkInfoImpl(17, type));
        }
        this.writer.printTypeSummaryFooter();
    }

    private void printModifier(ProgramElementDoc member) {
        if (member.isProtected()) {
            this.print("protected ");
        } else if (member.isPrivate()) {
            this.print("private ");
        } else if (!member.isPublic()) {
            this.writer.printText("doclet.Package_private");
            this.print(" ");
        }
        if (member.isMethod() && ((MethodDoc)member).isAbstract()) {
            this.print("abstract ");
        }
        if (member.isStatic()) {
            this.print("static");
        }
    }

    protected void printComment(ProgramElementDoc member) {
        if (member.inlineTags().length > 0) {
            this.writer.dd();
            this.writer.printInlineComment((Doc)member);
        }
    }

    protected String name(ProgramElementDoc member) {
        return member.name();
    }

    protected void printHead(MemberDoc member) {
        this.writer.h3();
        this.writer.print(member.name());
        this.writer.h3End();
    }

    protected void printFullComment(ProgramElementDoc member) {
        if (this.configuration().nocomment) {
            return;
        }
        this.writer.dl();
        this.print(((TagletOutputImpl)new DeprecatedTaglet().getTagletOutput((Doc)member, this.writer.getTagletWriterInstance(false))).toString());
        this.printCommentAndTags(member);
        this.writer.dlEnd();
    }

    protected void printCommentAndTags(ProgramElementDoc member) {
        this.printComment(member);
        this.writer.printTags((Doc)member);
    }

    public void printSummaryHeader(ClassDoc cd) {
        this.printedSummaryHeader = true;
        this.writer.printSummaryHeader(this, cd);
    }

    public void printInheritedSummaryHeader(ClassDoc cd) {
        this.writer.printInheritedSummaryHeader(this, cd);
    }

    public void printInheritedSummaryFooter(ClassDoc cd) {
        this.writer.printInheritedSummaryFooter(this, cd);
    }

    public void printSummaryFooter(ClassDoc cd) {
        this.writer.printSummaryFooter(this, cd);
    }

    protected boolean isInherited(ProgramElementDoc ped) {
        return !ped.isPrivate() && (!ped.isPackagePrivate() || ped.containingPackage().equals(this.classdoc.containingPackage()));
    }

    protected void printDeprecatedAPI(List deprmembers, String headingKey) {
        if (deprmembers.size() > 0) {
            this.writer.tableIndexSummary();
            this.writer.tableHeaderStart("#CCCCFF");
            this.writer.boldText(headingKey);
            this.writer.tableHeaderEnd();
            for (int i = 0; i < deprmembers.size(); ++i) {
                ProgramElementDoc member = (ProgramElementDoc)deprmembers.get(i);
                this.writer.trBgcolorStyle("white", "TableRowColor");
                this.writer.summaryRow(0);
                this.writeDeprecatedLink(member);
                this.writer.br();
                this.writer.printNbsps();
                if (member.tags("deprecated").length > 0) {
                    this.writer.printInlineDeprecatedComment((Doc)member, member.tags("deprecated")[0]);
                }
                this.writer.space();
                this.writer.summaryRowEnd();
                this.writer.trEnd();
            }
            this.writer.tableEnd();
            this.writer.space();
            this.writer.p();
        }
    }

    protected void printUseInfo(Object mems, String heading) {
        if (mems == null) {
            return;
        }
        List members = (List)mems;
        if (members.size() > 0) {
            this.writer.tableIndexSummary();
            this.writer.tableUseInfoHeaderStart("#CCCCFF");
            this.writer.print(heading);
            this.writer.tableHeaderEnd();
            for (ProgramElementDoc pgmdoc : members) {
                ClassDoc cd = pgmdoc.containingClass();
                this.writer.printSummaryLinkType(this, pgmdoc);
                if (cd != null && !(pgmdoc instanceof ConstructorDoc) && !(pgmdoc instanceof ClassDoc)) {
                    this.writer.bold(cd.name() + ".");
                }
                this.writeSummaryLink(pgmdoc instanceof ClassDoc ? 4 : 3, cd, pgmdoc);
                this.writer.printSummaryLinkComment(this, pgmdoc);
            }
            this.writer.tableEnd();
            this.writer.space();
            this.writer.p();
        }
    }

    protected void navDetailLink(List members) {
        this.printNavDetailLink(members.size() > 0);
    }

    protected void navSummaryLink(List members, VisibleMemberMap visibleMemberMap) {
        if (members.size() > 0) {
            this.printNavSummaryLink(null, true);
            return;
        }
        for (ClassDoc icd = this.classdoc.superclass(); icd != null; icd = icd.superclass()) {
            List inhmembers = visibleMemberMap.getMembersFor(icd);
            if (inhmembers.size() <= 0) continue;
            this.printNavSummaryLink(icd, true);
            return;
        }
        this.printNavSummaryLink(null, false);
    }

    protected void serialWarning(SourcePosition pos, String key, String a1, String a2) {
        if (this.configuration().serialwarn) {
            ConfigurationImpl.getInstance().getDocletSpecificMsg().warning(pos, key, a1, a2);
        }
    }

    public ProgramElementDoc[] eligibleMembers(ProgramElementDoc[] members) {
        return this.nodepr ? Util.excludeDeprecatedMembers(members) : members;
    }

    public ConfigurationImpl configuration() {
        return this.writer.configuration;
    }

    public void writeMemberSummary(ClassDoc classDoc, ProgramElementDoc member, Tag[] firstSentenceTags, boolean isFirst, boolean isLast) {
        this.writer.printSummaryLinkType(this, member);
        this.writeSummaryLink(classDoc, member);
        this.writer.printSummaryLinkComment(this, member, firstSentenceTags);
    }
}

