/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.tools.doclets.formats.html;

import com.liferay.tools.doclets.formats.html.AbstractMemberWriter;
import com.liferay.tools.doclets.formats.html.ConfigurationImpl;
import com.liferay.tools.doclets.formats.html.LinkInfoImpl;
import com.liferay.tools.doclets.formats.html.SubWriterHolderWriter;
import com.liferay.tools.doclets.internal.toolkit.ClassWriter;
import com.liferay.tools.doclets.internal.toolkit.builders.MemberSummaryBuilder;
import com.liferay.tools.doclets.internal.toolkit.taglets.ParamTaglet;
import com.liferay.tools.doclets.internal.toolkit.taglets.TagletOutput;
import com.liferay.tools.doclets.internal.toolkit.util.ClassTree;
import com.liferay.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.liferay.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.liferay.tools.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import java.util.List;

public class ClassWriterImpl
extends SubWriterHolderWriter
implements ClassWriter {
    protected ClassDoc classDoc;
    protected ClassTree classtree;
    protected ClassDoc prev;
    protected ClassDoc next;

    public ClassWriterImpl(ClassDoc classDoc, ClassDoc prevClass, ClassDoc nextClass, ClassTree classTree) throws Exception {
        super(ConfigurationImpl.getInstance(), DirectoryManager.getDirectoryPath(classDoc.containingPackage()), classDoc.name() + ".html", DirectoryManager.getRelativePath(classDoc.containingPackage().name()));
        this.classDoc = classDoc;
        this.configuration.currentcd = classDoc;
        this.classtree = classTree;
        this.prev = prevClass;
        this.next = nextClass;
    }

    protected void navLinkPackage() {
        this.navCellStart();
        this.printHyperLink("package-summary.html", "", this.configuration.getText("doclet.Package"), true, "NavBarFont1");
        this.navCellEnd();
    }

    protected void navLinkClass() {
        this.navCellRevStart();
        this.fontStyle("NavBarFont1Rev");
        this.boldText("doclet.Class");
        this.fontEnd();
        this.navCellEnd();
    }

    protected void navLinkClassUse() {
        this.navCellStart();
        this.printHyperLink("class-use/" + this.filename, "", this.configuration.getText("doclet.navClassUse"), true, "NavBarFont1");
        this.navCellEnd();
    }

    protected void navLinkPrevious() {
        if (this.prev == null) {
            this.printText("doclet.Prev_Class");
        } else {
            this.printLink(new LinkInfoImpl(2, this.prev, "", this.configuration.getText("doclet.Prev_Class"), true));
        }
    }

    protected void navLinkNext() {
        if (this.next == null) {
            this.printText("doclet.Next_Class");
        } else {
            this.printLink(new LinkInfoImpl(2, this.next, "", this.configuration.getText("doclet.Next_Class"), true));
        }
    }

    public void writeHeader(String header) {
        String pkgname = this.classDoc.containingPackage() != null ? this.classDoc.containingPackage().name() : "";
        String clname = this.classDoc.name();
        this.printHtmlHeader(clname, this.configuration.metakeywords.getMetaKeywords(this.classDoc), true);
        this.printTop();
        this.navLinks(true);
        this.hr();
        this.println("<!-- ======== START OF CLASS DATA ======== -->");
        this.h2();
        if (pkgname.length() > 0) {
            this.font("-1");
            this.print(pkgname);
            this.fontEnd();
            this.br();
        }
        LinkInfoImpl linkInfo = new LinkInfoImpl(14, this.classDoc, false);
        linkInfo.linkToSelf = false;
        this.print(header + this.getTypeParameterLinks(linkInfo));
        this.h2End();
    }

    public void writeFooter() {
        this.println("<!-- ========= END OF CLASS DATA ========= -->");
        this.hr();
        this.navLinks(false);
        this.printBottom();
        this.printBodyHtmlEnd();
    }

    public void writeClassSignature(String modifiers) {
        Type[] implIntfacs;
        Type superclass;
        boolean isInterface = this.classDoc.isInterface();
        this.dl();
        this.dt();
        this.preNoNewLine();
        this.writeAnnotationInfo((ProgramElementDoc)this.classDoc);
        this.print(modifiers);
        LinkInfoImpl linkInfo = new LinkInfoImpl(15, this.classDoc, false);
        linkInfo.linkToSelf = false;
        String name = this.classDoc.name() + this.getTypeParameterLinks(linkInfo);
        if (this.configuration().linksource) {
            this.printSrcLink((ProgramElementDoc)this.classDoc, name);
        } else {
            this.bold(name);
        }
        if (!isInterface && (superclass = Util.getFirstVisibleSuperClass(this.classDoc, this.configuration())) != null) {
            this.dt();
            this.print("extends ");
            this.printLink(new LinkInfoImpl(24, superclass));
        }
        if ((implIntfacs = this.classDoc.interfaceTypes()) != null && implIntfacs.length > 0) {
            int counter = 0;
            for (int i = 0; i < implIntfacs.length; ++i) {
                ClassDoc classDoc = implIntfacs[i].asClassDoc();
                if (!classDoc.isPublic() && !Util.isLinkable(classDoc, this.configuration())) continue;
                if (counter == 0) {
                    this.dt();
                    this.print(isInterface ? "extends " : "implements ");
                } else {
                    this.print(", ");
                }
                this.printLink(new LinkInfoImpl(24, implIntfacs[i]));
                ++counter;
            }
        }
        this.dlEnd();
        this.preEnd();
        this.p();
    }

    public void writeClassDescription() {
        if (!this.configuration.nocomment && this.classDoc.inlineTags().length > 0) {
            this.printInlineComment((Doc)this.classDoc);
            this.p();
        }
    }

    public void writeClassTagInfo() {
        if (!this.configuration.nocomment) {
            this.printTags((Doc)this.classDoc);
            this.hr();
            this.p();
        } else {
            this.hr();
        }
    }

    public void writeClassDeprecationInfo() {
        this.hr();
        Tag[] deprs = this.classDoc.tags("deprecated");
        if (Util.isDeprecated((ProgramElementDoc)this.classDoc)) {
            Tag[] commentTags;
            this.boldText("doclet.Deprecated");
            if (deprs.length > 0 && (commentTags = deprs[0].inlineTags()).length > 0) {
                this.space();
                this.printInlineDeprecatedComment((Doc)this.classDoc, deprs[0]);
            }
            this.p();
        }
    }

    private void writeStep(int indent) {
        this.print(this.spaces(4 * indent - 2));
        this.print("<IMG SRC=\"" + this.relativepathNoSlash + "/resources/inherit.gif\" " + "ALT=\"" + this.configuration.getText("doclet.extended_by") + " \">");
    }

    private int writeTreeForClassHelper(Type type) {
        Type sup = Util.getFirstVisibleSuperClass(type instanceof ClassDoc ? (ClassDoc)type : type.asClassDoc(), this.configuration());
        int indent = 0;
        if (sup != null) {
            indent = this.writeTreeForClassHelper(sup);
            this.writeStep(indent);
        }
        if (type.equals(this.classDoc)) {
            String typeParameters = this.getTypeParameterLinks(new LinkInfoImpl(12, this.classDoc, false));
            if (this.configuration.shouldExcludeQualifier(this.classDoc.containingPackage().name())) {
                this.bold(type.asClassDoc().name() + typeParameters);
            } else {
                this.bold(type.asClassDoc().qualifiedName() + typeParameters);
            }
        } else {
            this.print(this.getLink(new LinkInfoImpl(31, (Type)(type instanceof ClassDoc ? (ClassDoc)type : type), this.configuration.getClassName(type.asClassDoc()), false)));
        }
        this.println();
        return indent + 1;
    }

    public void writeClassTree() {
        if (!this.classDoc.isClass()) {
            return;
        }
        this.pre();
        this.writeTreeForClassHelper((Type)this.classDoc);
        this.preEnd();
    }

    public void writeTypeParamInfo() {
        if (this.classDoc.typeParamTags().length > 0) {
            this.dl();
            this.dt();
            TagletOutput output = new ParamTaglet().getTagletOutput((Doc)this.classDoc, this.getTagletWriterInstance(false));
            this.print(output.toString());
            this.dlEnd();
        }
    }

    public void writeSubClassInfo() {
        if (this.classDoc.isClass()) {
            if (this.classDoc.qualifiedName().equals("java.lang.Object") || this.classDoc.qualifiedName().equals("org.omg.CORBA.Object")) {
                return;
            }
            List subclasses = this.classtree.subs(this.classDoc, false);
            if (subclasses.size() > 0) {
                this.dl();
                this.dt();
                this.boldText("doclet.Subclasses");
                this.writeClassLinks(23, subclasses);
            }
        }
    }

    public void writeSubInterfacesInfo() {
        List subInterfaces;
        if (this.classDoc.isInterface() && (subInterfaces = this.classtree.allSubs(this.classDoc, false)).size() > 0) {
            this.dl();
            this.dt();
            this.boldText("doclet.Subinterfaces");
            this.writeClassLinks(22, subInterfaces);
        }
    }

    public void writeInterfaceUsageInfo() {
        if (!this.classDoc.isInterface()) {
            return;
        }
        if (this.classDoc.qualifiedName().equals("java.lang.Cloneable") || this.classDoc.qualifiedName().equals("java.io.Serializable")) {
            return;
        }
        List implcl = this.classtree.implementingclasses(this.classDoc);
        if (implcl.size() > 0) {
            this.dl();
            this.dt();
            this.boldText("doclet.Implementing_Classes");
            this.writeClassLinks(21, implcl);
        }
    }

    public void writeImplementedInterfacesInfo() {
        List interfaceArray = Util.getAllInterfaces((Type)this.classDoc, this.configuration);
        if (this.classDoc.isClass() && interfaceArray.size() > 0) {
            this.dl();
            this.dt();
            this.boldText("doclet.All_Implemented_Interfaces");
            this.writeClassLinks(20, interfaceArray);
        }
    }

    public void writeSuperInterfacesInfo() {
        List interfaceArray = Util.getAllInterfaces((Type)this.classDoc, this.configuration);
        if (this.classDoc.isInterface() && interfaceArray.size() > 0) {
            this.dl();
            this.dt();
            this.boldText("doclet.All_Superinterfaces");
            this.writeClassLinks(19, interfaceArray);
        }
    }

    private void writeClassLinks(int context, List list) {
        Object[] typeList = list.toArray();
        this.print(' ');
        this.dd();
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                this.print(", ");
            }
            if (typeList[i] instanceof ClassDoc) {
                this.printLink(new LinkInfoImpl(context, (Type)((ClassDoc)typeList[i])));
                continue;
            }
            this.printLink(new LinkInfoImpl(context, (Type)typeList[i]));
        }
        this.ddEnd();
        this.dlEnd();
    }

    protected void navLinkTree() {
        this.navCellStart();
        this.printHyperLink("package-tree.html", "", this.configuration.getText("doclet.Tree"), true, "NavBarFont1");
        this.navCellEnd();
    }

    protected void printSummaryDetailLinks() {
        try {
            this.tr();
            this.tdVAlignClass("top", "NavBarCell3");
            this.font("-2");
            this.print("  ");
            this.navSummaryLinks();
            this.fontEnd();
            this.tdEnd();
            this.tdVAlignClass("top", "NavBarCell3");
            this.font("-2");
            this.navDetailLinks();
            this.fontEnd();
            this.tdEnd();
            this.trEnd();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DocletAbortException();
        }
    }

    protected void navSummaryLinks() throws Exception {
        this.printText("doclet.Summary");
        this.space();
        MemberSummaryBuilder memberSummaryBuilder = (MemberSummaryBuilder)this.configuration.getBuilderFactory().getMemberSummaryBuilder(this);
        String[] navLinkLabels = new String[]{"doclet.navNested", "doclet.navEnum", "doclet.navField", "doclet.navConstructor", "doclet.navMethod"};
        for (int i = 0; i < navLinkLabels.length; ++i) {
            if (i == 1 && !this.classDoc.isEnum() || i == 3 && this.classDoc.isEnum()) continue;
            AbstractMemberWriter writer = (AbstractMemberWriter)((Object)memberSummaryBuilder.getMemberSummaryWriter(i));
            if (writer == null) {
                this.printText(navLinkLabels[i]);
            } else {
                writer.navSummaryLink(memberSummaryBuilder.members(i), memberSummaryBuilder.getVisibleMemberMap(i));
            }
            if (i >= navLinkLabels.length - 1) continue;
            this.navGap();
        }
    }

    protected void navDetailLinks() throws Exception {
        this.printText("doclet.Detail");
        this.space();
        MemberSummaryBuilder memberSummaryBuilder = (MemberSummaryBuilder)this.configuration.getBuilderFactory().getMemberSummaryBuilder(this);
        String[] navLinkLabels = new String[]{"doclet.navNested", "doclet.navEnum", "doclet.navField", "doclet.navConstructor", "doclet.navMethod"};
        for (int i = 1; i < navLinkLabels.length; ++i) {
            AbstractMemberWriter writer = (AbstractMemberWriter)((Object)memberSummaryBuilder.getMemberSummaryWriter(i));
            if (i == 1 && !this.classDoc.isEnum() || i == 3 && this.classDoc.isEnum()) continue;
            if (writer == null) {
                this.printText(navLinkLabels[i]);
            } else {
                writer.navDetailLink(memberSummaryBuilder.members(i));
            }
            if (i >= navLinkLabels.length - 1) continue;
            this.navGap();
        }
    }

    protected void navGap() {
        this.space();
        this.print('|');
        this.space();
    }

    public void writeNestedClassInfo() {
        ClassDoc outerClass = this.classDoc.containingClass();
        if (outerClass != null) {
            this.dl();
            this.dt();
            if (outerClass.isInterface()) {
                this.boldText("doclet.Enclosing_Interface");
            } else {
                this.boldText("doclet.Enclosing_Class");
            }
            this.dd();
            this.printLink(new LinkInfoImpl(2, outerClass, false));
            this.ddEnd();
            this.dlEnd();
        }
    }

    public ClassDoc getClassDoc() {
        return this.classDoc;
    }

    public void completeMemberSummaryBuild() {
        this.p();
    }
}

