/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.tools.doclets.formats.html;

import com.liferay.tools.doclets.formats.html.AbstractMemberWriter;
import com.liferay.tools.doclets.formats.html.LinkInfoImpl;
import com.liferay.tools.doclets.formats.html.SubWriterHolderWriter;
import com.liferay.tools.doclets.formats.html.TagletOutputImpl;
import com.liferay.tools.doclets.internal.toolkit.EnumConstantWriter;
import com.liferay.tools.doclets.internal.toolkit.MemberSummaryWriter;
import com.liferay.tools.doclets.internal.toolkit.taglets.DeprecatedTaglet;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.ProgramElementDoc;
import java.io.IOException;

public class EnumConstantWriterImpl
extends AbstractMemberWriter
implements EnumConstantWriter,
MemberSummaryWriter {
    private boolean printedSummaryHeader = false;

    public EnumConstantWriterImpl(SubWriterHolderWriter writer, ClassDoc classdoc) {
        super(writer, classdoc);
    }

    public EnumConstantWriterImpl(SubWriterHolderWriter writer) {
        super(writer);
    }

    public void writeMemberSummaryHeader(ClassDoc classDoc) {
        this.printedSummaryHeader = true;
        this.writer.println("<!-- =========== ENUM CONSTANT SUMMARY =========== -->");
        this.writer.println();
        this.writer.printSummaryHeader(this, classDoc);
    }

    public void writeMemberSummaryFooter(ClassDoc classDoc) {
        this.writer.printSummaryFooter(this, classDoc);
    }

    public void writeInheritedMemberSummaryHeader(ClassDoc classDoc) {
        if (!this.printedSummaryHeader) {
            this.writeMemberSummaryHeader(classDoc);
            this.writeMemberSummaryFooter(classDoc);
            this.printedSummaryHeader = true;
        }
        this.writer.printInheritedSummaryHeader(this, classDoc);
    }

    public void writeInheritedMemberSummary(ClassDoc classDoc, ProgramElementDoc enumConstant, boolean isFirst, boolean isLast) {
        this.writer.printInheritedSummaryMember(this, classDoc, enumConstant, isFirst);
    }

    public void writeInheritedMemberSummaryFooter(ClassDoc classDoc) {
        this.writer.printInheritedSummaryFooter(this, classDoc);
    }

    public void writeHeader(ClassDoc classDoc, String header) {
        this.writer.println();
        this.writer.println("<!-- ============ ENUM CONSTANT DETAIL =========== -->");
        this.writer.println();
        this.writer.anchor("enum_constant_detail");
        this.writer.printTableHeadingBackground(header);
        this.writer.println();
    }

    public void writeEnumConstantHeader(FieldDoc enumConstant, boolean isFirst) {
        if (!isFirst) {
            this.writer.printMemberHeader();
            this.writer.println("");
        }
        this.writer.anchor(enumConstant.name());
        this.writer.h3();
        this.writer.print(enumConstant.name());
        this.writer.h3End();
    }

    public void writeSignature(FieldDoc enumConstant) {
        this.writer.pre();
        this.writer.writeAnnotationInfo((ProgramElementDoc)enumConstant);
        this.printModifiers((MemberDoc)enumConstant);
        this.writer.printLink(new LinkInfoImpl(3, enumConstant.type()));
        this.print(' ');
        if (this.configuration().linksource) {
            this.writer.printSrcLink((ProgramElementDoc)enumConstant, enumConstant.name());
        } else {
            this.bold(enumConstant.name());
        }
        this.writer.preEnd();
        this.writer.dl();
    }

    public void writeDeprecated(FieldDoc enumConstant) {
        this.print(((TagletOutputImpl)new DeprecatedTaglet().getTagletOutput((Doc)enumConstant, this.writer.getTagletWriterInstance(false))).toString());
    }

    public void writeComments(FieldDoc enumConstant) {
        if (enumConstant.inlineTags().length > 0) {
            this.writer.dd();
            this.writer.printInlineComment((Doc)enumConstant);
        }
    }

    public void writeTags(FieldDoc enumConstant) {
        this.writer.printTags((Doc)enumConstant);
    }

    public void writeEnumConstantFooter() {
        this.writer.dlEnd();
    }

    public void writeFooter(ClassDoc classDoc) {
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public int getMemberKind() {
        return 1;
    }

    public void printSummaryLabel(ClassDoc cd) {
        this.writer.boldText("doclet.Enum_Constant_Summary");
    }

    public void printSummaryAnchor(ClassDoc cd) {
        this.writer.anchor("enum_constant_summary");
    }

    public void printInheritedSummaryAnchor(ClassDoc cd) {
    }

    public void printInheritedSummaryLabel(ClassDoc cd) {
    }

    protected void writeSummaryLink(int context, ClassDoc cd, ProgramElementDoc member) {
        this.writer.bold();
        this.writer.printDocLink(context, (MemberDoc)member, member.name(), false);
        this.writer.boldEnd();
    }

    protected void writeInheritedSummaryLink(ClassDoc cd, ProgramElementDoc member) {
        this.writer.printDocLink(3, (MemberDoc)member, member.name(), false);
    }

    protected void printSummaryType(ProgramElementDoc member) {
    }

    protected void writeDeprecatedLink(ProgramElementDoc member) {
        this.writer.printDocLink(3, (MemberDoc)member, ((FieldDoc)member).qualifiedName(), false);
    }

    protected void printNavSummaryLink(ClassDoc cd, boolean link) {
        if (link) {
            this.writer.printHyperLink("", cd == null ? "enum_constant_summary" : "enum_constants_inherited_from_class_" + this.configuration().getClassName(cd), this.configuration().getText("doclet.navEnum"));
        } else {
            this.writer.printText("doclet.navEnum");
        }
    }

    protected void printNavDetailLink(boolean link) {
        if (link) {
            this.writer.printHyperLink("", "enum_constant_detail", this.configuration().getText("doclet.navEnum"));
        } else {
            this.writer.printText("doclet.navEnum");
        }
    }
}

