/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.tools.doclets.formats.html;

import com.liferay.tools.doclets.formats.html.AbstractMemberWriter;
import com.liferay.tools.doclets.formats.html.LinkInfoImpl;
import com.liferay.tools.doclets.formats.html.SubWriterHolderWriter;
import com.liferay.tools.doclets.formats.html.TagletOutputImpl;
import com.liferay.tools.doclets.internal.toolkit.FieldWriter;
import com.liferay.tools.doclets.internal.toolkit.MemberSummaryWriter;
import com.liferay.tools.doclets.internal.toolkit.taglets.DeprecatedTaglet;
import com.liferay.tools.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.ProgramElementDoc;
import java.io.IOException;

public class FieldWriterImpl
extends AbstractMemberWriter
implements FieldWriter,
MemberSummaryWriter {
    private boolean printedSummaryHeader = false;

    public FieldWriterImpl(SubWriterHolderWriter writer, ClassDoc classdoc) {
        super(writer, classdoc);
    }

    public FieldWriterImpl(SubWriterHolderWriter writer) {
        super(writer);
    }

    public void writeMemberSummaryHeader(ClassDoc classDoc) {
        this.printedSummaryHeader = true;
        this.writer.println("<!-- =========== FIELD SUMMARY =========== -->");
        this.writer.println();
        this.writer.printSummaryHeader(this, classDoc);
    }

    public void writeMemberSummaryFooter(ClassDoc classDoc) {
        this.writer.tableEnd();
        this.writer.space();
    }

    public void writeInheritedMemberSummaryHeader(ClassDoc classDoc) {
        if (!this.printedSummaryHeader) {
            this.writeMemberSummaryHeader(classDoc);
            this.writeMemberSummaryFooter(classDoc);
            this.printedSummaryHeader = true;
        }
        this.writer.printInheritedSummaryHeader(this, classDoc);
    }

    public void writeInheritedMemberSummary(ClassDoc classDoc, ProgramElementDoc field, boolean isFirst, boolean isLast) {
        this.writer.printInheritedSummaryMember(this, classDoc, field, isFirst);
    }

    public void writeInheritedMemberSummaryFooter(ClassDoc classDoc) {
        this.writer.printInheritedSummaryFooter(this, classDoc);
    }

    public void writeHeader(ClassDoc classDoc, String header) {
        this.writer.println();
        this.writer.println("<!-- ============ FIELD DETAIL =========== -->");
        this.writer.println();
        this.writer.anchor("field_detail");
        this.writer.printTableHeadingBackground(header);
        this.writer.println();
    }

    public void writeFieldHeader(FieldDoc field, boolean isFirst) {
        if (!isFirst) {
            this.writer.printMemberHeader();
            this.writer.println("");
        }
        this.writer.anchor(field.name());
        this.writer.h3();
        this.writer.print(field.name());
        this.writer.h3End();
    }

    public void writeSignature(FieldDoc field) {
        this.writer.pre();
        this.writer.writeAnnotationInfo((ProgramElementDoc)field);
        this.printModifiers((MemberDoc)field);
        this.writer.printLink(new LinkInfoImpl(3, field.type()));
        this.print(' ');
        if (this.configuration().linksource) {
            this.writer.printSrcLink((ProgramElementDoc)field, field.name());
        } else {
            this.bold(field.name());
        }
        this.writer.preEnd();
        this.writer.dl();
    }

    public void writeDeprecated(FieldDoc field) {
        this.print(((TagletOutputImpl)new DeprecatedTaglet().getTagletOutput((Doc)field, this.writer.getTagletWriterInstance(false))).toString());
    }

    public void writeComments(FieldDoc field) {
        ClassDoc holder = field.containingClass();
        if (field.inlineTags().length > 0) {
            if (holder.equals(this.classdoc) || !holder.isPublic() && !Util.isLinkable(holder, this.configuration())) {
                this.writer.dd();
                this.writer.printInlineComment((Doc)field);
            } else {
                String classlink = this.writer.codeText(this.writer.getDocLink(30, holder, (MemberDoc)field, holder.isIncluded() ? holder.typeName() : holder.qualifiedTypeName(), false));
                this.writer.dd();
                this.writer.bold(this.configuration().getText(holder.isClass() ? "doclet.Description_From_Class" : "doclet.Description_From_Interface", classlink));
                this.writer.ddEnd();
                this.writer.dd();
                this.writer.printInlineComment((Doc)field);
            }
        }
    }

    public void writeTags(FieldDoc field) {
        this.writer.printTags((Doc)field);
    }

    public void writeFieldFooter() {
        this.writer.dlEnd();
    }

    public void writeFooter(ClassDoc classDoc) {
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public int getMemberKind() {
        return 2;
    }

    public void printSummaryLabel(ClassDoc cd) {
        this.writer.boldText("doclet.Field_Summary");
    }

    public void printSummaryAnchor(ClassDoc cd) {
        this.writer.anchor("field_summary");
    }

    public void printInheritedSummaryAnchor(ClassDoc cd) {
        this.writer.anchor("fields_inherited_from_class_" + this.configuration().getClassName(cd));
    }

    public void printInheritedSummaryLabel(ClassDoc cd) {
        String classlink = this.writer.getPreQualifiedClassLink(3, cd, false);
        this.writer.bold();
        String key = cd.isClass() ? "doclet.Fields_Inherited_From_Class" : "doclet.Fields_Inherited_From_Interface";
        this.writer.printText(key, classlink);
        this.writer.boldEnd();
    }

    protected void writeSummaryLink(int context, ClassDoc cd, ProgramElementDoc member) {
        this.writer.bold();
        this.writer.printDocLink(context, cd, (MemberDoc)member, member.name(), false);
        this.writer.boldEnd();
    }

    protected void writeInheritedSummaryLink(ClassDoc cd, ProgramElementDoc member) {
        this.writer.printDocLink(3, cd, (MemberDoc)member, member.name(), false);
    }

    protected void printSummaryType(ProgramElementDoc member) {
        FieldDoc field = (FieldDoc)member;
        this.printModifierAndType((ProgramElementDoc)field, field.type());
    }

    protected void writeDeprecatedLink(ProgramElementDoc member) {
        this.writer.printDocLink(3, (MemberDoc)member, ((FieldDoc)member).qualifiedName(), false);
    }

    protected void printNavSummaryLink(ClassDoc cd, boolean link) {
        if (link) {
            this.writer.printHyperLink("", cd == null ? "field_summary" : "fields_inherited_from_class_" + this.configuration().getClassName(cd), this.configuration().getText("doclet.navField"));
        } else {
            this.writer.printText("doclet.navField");
        }
    }

    protected void printNavDetailLink(boolean link) {
        if (link) {
            this.writer.printHyperLink("", "field_detail", this.configuration().getText("doclet.navField"));
        } else {
            this.writer.printText("doclet.navField");
        }
    }
}

