/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.tools.doclets.formats.html;

import com.liferay.tools.doclets.formats.html.AbstractTreeWriter;
import com.liferay.tools.doclets.formats.html.ConfigurationImpl;
import com.liferay.tools.doclets.internal.toolkit.Configuration;
import com.liferay.tools.doclets.internal.toolkit.util.ClassTree;
import com.liferay.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.liferay.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.liferay.tools.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.PackageDoc;
import java.io.IOException;

public class PackageTreeWriter
extends AbstractTreeWriter {
    protected PackageDoc packagedoc;
    protected PackageDoc prev;
    protected PackageDoc next;

    public PackageTreeWriter(ConfigurationImpl configuration, String path, String filename, PackageDoc packagedoc, PackageDoc prev, PackageDoc next) throws IOException {
        super(configuration, path, filename, new ClassTree(configuration.classDocCatalog.allClasses(packagedoc), (Configuration)configuration), packagedoc);
        this.packagedoc = packagedoc;
        this.prev = prev;
        this.next = next;
    }

    public static void generate(ConfigurationImpl configuration, PackageDoc pkg, PackageDoc prev, PackageDoc next, boolean noDeprecated) {
        String path = DirectoryManager.getDirectoryPath(pkg);
        String filename = "package-tree.html";
        try {
            PackageTreeWriter packgen = new PackageTreeWriter(configuration, path, filename, pkg, prev, next);
            packgen.generatePackageTreeFile();
            packgen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException();
        }
    }

    protected void generatePackageTreeFile() throws IOException {
        this.printHtmlHeader(this.packagedoc.name() + " " + this.configuration.getText("doclet.Window_Class_Hierarchy"), null, true);
        this.printPackageTreeHeader();
        if (this.configuration.packages.length > 1) {
            this.printLinkToMainTree();
        }
        this.generateTree(this.classtree.baseclasses(), "doclet.Class_Hierarchy");
        this.generateTree(this.classtree.baseinterfaces(), "doclet.Interface_Hierarchy");
        this.generateTree(this.classtree.baseAnnotationTypes(), "doclet.Annotation_Type_Hierarchy");
        this.generateTree(this.classtree.baseEnums(), "doclet.Enum_Hierarchy");
        this.printPackageTreeFooter();
        this.printBottom();
        this.printBodyHtmlEnd();
    }

    protected void printPackageTreeHeader() {
        this.printTop();
        this.navLinks(true);
        this.hr();
        this.center();
        this.h2(this.configuration.getText("doclet.Hierarchy_For_Package", Util.getPackageName(this.packagedoc)));
        this.centerEnd();
    }

    protected void printLinkToMainTree() {
        this.dl();
        this.dt();
        this.boldText("doclet.Package_Hierarchies");
        this.dd();
        this.navLinkMainTree(this.configuration.getText("doclet.All_Packages"));
        this.dlEnd();
        this.hr();
    }

    protected void printPackageTreeFooter() {
        this.hr();
        this.navLinks(false);
    }

    protected void navLinkPrevious() {
        if (this.prev == null) {
            this.navLinkPrevious(null);
        } else {
            String path = DirectoryManager.getRelativePath(this.packagedoc.name(), this.prev.name());
            this.navLinkPrevious(path + "package-tree.html");
        }
    }

    protected void navLinkNext() {
        if (this.next == null) {
            this.navLinkNext(null);
        } else {
            String path = DirectoryManager.getRelativePath(this.packagedoc.name(), this.next.name());
            this.navLinkNext(path + "package-tree.html");
        }
    }

    protected void navLinkPackage() {
        this.navCellStart();
        this.printHyperLink("package-summary.html", "", this.configuration.getText("doclet.Package"), true, "NavBarFont1");
        this.navCellEnd();
    }
}

