/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.tools.doclets.formats.html.markup;

import com.liferay.tools.doclets.internal.toolkit.Configuration;
import com.liferay.tools.doclets.internal.toolkit.util.DocletConstants;
import com.liferay.tools.doclets.internal.toolkit.util.Util;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

public class HtmlWriter
extends PrintWriter {
    protected final String htmlFilename;
    protected String winTitle;
    public static final String fileseparator = "/";
    protected Configuration configuration;

    public HtmlWriter(Configuration configuration, String path, String filename, String docencoding) throws IOException, UnsupportedEncodingException {
        super(Util.genWriter(configuration, path, filename, docencoding));
        this.configuration = configuration;
        this.htmlFilename = filename;
    }

    public void html() {
        this.println("<HTML>");
    }

    public void htmlEnd() {
        this.println("</HTML>");
    }

    protected void printWinTitleScript(String winTitle) {
        if (winTitle != null && winTitle.length() > 0) {
            this.script();
            this.println("function windowTitle()");
            this.println("{");
            this.println("    if (location.href.indexOf('is-external=true') == -1) {");
            this.println("        parent.document.title=\"" + winTitle + "\";");
            this.println("    }");
            this.println("}");
            this.scriptEnd();
            this.noScript();
            this.noScriptEnd();
        }
    }

    public void script() {
        this.println("<SCRIPT type=\"text/javascript\">");
    }

    public void scriptEnd() {
        this.println("</SCRIPT>");
    }

    public void noScript() {
        this.println("<NOSCRIPT>");
    }

    public void noScriptEnd() {
        this.println("</NOSCRIPT>");
    }

    protected String getWindowTitleOnload() {
        if (this.winTitle != null && this.winTitle.length() > 0) {
            return " onload=\"windowTitle();\"";
        }
        return "";
    }

    public void body(String bgcolor, boolean includeScript) {
        this.print("<BODY BGCOLOR=\"" + bgcolor + "\"");
        if (includeScript) {
            this.print(this.getWindowTitleOnload());
        }
        this.println(">");
    }

    public void bodyEnd() {
        this.println("</BODY>");
    }

    public void title() {
        this.println("<TITLE>");
    }

    public void title(String winTitle) {
        this.winTitle = winTitle;
        this.title();
    }

    public void titleEnd() {
        this.println("</TITLE>");
    }

    public void ul() {
        this.println("<UL>");
    }

    public void ulEnd() {
        this.println("</UL>");
    }

    public void li() {
        this.print("<LI>");
    }

    public void li(String type) {
        this.print("<LI TYPE=\"" + type + "\">");
    }

    public void h1() {
        this.println("<H1>");
    }

    public void h1End() {
        this.println("</H1>");
    }

    public void h1(String text) {
        this.h1();
        this.println(text);
        this.h1End();
    }

    public void h2() {
        this.println("<H2>");
    }

    public void h2(String text) {
        this.h2();
        this.println(text);
        this.h2End();
    }

    public void h2End() {
        this.println("</H2>");
    }

    public void h3() {
        this.println("<H3>");
    }

    public void h3(String text) {
        this.h3();
        this.println(text);
        this.h3End();
    }

    public void h3End() {
        this.println("</H3>");
    }

    public void h4() {
        this.println("<H4>");
    }

    public void h4End() {
        this.println("</H4>");
    }

    public void h4(String text) {
        this.h4();
        this.println(text);
        this.h4End();
    }

    public void h5() {
        this.println("<H5>");
    }

    public void h5End() {
        this.println("</H5>");
    }

    public void img(String imggif, String imgname, int width, int height) {
        this.println("<IMG SRC=\"images/" + imggif + ".gif\"" + " WIDTH=\"" + width + "\" HEIGHT=\"" + height + "\" ALT=\"" + imgname + "\">");
    }

    public void menu() {
        this.println("<MENU>");
    }

    public void menuEnd() {
        this.println("</MENU>");
    }

    public void pre() {
        this.println("<PRE>");
    }

    public void preNoNewLine() {
        this.print("<PRE>");
    }

    public void preEnd() {
        this.println("</PRE>");
    }

    public void hr() {
        this.println("<HR>");
    }

    public void hr(int size, int widthPercent) {
        this.println("<HR SIZE=\"" + size + "\" WIDTH=\"" + widthPercent + "%\">");
    }

    public void hr(int size, String noshade) {
        this.println("<HR SIZE=\"" + size + "\" NOSHADE>");
    }

    public String getBold() {
        return "<B>";
    }

    public String getBoldEnd() {
        return "</B>";
    }

    public void bold() {
        this.print("<B>");
    }

    public void boldEnd() {
        this.print("</B>");
    }

    public void bold(String text) {
        this.bold();
        this.print(text);
        this.boldEnd();
    }

    public void italics(String text) {
        this.print("<I>");
        this.print(text);
        this.println("</I>");
    }

    public String italicsText(String text) {
        return "<I>" + text + "</I>";
    }

    public String codeText(String text) {
        return "<CODE>" + text + "</CODE>";
    }

    public void space() {
        this.print("&nbsp;");
    }

    public void dl() {
        this.println("<DL>");
    }

    public void dlEnd() {
        this.println("</DL>");
    }

    public void dt() {
        this.print("<DT>");
    }

    public void dd() {
        this.print("<DD>");
    }

    public void ddEnd() {
        this.println("</DD>");
    }

    public void sup() {
        this.println("<SUP>");
    }

    public void supEnd() {
        this.println("</SUP>");
    }

    public void font(String size) {
        this.println("<FONT SIZE=\"" + size + "\">");
    }

    public void fontNoNewLine(String size) {
        this.print("<FONT SIZE=\"" + size + "\">");
    }

    public void fontStyle(String stylename) {
        this.print("<FONT CLASS=\"" + stylename + "\">");
    }

    public void fontSizeStyle(String size, String stylename) {
        this.println("<FONT size=\"" + size + "\" CLASS=\"" + stylename + "\">");
    }

    public void fontEnd() {
        this.print("</FONT>");
    }

    public String getFontColor(String color) {
        return "<FONT COLOR=\"" + color + "\">";
    }

    public String getFontEnd() {
        return "</FONT>";
    }

    public void center() {
        this.println("<CENTER>");
    }

    public void centerEnd() {
        this.println("</CENTER>");
    }

    public void aName(String name) {
        this.print("<A NAME=\"" + name + "\">");
    }

    public void aEnd() {
        this.print("</A>");
    }

    public void italic() {
        this.print("<I>");
    }

    public void italicEnd() {
        this.print("</I>");
    }

    public void anchor(String name, String content) {
        this.aName(name);
        this.print(content);
        this.aEnd();
    }

    public void anchor(String name) {
        this.anchor(name, "<!-- -->");
    }

    public void p() {
        this.println();
        this.println("<P>");
    }

    public void pEnd() {
        this.println();
        this.println("</P>");
    }

    public void br() {
        this.println();
        this.println("<BR>");
    }

    public void address() {
        this.println("<ADDRESS>");
    }

    public void addressEnd() {
        this.println("</ADDRESS>");
    }

    public void head() {
        this.println("<HEAD>");
    }

    public void headEnd() {
        this.println("</HEAD>");
    }

    public void code() {
        this.print("<CODE>");
    }

    public void codeEnd() {
        this.print("</CODE>");
    }

    public void em() {
        this.println("<EM>");
    }

    public void emEnd() {
        this.println("</EM>");
    }

    public void table(int border, String width, int cellpadding, int cellspacing) {
        this.println(DocletConstants.NL + "<TABLE BORDER=\"" + border + "\" WIDTH=\"" + width + "\" CELLPADDING=\"" + cellpadding + "\" CELLSPACING=\"" + cellspacing + "\" SUMMARY=\"\">");
    }

    public void table(int border, int cellpadding, int cellspacing) {
        this.println(DocletConstants.NL + "<TABLE BORDER=\"" + border + "\" CELLPADDING=\"" + cellpadding + "\" CELLSPACING=\"" + cellspacing + "\" SUMMARY=\"\">");
    }

    public void table(int border, String width) {
        this.println(DocletConstants.NL + "<TABLE BORDER=\"" + border + "\" WIDTH=\"" + width + "\" SUMMARY=\"\">");
    }

    public void table() {
        this.table(0, "100%");
    }

    public void tableEnd() {
        this.println("</TABLE>");
    }

    public void tr() {
        this.println("<TR>");
    }

    public void trEnd() {
        this.println("</TR>");
    }

    public void td() {
        this.print("<TD>");
    }

    public void tdNowrap() {
        this.print("<TD NOWRAP>");
    }

    public void tdWidth(String width) {
        this.print("<TD WIDTH=\"" + width + "\">");
    }

    public void tdEnd() {
        this.println("</TD>");
    }

    public void link(String str) {
        this.println("<LINK " + str + ">");
    }

    public void commentStart() {
        this.print("<!-- ");
    }

    public void commentEnd() {
        this.println("-->");
    }

    public void trBgcolorStyle(String color, String stylename) {
        this.println("<TR BGCOLOR=\"" + color + "\" CLASS=\"" + stylename + "\">");
    }

    public void trBgcolor(String color) {
        this.println("<TR BGCOLOR=\"" + color + "\">");
    }

    public void trAlignVAlign(String align, String valign) {
        this.println("<TR ALIGN=\"" + align + "\" VALIGN=\"" + valign + "\">");
    }

    public void thAlign(String align) {
        this.print("<TH ALIGN=\"" + align + "\">");
    }

    public void thAlignColspan(String align, int i) {
        this.print("<TH ALIGN=\"" + align + "\" COLSPAN=\"" + i + "\">");
    }

    public void thAlignNowrap(String align) {
        this.print("<TH ALIGN=\"" + align + "\" NOWRAP>");
    }

    public void thEnd() {
        this.println("</TH>");
    }

    public void tdColspan(int i) {
        this.print("<TD COLSPAN=" + i + ">");
    }

    public void tdBgcolorStyle(String color, String stylename) {
        this.print("<TD BGCOLOR=\"" + color + "\" CLASS=\"" + stylename + "\">");
    }

    public void tdColspanBgcolorStyle(int i, String color, String stylename) {
        this.print("<TD COLSPAN=" + i + " BGCOLOR=\"" + color + "\" CLASS=\"" + stylename + "\">");
    }

    public void tdAlign(String align) {
        this.print("<TD ALIGN=\"" + align + "\">");
    }

    public void tdVAlignClass(String align, String stylename) {
        this.print("<TD VALIGN=\"" + align + "\" CLASS=\"" + stylename + "\">");
    }

    public void tdVAlign(String valign) {
        this.print("<TD VALIGN=\"" + valign + "\">");
    }

    public void tdAlignVAlign(String align, String valign) {
        this.print("<TD ALIGN=\"" + align + "\" VALIGN=\"" + valign + "\">");
    }

    public void tdAlignRowspan(String align, int rowspan) {
        this.print("<TD ALIGN=\"" + align + "\" ROWSPAN=" + rowspan + ">");
    }

    public void tdAlignVAlignRowspan(String align, String valign, int rowspan) {
        this.print("<TD ALIGN=\"" + align + "\" VALIGN=\"" + valign + "\" ROWSPAN=" + rowspan + ">");
    }

    public void blockquote() {
        this.println("<BLOCKQUOTE>");
    }

    public void blockquoteEnd() {
        this.println("</BLOCKQUOTE>");
    }

    public String getCode() {
        return "<CODE>";
    }

    public String getCodeEnd() {
        return "</CODE>";
    }

    public void noFrames() {
        this.println("<NOFRAMES>");
    }

    public void noFramesEnd() {
        this.println("</NOFRAMES>");
    }
}

