/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.tools.doclets.internal.toolkit.builders;

import com.liferay.tools.doclets.internal.toolkit.AnnotationTypeRequiredMemberWriter;
import com.liferay.tools.doclets.internal.toolkit.Configuration;
import com.liferay.tools.doclets.internal.toolkit.builders.AbstractMemberBuilder;
import com.liferay.tools.doclets.internal.toolkit.util.VisibleMemberMap;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MemberDoc;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AnnotationTypeRequiredMemberBuilder
extends AbstractMemberBuilder {
    protected ClassDoc classDoc;
    protected VisibleMemberMap visibleMemberMap;
    protected AnnotationTypeRequiredMemberWriter writer;
    protected List members;
    protected int currentMemberIndex;

    protected AnnotationTypeRequiredMemberBuilder(Configuration configuration) {
        super(configuration);
    }

    public static AnnotationTypeRequiredMemberBuilder getInstance(Configuration configuration, ClassDoc classDoc, AnnotationTypeRequiredMemberWriter writer) {
        AnnotationTypeRequiredMemberBuilder builder = new AnnotationTypeRequiredMemberBuilder(configuration);
        builder.classDoc = classDoc;
        builder.writer = writer;
        builder.visibleMemberMap = new VisibleMemberMap(classDoc, 6, configuration.nodeprecated);
        builder.members = new ArrayList(builder.visibleMemberMap.getMembersFor(classDoc));
        if (configuration.getMemberComparator() != null) {
            Collections.sort(builder.members, configuration.getMemberComparator());
        }
        return builder;
    }

    public String getName() {
        return "AnnotationTypeRequiredMemberDetails";
    }

    public void invokeMethod(String methodName, Class[] paramClasses, Object[] params) throws Exception {
        Method method = this.getClass().getMethod(methodName, paramClasses);
        method.invoke((Object)this, params);
    }

    public List members(ClassDoc classDoc) {
        return this.visibleMemberMap.getMembersFor(classDoc);
    }

    public VisibleMemberMap getVisibleMemberMap() {
        return this.visibleMemberMap;
    }

    public boolean hasMembersToDocument() {
        return this.members.size() > 0;
    }

    public void buildAnnotationTypeRequiredMember(List elements) {
        if (this.writer == null) {
            return;
        }
        this.currentMemberIndex = 0;
        while (this.currentMemberIndex < this.members.size()) {
            this.build(elements);
            ++this.currentMemberIndex;
        }
    }

    public void buildHeader() {
        this.writer.writeHeader(this.classDoc, this.configuration.getText("doclet.Annotation_Type_Member_Detail"));
    }

    public void buildMemberHeader() {
        this.writer.writeMemberHeader((MemberDoc)this.members.get(this.currentMemberIndex), this.currentMemberIndex == 0);
    }

    public void buildSignature() {
        this.writer.writeSignature((MemberDoc)this.members.get(this.currentMemberIndex));
    }

    public void buildDeprecationInfo() {
        this.writer.writeDeprecated((MemberDoc)this.members.get(this.currentMemberIndex));
    }

    public void buildMemberComments() {
        if (!this.configuration.nocomment) {
            this.writer.writeComments((MemberDoc)this.members.get(this.currentMemberIndex));
        }
    }

    public void buildTagInfo() {
        this.writer.writeTags((MemberDoc)this.members.get(this.currentMemberIndex));
    }

    public void buildMemberFooter() {
        this.writer.writeMemberFooter();
    }

    public void buildFooter() {
        this.writer.writeFooter(this.classDoc);
    }

    public AnnotationTypeRequiredMemberWriter getWriter() {
        return this.writer;
    }
}

