/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.tools.doclets.internal.toolkit.builders;

import com.liferay.tools.doclets.internal.toolkit.Configuration;
import com.liferay.tools.doclets.internal.toolkit.ConstructorWriter;
import com.liferay.tools.doclets.internal.toolkit.builders.AbstractMemberBuilder;
import com.liferay.tools.doclets.internal.toolkit.util.VisibleMemberMap;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.ProgramElementDoc;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ConstructorBuilder
extends AbstractMemberBuilder {
    public static final String NAME = "ConstructorDetails";
    private int currentMethodIndex;
    private ClassDoc classDoc;
    private VisibleMemberMap visibleMemberMap;
    private ConstructorWriter writer;
    private List constructors;

    private ConstructorBuilder(Configuration configuration) {
        super(configuration);
    }

    public static ConstructorBuilder getInstance(Configuration configuration, ClassDoc classDoc, ConstructorWriter writer) {
        ConstructorBuilder builder = new ConstructorBuilder(configuration);
        builder.classDoc = classDoc;
        builder.writer = writer;
        builder.visibleMemberMap = new VisibleMemberMap(classDoc, 3, configuration.nodeprecated);
        builder.constructors = new ArrayList(builder.visibleMemberMap.getMembersFor(classDoc));
        for (int i = 0; i < builder.constructors.size(); ++i) {
            if (!((ProgramElementDoc)builder.constructors.get(i)).isProtected() && !((ProgramElementDoc)builder.constructors.get(i)).isPrivate()) continue;
            writer.setFoundNonPubConstructor(true);
        }
        if (configuration.getMemberComparator() != null) {
            Collections.sort(builder.constructors, configuration.getMemberComparator());
        }
        return builder;
    }

    public String getName() {
        return NAME;
    }

    public boolean hasMembersToDocument() {
        return this.constructors.size() > 0;
    }

    public void invokeMethod(String methodName, Class[] paramClasses, Object[] params) throws Exception {
        Method method = this.getClass().getMethod(methodName, paramClasses);
        method.invoke((Object)this, params);
    }

    public List members(ClassDoc classDoc) {
        return this.visibleMemberMap.getMembersFor(classDoc);
    }

    public ConstructorWriter getWriter() {
        return this.writer;
    }

    public void buildConstructorDoc(List elements) {
        if (this.writer == null) {
            return;
        }
        this.currentMethodIndex = 0;
        while (this.currentMethodIndex < this.constructors.size()) {
            this.build(elements);
            ++this.currentMethodIndex;
        }
    }

    public void buildHeader() {
        this.writer.writeHeader(this.classDoc, this.configuration.getText("doclet.Constructor_Detail"));
    }

    public void buildConstructorHeader() {
        this.writer.writeConstructorHeader((ConstructorDoc)this.constructors.get(this.currentMethodIndex), this.currentMethodIndex == 0);
    }

    public void buildSignature() {
        this.writer.writeSignature((ConstructorDoc)this.constructors.get(this.currentMethodIndex));
    }

    public void buildDeprecationInfo() {
        this.writer.writeDeprecated((ConstructorDoc)this.constructors.get(this.currentMethodIndex));
    }

    public void buildConstructorComments() {
        if (!this.configuration.nocomment) {
            this.writer.writeComments((ConstructorDoc)this.constructors.get(this.currentMethodIndex));
        }
    }

    public void buildTagInfo() {
        this.writer.writeTags((ConstructorDoc)this.constructors.get(this.currentMethodIndex));
    }

    public void buildConstructorFooter() {
        this.writer.writeConstructorFooter();
    }

    public void buildFooter() {
        this.writer.writeFooter(this.classDoc);
    }
}

