/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.tools.doclets.internal.toolkit.builders;

import com.liferay.tools.doclets.internal.toolkit.Configuration;
import com.liferay.tools.doclets.internal.toolkit.EnumConstantWriter;
import com.liferay.tools.doclets.internal.toolkit.builders.AbstractMemberBuilder;
import com.liferay.tools.doclets.internal.toolkit.util.VisibleMemberMap;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EnumConstantBuilder
extends AbstractMemberBuilder {
    private ClassDoc classDoc;
    private VisibleMemberMap visibleMemberMap;
    private EnumConstantWriter writer;
    private List enumConstants;
    private int currentEnumConstantsIndex;

    private EnumConstantBuilder(Configuration configuration) {
        super(configuration);
    }

    public static EnumConstantBuilder getInstance(Configuration configuration, ClassDoc classDoc, EnumConstantWriter writer) {
        EnumConstantBuilder builder = new EnumConstantBuilder(configuration);
        builder.classDoc = classDoc;
        builder.writer = writer;
        builder.visibleMemberMap = new VisibleMemberMap(classDoc, 1, configuration.nodeprecated);
        builder.enumConstants = new ArrayList(builder.visibleMemberMap.getMembersFor(classDoc));
        if (configuration.getMemberComparator() != null) {
            Collections.sort(builder.enumConstants, configuration.getMemberComparator());
        }
        return builder;
    }

    public String getName() {
        return "EnumConstantDetails";
    }

    public void invokeMethod(String methodName, Class[] paramClasses, Object[] params) throws Exception {
        Method method = this.getClass().getMethod(methodName, paramClasses);
        method.invoke((Object)this, params);
    }

    public List members(ClassDoc classDoc) {
        return this.visibleMemberMap.getMembersFor(classDoc);
    }

    public VisibleMemberMap getVisibleMemberMap() {
        return this.visibleMemberMap;
    }

    public boolean hasMembersToDocument() {
        return this.enumConstants.size() > 0;
    }

    public void buildEnumConstant(List elements) {
        if (this.writer == null) {
            return;
        }
        this.currentEnumConstantsIndex = 0;
        while (this.currentEnumConstantsIndex < this.enumConstants.size()) {
            this.build(elements);
            ++this.currentEnumConstantsIndex;
        }
    }

    public void buildHeader() {
        this.writer.writeHeader(this.classDoc, this.configuration.getText("doclet.Enum_Constant_Detail"));
    }

    public void buildEnumConstantHeader() {
        this.writer.writeEnumConstantHeader((FieldDoc)this.enumConstants.get(this.currentEnumConstantsIndex), this.currentEnumConstantsIndex == 0);
    }

    public void buildSignature() {
        this.writer.writeSignature((FieldDoc)this.enumConstants.get(this.currentEnumConstantsIndex));
    }

    public void buildDeprecationInfo() {
        this.writer.writeDeprecated((FieldDoc)this.enumConstants.get(this.currentEnumConstantsIndex));
    }

    public void buildEnumConstantComments() {
        if (!this.configuration.nocomment) {
            this.writer.writeComments((FieldDoc)this.enumConstants.get(this.currentEnumConstantsIndex));
        }
    }

    public void buildTagInfo() {
        this.writer.writeTags((FieldDoc)this.enumConstants.get(this.currentEnumConstantsIndex));
    }

    public void buildEnumConstantFooter() {
        this.writer.writeEnumConstantFooter();
    }

    public void buildFooter() {
        this.writer.writeFooter(this.classDoc);
    }

    public EnumConstantWriter getWriter() {
        return this.writer;
    }
}

