/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.tools.doclets.internal.toolkit.builders;

import com.liferay.tools.doclets.internal.toolkit.Configuration;
import com.liferay.tools.doclets.internal.toolkit.util.DocletAbortException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LayoutParser
extends DefaultHandler {
    private Map xmlElementsMap = new HashMap();
    private Configuration configuration;
    private static LayoutParser instance;
    private String currentRoot;
    private boolean isParsing;

    private LayoutParser(Configuration configuration) {
        this.configuration = configuration;
    }

    public static LayoutParser getInstance(Configuration configuration) {
        if (instance == null) {
            instance = new LayoutParser(configuration);
        }
        return instance;
    }

    public List parseXML(String root) {
        if (this.xmlElementsMap.containsKey(root)) {
            return (List)this.xmlElementsMap.get(root);
        }
        try {
            ArrayList xmlElements = new ArrayList();
            this.xmlElementsMap.put(root, xmlElements);
            this.currentRoot = root;
            this.isParsing = false;
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            InputStream in = this.configuration.getBuilderXML();
            saxParser.parse(in, (DefaultHandler)this);
            return xmlElements;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new DocletAbortException();
        }
    }

    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        if (this.isParsing || qName.equals(this.currentRoot)) {
            this.isParsing = true;
            List xmlElements = (List)this.xmlElementsMap.get(this.currentRoot);
            xmlElements.add(qName);
        }
    }

    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        if (!this.isParsing) {
            this.isParsing = false;
            return;
        }
        List xmlElements = (List)this.xmlElementsMap.get(this.currentRoot);
        if (xmlElements.get(xmlElements.size() - 1).equals(qName)) {
            return;
        }
        ArrayList subElements = new ArrayList();
        int targetIndex = xmlElements.indexOf(qName);
        int size = xmlElements.size();
        for (int i = targetIndex; i < size; ++i) {
            subElements.add(xmlElements.get(targetIndex));
            xmlElements.remove(targetIndex);
        }
        xmlElements.add(subElements);
        this.isParsing = !qName.equals(this.currentRoot);
    }
}

